/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.IdentityHashCodeNode;
import org.graalvm.word.LocationIdentity;

public abstract class IdentityHashCodeSnippets
implements Snippets {
    @Snippet
    private int identityHashCodeSnippet(Object thisObj) {
        if (BranchProbabilityNode.probability(0.09999999999999998, thisObj == null)) {
            return 0;
        }
        return this.computeIdentityHashCode(thisObj);
    }

    protected abstract int computeIdentityHashCode(Object var1);

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo identityHashCodeSnippet;

        public Templates(IdentityHashCodeSnippets receiver, OptionValues options, Providers providers, LocationIdentity locationIdentity) {
            super(options, providers);
            this.identityHashCodeSnippet = this.snippet(providers, IdentityHashCodeSnippets.class, "identityHashCodeSnippet", null, (Object)receiver, locationIdentity);
        }

        public void lower(IdentityHashCodeNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.identityHashCodeSnippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("thisObj", node.object());
            SnippetTemplate template = this.template(tool, node, args);
            template.instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

