/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.word.Word;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class DimensionsNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<DimensionsNode> TYPE = NodeClass.create(DimensionsNode.class);
    protected final int rank;

    public DimensionsNode(@Node.InjectedNodeParameter WordTypes wordTypes, int rank) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(wordTypes.getWordKind()));
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lirGen = gen.getLIRGeneratorTool();
        int sizeInBytes = this.rank * 4;
        VirtualStackSlot array = lirGen.allocateStackMemory(sizeInBytes, 4);
        Variable result = lirGen.emitAddress(array);
        gen.setResult(this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native Word allocaDimsArray(@Node.ConstantNodeParameter int var0);
}

