/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.SpectrePHTMitigations;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GetObjectAddressNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatingIntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.SignedDivNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerDivNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerRemNode;
import jdk.graal.compiler.nodes.calc.SignedRemNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.UnpackEndianHalfNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.debug.VerifyHeapNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ClassIsArrayNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.GuardedUnsafeLoadNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.extended.LoadArrayComponentHubNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.LoadHubOrNullNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.extended.PublishWritesNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryLoadNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryStoreNode;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.AccessIndexedNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.LogicCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.LoweredAtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.RegisterFinalizerNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.ValueCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.SideEffectFreeWriteNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.IndexAddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringProvider;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.BigIntegerSnippets;
import jdk.graal.compiler.replacements.BoxingSnippets;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import jdk.graal.compiler.replacements.IsArraySnippets;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetCounterNode;
import jdk.graal.compiler.replacements.StringLatin1Snippets;
import jdk.graal.compiler.replacements.StringUTF16Snippets;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.IdentityHashCodeNode;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.word.LocationIdentity;

public abstract class DefaultJavaLoweringProvider
implements LoweringProvider {
    protected final MetaAccessProvider metaAccess;
    protected final ForeignCallsProvider foreignCalls;
    protected final BarrierSet barrierSet;
    protected final MetaAccessExtensionProvider metaAccessExtensionProvider;
    protected final TargetDescription target;
    private final boolean useCompressedOops;
    protected Replacements replacements;
    private BoxingSnippets.Templates boxingSnippets;
    private IdentityHashCodeSnippets.Templates identityHashCodeSnippets;
    protected IsArraySnippets.Templates isArraySnippets;
    protected StringLatin1Snippets.Templates latin1Templates;
    protected StringUTF16Snippets.Templates utf16templates;
    public static final IntegerStamp POSITIVE_ARRAY_INDEX_STAMP = IntegerStamp.create(32, 0L, 0x7FFFFFFEL);

    public DefaultJavaLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target, boolean useCompressedOops) {
        this.metaAccess = metaAccess;
        this.foreignCalls = foreignCalls;
        this.barrierSet = platformConfig.getBarrierSet();
        this.metaAccessExtensionProvider = metaAccessExtensionProvider;
        this.target = target;
        this.useCompressedOops = useCompressedOops;
    }

    public void initialize(OptionValues options, SnippetCounter.Group.Factory factory, Providers providers) {
        this.replacements = providers.getReplacements();
        this.boxingSnippets = new BoxingSnippets.Templates(options, factory, providers);
        this.identityHashCodeSnippets = this.createIdentityHashCodeSnippets(options, providers);
        if (GraalOptions.EmitStringSubstitutions.getValue(options).booleanValue()) {
            this.latin1Templates = new StringLatin1Snippets.Templates(options, providers);
            providers.getReplacements().registerSnippetTemplateCache(this.latin1Templates);
            this.utf16templates = new StringUTF16Snippets.Templates(options, providers);
            providers.getReplacements().registerSnippetTemplateCache(this.utf16templates);
        }
        providers.getReplacements().registerSnippetTemplateCache(new SnippetCounterNode.SnippetCounterSnippets.Templates(options, providers));
        providers.getReplacements().registerSnippetTemplateCache(new BigIntegerSnippets.Templates(options, providers));
    }

    protected abstract IdentityHashCodeSnippets.Templates createIdentityHashCodeSnippets(OptionValues var1, Providers var2);

    @Override
    public boolean supportsImplicitNullChecks() {
        return this.target.implicitNullCheckLimit > 0;
    }

    @Override
    public final TargetDescription getTarget() {
        return this.target;
    }

    public MetaAccessProvider getMetaAccess() {
        return this.metaAccess;
    }

    @Override
    public BarrierSet getBarrierSet() {
        return this.barrierSet;
    }

    public MetaAccessExtensionProvider getMetaAccessExtensionProvider() {
        return this.metaAccessExtensionProvider;
    }

    public Replacements getReplacements() {
        return this.replacements;
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        assert (n instanceof Lowerable) : n;
        try (DebugCloseable context = n.withNodeSourcePosition();){
            if (n instanceof LoadFieldNode) {
                this.lowerLoadFieldNode((LoadFieldNode)n, tool);
            } else if (n instanceof StoreFieldNode) {
                this.lowerStoreFieldNode((StoreFieldNode)n, tool);
            } else if (n instanceof LoadIndexedNode) {
                this.lowerLoadIndexedNode((LoadIndexedNode)n, tool);
            } else if (n instanceof StoreIndexedNode) {
                this.lowerStoreIndexedNode((StoreIndexedNode)n, tool);
            } else if (n instanceof IndexAddressNode) {
                this.lowerIndexAddressNode((IndexAddressNode)n);
            } else if (n instanceof ArrayLengthNode) {
                this.lowerArrayLengthNode((ArrayLengthNode)n, tool);
            } else if (n instanceof LoadHubNode) {
                this.lowerLoadHubNode((LoadHubNode)n, tool);
            } else if (n instanceof LoadHubOrNullNode) {
                this.lowerLoadHubOrNullNode((LoadHubOrNullNode)n, tool);
            } else if (n instanceof LoadArrayComponentHubNode) {
                this.lowerLoadArrayComponentHubNode((LoadArrayComponentHubNode)n);
            } else if (n instanceof UnsafeCompareAndSwapNode) {
                this.lowerCompareAndSwapNode((UnsafeCompareAndSwapNode)n);
            } else if (n instanceof UnsafeCompareAndExchangeNode) {
                this.lowerCompareAndExchangeNode((UnsafeCompareAndExchangeNode)n);
            } else if (n instanceof AtomicReadAndWriteNode) {
                this.lowerAtomicReadAndWriteNode((AtomicReadAndWriteNode)n);
            } else if (n instanceof AtomicReadAndAddNode) {
                this.lowerAtomicReadAndAddNode((AtomicReadAndAddNode)n);
            } else if (n instanceof RawLoadNode) {
                this.lowerUnsafeLoadNode((RawLoadNode)n, tool);
            } else if (n instanceof UnsafeMemoryLoadNode) {
                this.lowerUnsafeMemoryLoadNode((UnsafeMemoryLoadNode)n);
            } else if (n instanceof RawStoreNode) {
                this.lowerUnsafeStoreNode((RawStoreNode)n);
            } else if (n instanceof UnsafeMemoryStoreNode) {
                this.lowerUnsafeMemoryStoreNode((UnsafeMemoryStoreNode)n);
            } else if (n instanceof JavaReadNode) {
                this.lowerJavaReadNode((JavaReadNode)n);
            } else if (n instanceof JavaWriteNode) {
                this.lowerJavaWriteNode((JavaWriteNode)n);
            } else if (n instanceof CommitAllocationNode) {
                this.lowerCommitAllocationNode((CommitAllocationNode)n, tool);
            } else if (n instanceof BoxNode) {
                if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.MID_TIER) {
                    this.boxingSnippets.lower((BoxNode)n, tool);
                }
            } else if (n instanceof UnboxNode) {
                if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.MID_TIER) {
                    this.boxingSnippets.lower((UnboxNode)n, tool);
                }
            } else if (n instanceof VerifyHeapNode) {
                this.lowerVerifyHeap((VerifyHeapNode)n);
            } else if (n instanceof UnaryMathIntrinsicNode) {
                this.lowerUnaryMath((UnaryMathIntrinsicNode)n, tool);
            } else if (n instanceof BinaryMathIntrinsicNode) {
                this.lowerBinaryMath((BinaryMathIntrinsicNode)n, tool);
            } else if (n instanceof UnpackEndianHalfNode) {
                this.lowerSecondHalf((UnpackEndianHalfNode)n);
            } else {
                FloatingIntegerDivRemNode divRem;
                if (n instanceof RegisterFinalizerNode) {
                    return;
                }
                if (n instanceof IdentityHashCodeNode) {
                    this.identityHashCodeSnippets.lower((IdentityHashCodeNode)n, tool);
                } else if (n instanceof ObjectIsArrayNode || n instanceof ClassIsArrayNode) {
                    this.isArraySnippets.lower((LogicNode)n, tool);
                } else if (n instanceof ComputeObjectAddressNode) {
                    StructuredGraph graph = (StructuredGraph)n.graph();
                    if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                        DefaultJavaLoweringProvider.lowerComputeObjectAddressNode((ComputeObjectAddressNode)n);
                    }
                } else if (n instanceof FloatingIntegerDivRemNode && (divRem = (FloatingIntegerDivRemNode)n).graph().isAfterStage(GraphState.StageFlag.FSA)) {
                    this.lowerFloatingIntegerDivRem((FloatingIntegerDivRemNode)n, tool);
                } else if (!(n instanceof LIRLowerable)) {
                    throw GraalError.shouldNotReachHere("Node implementing Lowerable not handled: " + String.valueOf(n));
                }
            }
        }
    }

    protected void lowerFloatingIntegerDivRem(FloatingIntegerDivRemNode<?> divRem, LoweringTool tool) {
        FixedWithNextNode insertAfter = tool.lastFixedNode();
        StructuredGraph graph = insertAfter.graph();
        IntegerDivRemNode divRemFixed = null;
        ValueNode dividend = divRem.getX();
        ValueNode divisor = divRem.getY();
        if (divRem instanceof SignedFloatingIntegerDivNode) {
            divRemFixed = graph.add(new SignedDivNode(dividend, divisor, divRem.getGuard()));
        } else if (divRem instanceof SignedFloatingIntegerRemNode) {
            divRemFixed = graph.add(new SignedRemNode(dividend, divisor, divRem.getGuard()));
        } else {
            throw GraalError.shouldNotReachHere("divRem is null or has unexpected type: " + String.valueOf(divRem));
        }
        divRemFixed.setCanDeopt(false);
        divRem.replaceAtUsagesAndDelete(divRemFixed);
        graph.addAfterFixed(insertAfter, divRemFixed);
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
            divRemFixed.lower(tool);
        }
    }

    private static void lowerComputeObjectAddressNode(ComputeObjectAddressNode n) {
        for (Node use : n.usages().snapshot()) {
            FixedNode fixed;
            if (use instanceof FixedNode) {
                fixed = (FixedNode)use;
            } else if (use instanceof ValuePhiNode) {
                int inputPosition;
                ValuePhiNode phi = (ValuePhiNode)use;
                for (inputPosition = 0; inputPosition < phi.valueCount() && phi.valueAt(inputPosition) != n; ++inputPosition) {
                }
                GraalError.guarantee(inputPosition < phi.valueCount(), "Failed to find expected input");
                fixed = phi.merge().phiPredecessorAt(inputPosition);
            } else {
                throw GraalError.shouldNotReachHere("Unexpected floating use of ComputeObjectAddressNode " + String.valueOf(n));
            }
            StructuredGraph graph = n.graph();
            GetObjectAddressNode address = graph.add(new GetObjectAddressNode(n.getObject()));
            graph.addBeforeFixed(fixed, address);
            AddNode add = graph.addOrUnique(new AddNode(address, n.getOffset()));
            use.replaceFirstInput(n, add);
        }
        GraphUtil.unlinkFixedNode(n);
        n.safeDelete();
    }

    private void lowerSecondHalf(UnpackEndianHalfNode n) {
        ByteOrder byteOrder = this.target.arch.getByteOrder();
        n.lower(byteOrder);
    }

    private void lowerBinaryMath(BinaryMathIntrinsicNode math, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        ResolvedJavaMethod method = math.graph().method();
        if (method != null) {
            if (this.replacements.isSnippet(method)) {
                return;
            }
            if (method.getName().equalsIgnoreCase(math.getOperation().name()) && tool.getMetaAccess().lookupJavaType(Math.class).equals((Object)method.getDeclaringClass())) {
                return;
            }
            if (GraalOptions.InlineGraalStubs.getValue(math.graph().getOptions()).booleanValue()) {
                return;
            }
        }
        StructuredGraph graph = math.graph();
        ForeignCallNode call = graph.add(new ForeignCallNode(this.foreignCalls, math.getOperation().foreignCallSignature, math.getX(), math.getY()));
        graph.addAfterFixed(tool.lastFixedNode(), call);
        math.replaceAtUsages(call);
    }

    private void lowerUnaryMath(UnaryMathIntrinsicNode math, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        ResolvedJavaMethod method = math.graph().method();
        if (method != null) {
            if (method.getName().equalsIgnoreCase(math.getOperation().name()) && tool.getMetaAccess().lookupJavaType(Math.class).equals((Object)method.getDeclaringClass())) {
                return;
            }
            if (GraalOptions.InlineGraalStubs.getValue(math.graph().getOptions()).booleanValue()) {
                return;
            }
        }
        this.lowerUnaryMathToForeignCall(math, tool);
    }

    protected void lowerUnaryMathToForeignCall(UnaryMathIntrinsicNode math, LoweringTool tool) {
        StructuredGraph graph = math.graph();
        ForeignCallDescriptor desc = this.foreignCalls.getDescriptor(math.getOperation().foreignCallSignature);
        Stamp s = UnaryMathIntrinsicNode.UnaryOperation.computeStamp(math.getOperation(), math.getValue().stamp(NodeView.DEFAULT));
        ForeignCallNode call = graph.add(new ForeignCallNode(desc, s, List.of(math.getValue())));
        graph.addAfterFixed(tool.lastFixedNode(), call);
        math.replaceAtUsages(call);
    }

    protected void lowerVerifyHeap(VerifyHeapNode n) {
        GraphUtil.removeFixedWithUnusedInputs(n);
    }

    public AddressNode createOffsetAddress(StructuredGraph graph, ValueNode object, long offset) {
        ConstantNode o = ConstantNode.forIntegerKind(this.target.wordJavaKind, offset, graph);
        return graph.unique(new OffsetAddressNode(object, o));
    }

    public AddressNode createFieldAddress(StructuredGraph graph, ValueNode object, ResolvedJavaField field) {
        int offset = this.fieldOffset(field);
        if (offset >= 0) {
            return this.createOffsetAddress(graph, object, offset);
        }
        throw GraalError.shouldNotReachHere("Field is missing: " + field.getDeclaringClass().toJavaName(true) + "." + field.getName());
    }

    public final JavaKind getStorageKind(ResolvedJavaField field) {
        return this.getStorageKind(field.getType());
    }

    public final JavaKind getStorageKind(JavaType type) {
        return this.metaAccessExtensionProvider.getStorageKind(type);
    }

    protected void lowerLoadFieldNode(LoadFieldNode loadField, LoweringTool tool) {
        assert (loadField.getStackKind() != JavaKind.Illegal) : loadField;
        StructuredGraph graph = loadField.graph();
        ResolvedJavaField field = loadField.field();
        ValueNode object = loadField.isStatic() ? this.staticFieldBase(graph, field) : loadField.object();
        object = this.createNullCheckedValue(object, loadField, tool);
        Stamp loadStamp = this.loadStamp(loadField.stamp(NodeView.DEFAULT), this.getStorageKind(field));
        AddressNode address = this.createFieldAddress(graph, object, field);
        BarrierType barrierType = this.barrierSet.fieldReadBarrierType(field, this.getStorageKind(field));
        ReadNode memoryRead = graph.add(new ReadNode(address, this.overrideFieldLocationIdentity(loadField.getLocationIdentity()), loadStamp, barrierType, loadField.getMemoryOrder()));
        ValueNode readValue = this.implicitLoadConvert(graph, this.getStorageKind(field), memoryRead);
        loadField.replaceAtUsages(readValue);
        graph.replaceFixed(loadField, memoryRead);
    }

    protected void lowerStoreFieldNode(StoreFieldNode storeField, LoweringTool tool) {
        StructuredGraph graph = storeField.graph();
        ResolvedJavaField field = storeField.field();
        ValueNode object = storeField.isStatic() ? this.staticFieldBase(graph, field) : storeField.object();
        object = this.createNullCheckedValue(object, storeField, tool);
        ValueNode value = this.implicitStoreConvert(graph, this.getStorageKind(storeField.field()), storeField.value());
        AddressNode address = this.createFieldAddress(graph, object, field);
        BarrierType barrierType = this.barrierSet.fieldWriteBarrierType(field, this.getStorageKind(field));
        WriteNode memoryWrite = graph.add(new WriteNode(address, this.overrideFieldLocationIdentity(storeField.getLocationIdentity()), value, barrierType, storeField.getMemoryOrder()));
        memoryWrite.setStateAfter(storeField.stateAfter());
        graph.replaceFixedWithFixed(storeField, memoryWrite);
    }

    protected ValueNode createPositiveIndex(StructuredGraph graph, ValueNode index, GuardingNode boundsCheck) {
        return graph.addOrUnique(PiNode.create(index, POSITIVE_ARRAY_INDEX_STAMP, boundsCheck != null ? boundsCheck.asNode() : null));
    }

    public AddressNode createArrayIndexAddress(StructuredGraph graph, ValueNode array, JavaKind elementKind, ValueNode index, GuardingNode boundsCheck) {
        return this.createArrayAddress(graph, array, elementKind, this.createPositiveIndex(graph, index, boundsCheck));
    }

    public AddressNode createArrayAddress(StructuredGraph graph, ValueNode array, JavaKind elementKind, ValueNode index) {
        return this.createArrayAddress(graph, array, elementKind, elementKind, index);
    }

    public AddressNode createArrayAddress(StructuredGraph graph, ValueNode array, JavaKind arrayKind, JavaKind elementKind, ValueNode index) {
        int base = this.metaAccess.getArrayBaseOffset(arrayKind);
        return this.createArrayAddress(graph, array, base, elementKind, index);
    }

    public AddressNode createArrayAddress(StructuredGraph graph, ValueNode array, int arrayBaseOffset, JavaKind elementKind, ValueNode index) {
        ValueNode wordIndex;
        if (this.target.wordSize > 4) {
            wordIndex = graph.unique(new SignExtendNode(index, this.target.wordSize * 8));
        } else {
            assert (this.target.wordSize == 4) : "unsupported word size";
            wordIndex = index;
        }
        int shift = CodeUtil.log2((int)this.metaAccess.getArrayIndexScale(elementKind));
        ValueNode scaledIndex = graph.unique(new LeftShiftNode(wordIndex, ConstantNode.forInt(shift, graph)));
        ValueNode offset = graph.unique(new AddNode(scaledIndex, ConstantNode.forIntegerKind(this.target.wordJavaKind, arrayBaseOffset, graph)));
        return graph.unique(new OffsetAddressNode(array, offset));
    }

    protected void lowerIndexAddressNode(IndexAddressNode indexAddress) {
        AddressNode lowered = this.createArrayAddress(indexAddress.graph(), indexAddress.getArray(), indexAddress.getArrayKind(), indexAddress.getElementKind(), indexAddress.getIndex());
        indexAddress.replaceAndDelete(lowered);
    }

    public void lowerLoadIndexedNode(LoadIndexedNode loadIndexed, LoweringTool tool) {
        int arrayBaseOffset = this.metaAccess.getArrayBaseOffset(loadIndexed.elementKind());
        this.lowerLoadIndexedNode(loadIndexed, tool, arrayBaseOffset);
    }

    public void lowerLoadIndexedNode(LoadIndexedNode loadIndexed, LoweringTool tool, int arrayBaseOffset) {
        StructuredGraph graph = loadIndexed.graph();
        ValueNode array = loadIndexed.array();
        array = this.createNullCheckedValue(array, loadIndexed, tool);
        JavaKind elementKind = loadIndexed.elementKind();
        Stamp loadStamp = this.loadStamp(loadIndexed.stamp(NodeView.DEFAULT), elementKind);
        GuardingNode boundsCheck = this.getBoundsCheck(loadIndexed, array, tool);
        ValueNode index = loadIndexed.index();
        if (SpectrePHTMitigations.Options.SpectrePHTIndexMasking.getValue(graph.getOptions()).booleanValue()) {
            index = graph.addOrUniqueWithInputs(this.proxyIndex(loadIndexed, index, array, tool));
        }
        ValueNode positiveIndex = this.createPositiveIndex(graph, index, boundsCheck);
        AddressNode address = this.createArrayAddress(graph, array, arrayBaseOffset, elementKind, positiveIndex);
        LocationIdentity arrayLocation = NamedLocationIdentity.getArrayLocation(elementKind);
        ReadNode memoryRead = graph.add(new ReadNode(address, arrayLocation, loadStamp, this.barrierSet.readBarrierType(arrayLocation, address, loadStamp), MemoryOrderMode.PLAIN));
        memoryRead.setGuard(boundsCheck);
        ValueNode readValue = this.implicitLoadConvert(graph, elementKind, memoryRead);
        loadIndexed.replaceAtUsages(readValue);
        graph.replaceFixed(loadIndexed, memoryRead);
    }

    public void lowerStoreIndexedNode(StoreIndexedNode storeIndexed, LoweringTool tool) {
        int arrayBaseOffset = this.metaAccess.getArrayBaseOffset(storeIndexed.elementKind());
        this.lowerStoreIndexedNode(storeIndexed, tool, arrayBaseOffset);
    }

    public void lowerStoreIndexedNode(StoreIndexedNode storeIndexed, LoweringTool tool, int arrayBaseOffset) {
        StructuredGraph graph = storeIndexed.graph();
        ValueNode value = storeIndexed.value();
        ValueNode array = storeIndexed.array();
        array = this.createNullCheckedValue(array, storeIndexed, tool);
        GuardingNode boundsCheck = this.getBoundsCheck(storeIndexed, array, tool);
        JavaKind storageKind = storeIndexed.elementKind();
        LogicNode condition = null;
        if (storeIndexed.getStoreCheck() == null && storageKind == JavaKind.Object && !StampTool.isPointerAlwaysNull(value)) {
            TypeReference arrayType = StampTool.typeReferenceOrNull(array);
            if (arrayType != null && arrayType.isExact()) {
                ResolvedJavaType elementType = arrayType.getType().getComponentType();
                if (!elementType.isJavaLangObject()) {
                    TypeReference typeReference = TypeReference.createTrusted(storeIndexed.graph().getAssumptions(), elementType);
                    LogicNode typeTest = graph.addOrUniqueWithInputs(InstanceOfNode.create(typeReference, value));
                    condition = LogicNode.or(graph.unique(IsNullNode.create(value)), typeTest, BranchProbabilityNode.NOT_LIKELY_PROFILE);
                }
            } else {
                ValueNode arrayClass = this.createReadHub(graph, array, tool);
                boolean isKnownObjectArray = arrayType != null && !arrayType.getType().getComponentType().isPrimitive();
                ValueNode componentHub = this.createReadArrayComponentHub(graph, arrayClass, isKnownObjectArray, storeIndexed);
                LogicNode typeTest = graph.unique(InstanceOfDynamicNode.create(graph.getAssumptions(), tool.getConstantReflection(), componentHub, value, false));
                condition = LogicNode.or(graph.unique(IsNullNode.create(value)), typeTest, BranchProbabilityNode.NOT_LIKELY_PROFILE);
            }
            if (condition != null && condition.isTautology()) {
                condition = null;
            }
        }
        BarrierType barrierType = this.barrierSet.arrayWriteBarrierType(storageKind);
        ValueNode positiveIndex = this.createPositiveIndex(graph, storeIndexed.index(), boundsCheck);
        AddressNode address = this.createArrayAddress(graph, array, arrayBaseOffset, storageKind, positiveIndex);
        WriteNode memoryWrite = graph.add(new WriteNode(address, NamedLocationIdentity.getArrayLocation(storageKind), this.implicitStoreConvert(graph, storageKind, value), barrierType, MemoryOrderMode.PLAIN));
        memoryWrite.setGuard(boundsCheck);
        if (condition != null) {
            tool.createGuard(storeIndexed, condition, DeoptimizationReason.ArrayStoreException, DeoptimizationAction.InvalidateReprofile);
        }
        memoryWrite.setStateAfter(storeIndexed.stateAfter());
        graph.replaceFixedWithFixed(storeIndexed, memoryWrite);
    }

    protected void lowerArrayLengthNode(ArrayLengthNode arrayLengthNode, LoweringTool tool) {
        StructuredGraph graph = arrayLengthNode.graph();
        arrayLengthNode.replaceAtUsages(this.createReadArrayLength(arrayLengthNode.array(), arrayLengthNode, tool));
        graph.removeFixed(arrayLengthNode);
    }

    private ReadNode createReadArrayLength(ValueNode array, FixedNode before, LoweringTool tool) {
        StructuredGraph graph = array.graph();
        ValueNode canonicalArray = this.createNullCheckedValue(GraphUtil.skipPiWhileNonNullArray(array), before, tool);
        AddressNode address = this.createOffsetAddress(graph, canonicalArray, this.arrayLengthOffset());
        ReadNode readArrayLength = graph.add(new ReadNode(address, NamedLocationIdentity.ARRAY_LENGTH_LOCATION, StampFactory.positiveInt(), BarrierType.NONE, MemoryOrderMode.PLAIN));
        graph.addBeforeFixed(before, readArrayLength);
        return readArrayLength;
    }

    protected void lowerLoadHubNode(LoadHubNode loadHub, LoweringTool tool) {
        StructuredGraph graph = loadHub.graph();
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return;
        }
        if (graph.getGuardsStage().allowsFloatingGuards()) {
            return;
        }
        ValueNode hub = this.createReadHub(graph, loadHub.getValue(), tool);
        loadHub.replaceAtUsagesAndDelete(hub);
    }

    protected void lowerLoadHubOrNullNode(LoadHubOrNullNode loadHubOrNullNode, LoweringTool tool) {
        ValueNode synonym;
        StructuredGraph graph = loadHubOrNullNode.graph();
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return;
        }
        if (graph.getGuardsStage().allowsFloatingGuards()) {
            return;
        }
        ValueNode object = loadHubOrNullNode.getValue();
        if (object.isConstant() && !object.asJavaConstant().isNull() && (synonym = LoadHubNode.findSynonym(object, loadHubOrNullNode.stamp(NodeView.DEFAULT), tool.getMetaAccess(), tool.getConstantReflection())) != null) {
            loadHubOrNullNode.replaceAtUsagesAndDelete(graph.addOrUnique(synonym));
            return;
        }
        FixedWithNextNode predecessor = tool.lastFixedNode();
        ValueNode value = loadHubOrNullNode.getValue();
        AbstractPointerStamp stamp = (AbstractPointerStamp)value.stamp(NodeView.DEFAULT);
        LogicNode isNull = graph.addOrUniqueWithInputs(IsNullNode.create(value));
        EndNode trueEnd = graph.add(new EndNode());
        EndNode falseEnd = graph.add(new EndNode());
        IfNode ifNode = graph.add(new IfNode(isNull, trueEnd, falseEnd, ProfileData.BranchProbabilityData.injected(0.09999999999999998)));
        MergeNode merge = graph.add(new MergeNode());
        merge.addForwardEnd(trueEnd);
        merge.addForwardEnd(falseEnd);
        AbstractPointerStamp hubStamp = (AbstractPointerStamp)loadHubOrNullNode.stamp(NodeView.DEFAULT);
        ConstantNode nullHub = ConstantNode.forConstant(hubStamp.asAlwaysNull(), (Constant)JavaConstant.NULL_POINTER, tool.getMetaAccess(), graph);
        ValueNode nonNullValue = graph.addOrUniqueWithInputs(PiNode.create(value, stamp.asNonNull(), ifNode.falseSuccessor()));
        ValueNode hub = this.createReadHub(graph, nonNullValue, tool);
        ValueNode[] values = new ValueNode[]{nullHub, hub};
        PhiNode hubPhi = graph.unique(new ValuePhiNode(hubStamp, merge, values));
        FixedNode oldNext = predecessor.next();
        predecessor.setNext(ifNode);
        merge.setNext(oldNext);
        loadHubOrNullNode.replaceAtUsagesAndDelete(hubPhi);
    }

    protected void lowerLoadArrayComponentHubNode(LoadArrayComponentHubNode loadHub) {
        StructuredGraph graph = loadHub.graph();
        ValueNode hub = this.createReadArrayComponentHub(graph, loadHub.getValue(), false, loadHub);
        graph.replaceFixed(loadHub, hub);
    }

    protected void lowerCompareAndSwapNode(UnsafeCompareAndSwapNode cas) {
        StructuredGraph graph = cas.graph();
        JavaKind valueKind = cas.getValueKind();
        ValueNode expectedValue = this.implicitStoreConvert(graph, valueKind, cas.expected());
        ValueNode newValue = this.implicitStoreConvert(graph, valueKind, cas.newValue());
        AddressNode address = graph.unique(new OffsetAddressNode(cas.object(), cas.offset()));
        BarrierType barrierType = this.barrierSet.readWriteBarrier(cas.object(), newValue);
        LogicCompareAndSwapNode atomicNode = graph.add(new LogicCompareAndSwapNode(address, expectedValue, newValue, cas.getKilledLocationIdentity(), barrierType, cas.getMemoryOrder()));
        atomicNode.setStateAfter(cas.stateAfter());
        graph.replaceFixedWithFixed(cas, atomicNode);
    }

    protected void lowerCompareAndExchangeNode(UnsafeCompareAndExchangeNode cas) {
        StructuredGraph graph = cas.graph();
        JavaKind valueKind = cas.getValueKind();
        ValueNode expectedValue = this.implicitStoreConvert(graph, valueKind, cas.expected());
        ValueNode newValue = this.implicitStoreConvert(graph, valueKind, cas.newValue());
        AddressNode address = graph.unique(new OffsetAddressNode(cas.object(), cas.offset()));
        BarrierType barrierType = this.barrierSet.readWriteBarrier(cas.object(), newValue);
        ValueCompareAndSwapNode atomicNode = graph.add(new ValueCompareAndSwapNode(address, expectedValue, newValue, cas.getKilledLocationIdentity(), barrierType, cas.getMemoryOrder()));
        ValueNode coercedNode = this.implicitLoadConvert(graph, valueKind, atomicNode, true);
        atomicNode.setStateAfter(cas.stateAfter());
        cas.replaceAtUsages(coercedNode);
        graph.replaceFixedWithFixed(cas, atomicNode);
    }

    protected void lowerAtomicReadAndWriteNode(AtomicReadAndWriteNode n) {
        StructuredGraph graph = n.graph();
        JavaKind valueKind = n.getValueKind();
        ValueNode newValue = this.implicitStoreConvert(graph, valueKind, n.newValue());
        AddressNode address = graph.unique(new OffsetAddressNode(n.object(), n.offset()));
        BarrierType barrierType = this.barrierSet.readWriteBarrier(n.object(), newValue);
        LoweredAtomicReadAndWriteNode memoryRead = graph.add(new LoweredAtomicReadAndWriteNode(address, n.getKilledLocationIdentity(), newValue, barrierType));
        memoryRead.setStateAfter(n.stateAfter());
        ValueNode readValue = this.implicitLoadConvert(graph, valueKind, memoryRead);
        n.stateAfter().replaceFirstInput(n, memoryRead);
        n.replaceAtUsages(readValue);
        graph.replaceFixedWithFixed(n, memoryRead);
    }

    protected void lowerAtomicReadAndAddNode(AtomicReadAndAddNode n) {
        StructuredGraph graph = n.graph();
        JavaKind valueKind = n.getValueKind();
        ValueNode delta = this.implicitStoreConvert(graph, valueKind, n.delta());
        AddressNode address = graph.unique(new OffsetAddressNode(n.object(), n.offset()));
        LoweredAtomicReadAndAddNode memoryRead = graph.add(new LoweredAtomicReadAndAddNode(address, n.getKilledLocationIdentity(), delta));
        memoryRead.setStateAfter(n.stateAfter());
        ValueNode readValue = this.implicitLoadConvert(graph, valueKind, memoryRead);
        n.stateAfter().replaceFirstInput(n, memoryRead);
        n.replaceAtUsages(readValue);
        graph.replaceFixedWithFixed(n, memoryRead);
    }

    protected void lowerUnsafeLoadNode(RawLoadNode load, LoweringTool tool) {
        StructuredGraph graph = load.graph();
        if (load instanceof GuardedUnsafeLoadNode) {
            GuardedUnsafeLoadNode guardedLoad = (GuardedUnsafeLoadNode)load;
            GuardingNode guard = guardedLoad.getGuard();
            if (guard == null) {
                ReadNode memoryRead = this.createUnsafeRead(graph, load, null);
                memoryRead.setForceFixed(false);
                graph.replaceFixedWithFixed(load, memoryRead);
            } else {
                ReadNode memoryRead = this.createUnsafeRead(graph, load, guard);
                graph.replaceFixedWithFixed(load, memoryRead);
            }
        } else {
            ReadNode memoryRead = this.createUnsafeRead(graph, load, null);
            graph.replaceFixedWithFixed(load, memoryRead);
        }
    }

    protected AddressNode createUnsafeAddress(StructuredGraph graph, ValueNode object, ValueNode offset) {
        if (object.isConstant() && object.asConstant().isDefaultForKind()) {
            return graph.addOrUniqueWithInputs(OffsetAddressNode.create(offset));
        }
        return graph.unique(new OffsetAddressNode(object, offset));
    }

    protected ReadNode createUnsafeRead(StructuredGraph graph, RawLoadNode load, GuardingNode guard) {
        boolean compressible = load.accessKind() == JavaKind.Object;
        JavaKind readKind = load.accessKind();
        Stamp loadStamp = this.loadStamp(load.stamp(NodeView.DEFAULT), readKind, compressible);
        AddressNode address = this.createUnsafeAddress(graph, load.object(), load.offset());
        LocationIdentity location = load.getLocationIdentity();
        ReadNode memoryRead = graph.add(new ReadNode(address, location, loadStamp, this.barrierSet.readBarrierType(location, address, loadStamp), load.getMemoryOrder()));
        if (guard == null) {
            memoryRead.setForceFixed(true);
        } else {
            memoryRead.setGuard(guard);
        }
        ValueNode readValue = DefaultJavaLoweringProvider.performBooleanCoercionIfNecessary(this.implicitLoadConvert(graph, readKind, memoryRead, compressible), readKind);
        load.replaceAtUsages(readValue);
        return memoryRead;
    }

    protected void lowerUnsafeMemoryLoadNode(UnsafeMemoryLoadNode load) {
        StructuredGraph graph = load.graph();
        JavaKind readKind = load.getKind();
        Stamp loadStamp = this.loadStamp(load.stamp(NodeView.DEFAULT), readKind, false);
        AddressNode address = graph.addOrUniqueWithInputs(OffsetAddressNode.create(load.getAddress()));
        LocationIdentity location = load.getLocationIdentity();
        ReadNode memoryRead = graph.add(new ReadNode(address, location, loadStamp, this.barrierSet.readBarrierType(location, address, loadStamp), MemoryOrderMode.PLAIN));
        memoryRead.setForceFixed(true);
        ValueNode readValue = DefaultJavaLoweringProvider.performBooleanCoercionIfNecessary(this.implicitLoadConvert(graph, readKind, memoryRead, false), readKind);
        load.replaceAtUsages(readValue);
        graph.replaceFixedWithFixed(load, memoryRead);
    }

    private static ValueNode performBooleanCoercionIfNecessary(ValueNode readValue, JavaKind readKind) {
        if (readKind == JavaKind.Boolean) {
            StructuredGraph graph = readValue.graph();
            IntegerEqualsNode eq = graph.addOrUnique(new IntegerEqualsNode(readValue, ConstantNode.forInt(0, graph)));
            return graph.addOrUnique(new ConditionalNode(eq, ConstantNode.forBoolean(false, graph), ConstantNode.forBoolean(true, graph)));
        }
        return readValue;
    }

    protected void lowerUnsafeStoreNode(RawStoreNode store) {
        StructuredGraph graph = store.graph();
        boolean compressible = store.value().getStackKind() == JavaKind.Object;
        JavaKind valueKind = store.accessKind();
        ValueNode value = this.implicitStoreConvert(graph, valueKind, store.value(), compressible);
        AddressNode address = this.createUnsafeAddress(graph, store.object(), store.offset());
        WriteNode write = graph.add(new WriteNode(address, store.getLocationIdentity(), value, this.barrierSet.writeBarrierType(store), store.getMemoryOrder()));
        write.setStateAfter(store.stateAfter());
        graph.replaceFixedWithFixed(store, write);
    }

    protected void lowerUnsafeMemoryStoreNode(UnsafeMemoryStoreNode store) {
        StructuredGraph graph = store.graph();
        assert (store.getValue().getStackKind() != JavaKind.Object) : Assertions.errorMessageContext("store", store);
        JavaKind valueKind = store.getKind();
        ValueNode value = this.implicitStoreConvert(graph, valueKind, store.getValue(), false);
        AddressNode address = graph.addOrUniqueWithInputs(OffsetAddressNode.create(store.getAddress()));
        WriteNode write = graph.add(new WriteNode(address, store.getKilledLocationIdentity(), value, BarrierType.NONE, MemoryOrderMode.PLAIN));
        write.setStateAfter(store.stateAfter());
        graph.replaceFixedWithFixed(store, write);
    }

    protected void lowerJavaReadNode(JavaReadNode read) {
        StructuredGraph graph = read.graph();
        JavaKind valueKind = read.getReadKind();
        Stamp loadStamp = this.loadStamp(read.stamp(NodeView.DEFAULT), valueKind, read.isCompressible());
        ReadNode memoryRead = graph.add(new ReadNode(read.getAddress(), read.getLocationIdentity(), loadStamp, read.getBarrierType(), read.getMemoryOrder()));
        GuardingNode guard = read.getGuard();
        ValueNode readValue = this.implicitLoadConvert(graph, valueKind, memoryRead, read.isCompressible());
        if (guard == null) {
            memoryRead.setForceFixed(true);
        } else {
            memoryRead.setGuard(guard);
        }
        read.replaceAtUsages(readValue);
        graph.replaceFixed(read, memoryRead);
    }

    protected void lowerJavaWriteNode(JavaWriteNode write) {
        WriteNode memoryWrite;
        StructuredGraph graph = write.graph();
        ValueNode value = this.implicitStoreConvert(graph, write.getWriteKind(), write.value(), write.isCompressible());
        if (write.hasSideEffect()) {
            memoryWrite = graph.add(new WriteNode(write.getAddress(), write.getKilledLocationIdentity(), value, write.getBarrierType(), write.getMemoryOrder()));
        } else {
            assert (!write.ordersMemoryAccesses());
            memoryWrite = graph.add(new SideEffectFreeWriteNode(write.getAddress(), write.getKilledLocationIdentity(), value, write.getBarrierType()));
        }
        memoryWrite.setStateAfter(write.stateAfter());
        graph.replaceFixedWithFixed(write, memoryWrite);
        memoryWrite.setGuard(write.getGuard());
    }

    protected void lowerCommitAllocationNode(CommitAllocationNode commit, LoweringTool tool) {
        StructuredGraph graph = commit.graph();
        if (graph.getGuardsStage().allowsFloatingGuards()) {
            return;
        }
        List<VirtualObjectNode> virtualObjects = commit.getVirtualObjects();
        int[] valuePositions = new int[virtualObjects.size()];
        int valuePos = 0;
        for (int objIndex = 0; objIndex < virtualObjects.size(); ++objIndex) {
            valuePositions[objIndex] = valuePos;
            valuePos += virtualObjects.get(objIndex).entryCount();
        }
        int[] emissionOrder = new int[virtualObjects.size()];
        DefaultJavaLoweringProvider.computeAllocationEmissionOrder(commit, emissionOrder);
        ArrayList<AbstractNewObjectNode> recursiveLowerings = new ArrayList<AbstractNewObjectNode>();
        ValueNode[] allocations = new ValueNode[virtualObjects.size()];
        BitSet omittedValues = new BitSet();
        for (int objIndex : emissionOrder) {
            VirtualObjectNode virtual = virtualObjects.get(objIndex);
            try (DebugCloseable nsp = graph.withNodeSourcePosition(virtual);){
                int entryCount = virtual.entryCount();
                AbstractNewObjectNode newObject = this.createUninitializedObject(virtual, graph);
                recursiveLowerings.add(newObject);
                graph.addBeforeFixed(commit, newObject);
                allocations[objIndex] = newObject;
                int valuePos2 = valuePositions[objIndex];
                for (int i = 0; i < entryCount; ++i) {
                    ValueNode value = commit.getValues().get(valuePos2);
                    if (value instanceof VirtualObjectNode) {
                        value = allocations[virtualObjects.indexOf(value)];
                    }
                    if (value == null) {
                        omittedValues.set(valuePos2);
                    } else if (!value.isConstant() || !value.asConstant().isDefaultForKind()) {
                        JavaKind valueKind = value.getStackKind();
                        JavaKind storageKind = virtual.entryKind(tool.getMetaAccessExtensionProvider(), i);
                        assert (valueKind.getStackKind() == storageKind.getStackKind() || valueKind == JavaKind.Long || valueKind == JavaKind.Double || valueKind == JavaKind.Int && virtual instanceof VirtualArrayNode || valueKind == JavaKind.Float && virtual instanceof VirtualArrayNode) : Assertions.errorMessageContext("valueKind", valueKind, "virtual", virtual);
                        AddressNode address = null;
                        BarrierType barrierType = null;
                        if (virtual instanceof VirtualInstanceNode) {
                            ResolvedJavaField field = ((VirtualInstanceNode)virtual).field(i);
                            long offset = this.fieldOffset(field);
                            if (offset >= 0L) {
                                address = this.createOffsetAddress(graph, newObject, offset);
                                barrierType = this.barrierSet.fieldWriteBarrierType(field, this.getStorageKind(field));
                            }
                        } else {
                            assert (virtual instanceof VirtualArrayNode) : Assertions.errorMessageContext("virtual", virtual);
                            address = this.createOffsetAddress(graph, newObject, this.metaAccess.getArrayBaseOffset(storageKind) + i * this.metaAccess.getArrayIndexScale(storageKind));
                            barrierType = this.barrierSet.arrayWriteBarrierType(storageKind);
                        }
                        if (address != null) {
                            WriteNode write = graph.add(new WriteNode(address, LocationIdentity.init(), this.arrayImplicitStoreConvert(graph, storageKind, value, commit, virtual, valuePos2), barrierType, MemoryOrderMode.PLAIN));
                            graph.addAfterFixed(newObject, write);
                        }
                    }
                    ++valuePos2;
                }
            }
        }
        this.writeOmittedValues(commit, graph, allocations, omittedValues);
        this.finishAllocatedObjects(tool, commit, commit, allocations);
        graph.removeFixed(commit);
        Object object = recursiveLowerings.iterator();
        while (object.hasNext()) {
            AbstractNewObjectNode recursiveLowering = (AbstractNewObjectNode)object.next();
            recursiveLowering.lower(tool);
        }
    }

    public AbstractNewObjectNode createUninitializedObject(VirtualObjectNode virtual, StructuredGraph graph) {
        AbstractNewObjectNode ret;
        if (virtual instanceof VirtualInstanceNode) {
            VirtualInstanceNode virtualInstance = (VirtualInstanceNode)virtual;
            ret = graph.add(this.createUninitializedInstance(virtualInstance));
        } else {
            ConstantNode length = ConstantNode.forInt(virtual.entryCount(), graph);
            ret = graph.add(this.createUninitializedArray((VirtualArrayNode)virtual, length));
        }
        ret.clearEmitMemoryBarrier();
        return ret;
    }

    protected NewInstanceNode createUninitializedInstance(VirtualInstanceNode virtual) {
        return new NewInstanceNode(virtual.type(), true);
    }

    protected NewArrayNode createUninitializedArray(VirtualArrayNode virtual, ValueNode length) {
        return new NewArrayNode(virtual.componentType(), length, true);
    }

    public void writeOmittedValues(CommitAllocationNode commit, StructuredGraph graph, ValueNode[] allocations, BitSet omittedValues) {
        int valuePos = 0;
        for (int objIndex = 0; objIndex < commit.getVirtualObjects().size(); ++objIndex) {
            VirtualObjectNode virtual = commit.getVirtualObjects().get(objIndex);
            try (DebugCloseable nsp = graph.withNodeSourcePosition(virtual);){
                int entryCount = virtual.entryCount();
                ValueNode newObject = allocations[objIndex];
                int i = 0;
                while (i < entryCount) {
                    if (omittedValues.get(valuePos)) {
                        ValueNode value = commit.getValues().get(valuePos);
                        assert (value instanceof VirtualObjectNode) : Assertions.errorMessageContext("value", value);
                        ValueNode allocValue = allocations[commit.getVirtualObjects().indexOf(value)];
                        if (!allocValue.isConstant() || !allocValue.asConstant().isDefaultForKind()) {
                            JavaKind entryKind = virtual.entryKind(this.metaAccessExtensionProvider, i);
                            assert (entryKind == JavaKind.Object) : Assertions.errorMessageContext("entryKind", entryKind);
                            assert (allocValue.getStackKind() == JavaKind.Object) : Assertions.errorMessageContext("entryKind", entryKind);
                            AddressNode address = null;
                            BarrierType barrierType = null;
                            if (virtual instanceof VirtualInstanceNode) {
                                VirtualInstanceNode virtualInstance = (VirtualInstanceNode)virtual;
                                ResolvedJavaField field = virtualInstance.field(i);
                                if (this.fieldOffset(field) >= 0) {
                                    address = this.createFieldAddress(graph, newObject, field);
                                    barrierType = this.barrierSet.fieldWriteBarrierType(field, this.getStorageKind(field));
                                }
                            } else {
                                assert (virtual instanceof VirtualArrayNode) : Assertions.errorMessage(commit, virtual);
                                address = this.createArrayAddress(graph, newObject, entryKind, ConstantNode.forInt(i, graph));
                                barrierType = this.barrierSet.arrayWriteBarrierType(entryKind);
                            }
                            if (address != null) {
                                barrierType = this.barrierSet.postAllocationInitBarrier(barrierType);
                                WriteNode write = graph.add(new WriteNode(address, LocationIdentity.init(), this.implicitStoreConvert(graph, JavaKind.Object, allocValue), barrierType, MemoryOrderMode.PLAIN));
                                graph.addBeforeFixed(commit, write);
                            }
                        }
                    }
                    ++i;
                    ++valuePos;
                }
                continue;
            }
        }
    }

    private static void computeAllocationEmissionOrder(CommitAllocationNode commit, int[] order) {
        int size = commit.getVirtualObjects().size();
        boolean[] complete = new boolean[size];
        int cur = 0;
        boolean progress = true;
        while (progress) {
            progress = false;
            int valuePos = 0;
            for (int objIndex = 0; objIndex < size; ++objIndex) {
                if (complete[objIndex]) continue;
                VirtualObjectNode virtual = commit.getVirtualObjects().get(objIndex);
                int entryCount = virtual.entryCount();
                boolean allValuesAvailable = true;
                for (int i = 0; i < entryCount; ++i) {
                    ValueNode value = commit.getValues().get(valuePos);
                    if (value instanceof VirtualObjectNode && !complete[commit.getVirtualObjects().indexOf(value)]) {
                        allValuesAvailable = false;
                        break;
                    }
                    ++valuePos;
                }
                if (!allValuesAvailable) continue;
                progress = true;
                complete[objIndex] = true;
                order[cur++] = objIndex;
            }
        }
        for (int i = 0; i < size; ++i) {
            if (complete[i]) continue;
            order[cur++] = i;
        }
    }

    public void finishAllocatedObjects(LoweringTool tool, FixedWithNextNode insertAfter, CommitAllocationNode commit, ValueNode[] allocations) {
        FixedWithNextNode insertionPoint = insertAfter;
        StructuredGraph graph = commit.graph();
        for (int objIndex = 0; objIndex < commit.getVirtualObjects().size(); ++objIndex) {
            PublishWritesNode publish = graph.add(new PublishWritesNode(allocations[objIndex]));
            allocations[objIndex] = publish;
            graph.addAfterFixed(insertionPoint, publish);
            insertionPoint = publish;
        }
        ArrayList<MonitorEnterNode> enters = null;
        FrameState stateBefore = GraphUtil.findLastFrameState(insertionPoint);
        List<MonitorIdNode> locks = commit.getLocks();
        if (locks.size() > 1) {
            ArrayList<MonitorIdNode> newList = new ArrayList<MonitorIdNode>(locks);
            newList.sort((a, b) -> Integer.compare(a.getLockDepth(), b.getLockDepth()));
            locks = newList;
        }
        int lastDepth = -1;
        for (MonitorIdNode monitorId : locks) {
            GraalError.guarantee(lastDepth < monitorId.getLockDepth(), Assertions.errorMessage(lastDepth, monitorId, insertAfter, commit, allocations));
            lastDepth = monitorId.getLockDepth();
            MonitorEnterNode enter = graph.add(new MonitorEnterNode(allocations[commit.getObjectIndex(monitorId)], monitorId));
            graph.addAfterFixed(insertionPoint, enter);
            enter.setStateAfter(stateBefore.duplicate());
            insertionPoint = enter;
            if (enters == null) {
                enters = new ArrayList<MonitorEnterNode>();
            }
            enters.add(enter);
        }
        for (Node usage : commit.usages().snapshot()) {
            if (usage instanceof AllocatedObjectNode) {
                AllocatedObjectNode addObject = (AllocatedObjectNode)usage;
                int index = commit.getVirtualObjects().indexOf(addObject.getVirtualObject());
                addObject.replaceAtUsagesAndDelete(allocations[index]);
                continue;
            }
            assert (enters != null);
            commit.replaceAtUsages((Node)enters.get(enters.size() - 1), InputType.Memory);
        }
        if (enters != null) {
            for (MonitorEnterNode enter : enters) {
                enter.lower(tool);
            }
        }
        assert (commit.hasNoUsages());
        graph.addAfterFixed(insertAfter, graph.add(MembarNode.forInitialization()));
    }

    public abstract int fieldOffset(ResolvedJavaField var1);

    public FieldLocationIdentity overrideFieldLocationIdentity(FieldLocationIdentity fieldIdentity) {
        return fieldIdentity;
    }

    public abstract ValueNode staticFieldBase(StructuredGraph var1, ResolvedJavaField var2);

    public abstract int arrayLengthOffset();

    public Stamp loadStamp(Stamp stamp, JavaKind kind) {
        return this.loadStamp(stamp, kind, true);
    }

    private boolean useCompressedOops(JavaKind kind, boolean compressible) {
        return kind == JavaKind.Object && compressible && this.useCompressedOops;
    }

    protected abstract Stamp loadCompressedStamp(ObjectStamp var1);

    protected Stamp loadStamp(Stamp stamp, JavaKind kind, boolean compressible) {
        if (this.useCompressedOops(kind, compressible)) {
            return this.loadCompressedStamp((ObjectStamp)stamp);
        }
        switch (kind) {
            case Boolean: 
            case Byte: {
                return IntegerStamp.OPS.getNarrow().foldStamp(32, 8, stamp);
            }
            case Char: 
            case Short: {
                return IntegerStamp.OPS.getNarrow().foldStamp(32, 16, stamp);
            }
        }
        return stamp;
    }

    public final ValueNode implicitLoadConvertWithBooleanCoercionIfNecessary(StructuredGraph graph, JavaKind kind, ValueNode value) {
        return DefaultJavaLoweringProvider.performBooleanCoercionIfNecessary(this.implicitLoadConvert(graph, kind, value), kind);
    }

    public final ValueNode implicitLoadConvert(StructuredGraph graph, JavaKind kind, ValueNode value) {
        return this.implicitLoadConvert(graph, kind, value, true);
    }

    public ValueNode implicitLoadConvert(JavaKind kind, ValueNode value) {
        return this.implicitLoadConvert(kind, value, true);
    }

    protected final ValueNode implicitLoadConvert(StructuredGraph graph, JavaKind kind, ValueNode value, boolean compressible) {
        ValueNode ret = this.implicitLoadConvert(kind, value, compressible);
        if (!ret.isAlive()) {
            ret = graph.addOrUnique(ret);
        }
        return ret;
    }

    protected abstract ValueNode newCompressionNode(CompressionNode.CompressionOp var1, ValueNode var2);

    protected ValueNode implicitLoadConvert(JavaKind kind, ValueNode value, boolean compressible) {
        if (this.useCompressedOops(kind, compressible)) {
            return this.newCompressionNode(CompressionNode.CompressionOp.Uncompress, value);
        }
        switch (kind) {
            case Byte: 
            case Short: {
                return new SignExtendNode(value, 32);
            }
            case Boolean: 
            case Char: {
                return new ZeroExtendNode(value, 32);
            }
        }
        return value;
    }

    public ValueNode arrayImplicitStoreConvert(StructuredGraph graph, JavaKind entryKind, ValueNode value, CommitAllocationNode commit, VirtualObjectNode virtual, int valuePos) {
        if (!virtual.isVirtualByteArray(this.metaAccessExtensionProvider)) {
            return this.implicitStoreConvert(graph, entryKind, value);
        }
        int bytes = 1;
        for (int entryIndex = valuePos + 1; entryIndex < commit.getValues().size() && commit.getValues().get(entryIndex).isIllegalConstant(); ++entryIndex) {
            ++bytes;
        }
        assert (bytes <= value.getStackKind().getByteCount()) : Assertions.errorMessageContext("bytes", bytes, "valueStackKind", value.getStackKind());
        ValueNode entry = value;
        if (value.getStackKind() == JavaKind.Float) {
            entry = graph.addOrUnique(ReinterpretNode.create(JavaKind.Int, entry, NodeView.DEFAULT));
        } else if (value.getStackKind() == JavaKind.Double) {
            entry = graph.addOrUnique(ReinterpretNode.create(JavaKind.Long, entry, NodeView.DEFAULT));
        }
        if (bytes < value.getStackKind().getByteCount()) {
            entry = graph.unique(new NarrowNode(entry, bytes << 3));
        }
        return entry;
    }

    public final ValueNode implicitStoreConvert(StructuredGraph graph, JavaKind kind, ValueNode value) {
        return this.implicitStoreConvert(graph, kind, value, true);
    }

    public ValueNode implicitStoreConvert(JavaKind kind, ValueNode value) {
        return this.implicitStoreConvert(kind, value, true);
    }

    protected final ValueNode implicitStoreConvert(StructuredGraph graph, JavaKind kind, ValueNode value, boolean compressible) {
        ValueNode ret = this.implicitStoreConvert(kind, value, compressible);
        if (!ret.isAlive()) {
            ret = graph.addOrUnique(ret);
        }
        return ret;
    }

    protected ValueNode implicitStoreConvert(JavaKind kind, ValueNode value, boolean compressible) {
        if (this.useCompressedOops(kind, compressible)) {
            return this.newCompressionNode(CompressionNode.CompressionOp.Compress, value);
        }
        switch (kind) {
            case Boolean: 
            case Byte: {
                return new NarrowNode(value, 8);
            }
            case Char: 
            case Short: {
                return new NarrowNode(value, 16);
            }
        }
        return value;
    }

    protected abstract ValueNode createReadHub(StructuredGraph var1, ValueNode var2, LoweringTool var3);

    protected abstract ValueNode createReadArrayComponentHub(StructuredGraph var1, ValueNode var2, boolean var3, FixedNode var4);

    protected ValueNode proxyIndex(AccessIndexedNode n, ValueNode index, ValueNode array, LoweringTool tool) {
        StructuredGraph graph = index.graph();
        ValueNode arrayLength = this.readOrCreateArrayLength(n, array, tool, graph);
        ValueNode lengthMinusOne = SubNode.create(arrayLength, ConstantNode.forInt(1), NodeView.DEFAULT);
        return BinaryArithmeticNode.branchlessMax(BinaryArithmeticNode.branchlessMin(index, lengthMinusOne, NodeView.DEFAULT), ConstantNode.forInt(0), NodeView.DEFAULT);
    }

    protected GuardingNode getBoundsCheck(AccessIndexedNode n, ValueNode array, LoweringTool tool) {
        if (n.getBoundsCheck() != null) {
            return n.getBoundsCheck();
        }
        StructuredGraph graph = n.graph();
        ValueNode arrayLength = this.readOrCreateArrayLength(n, array, tool, graph);
        LogicNode boundsCheck = IntegerBelowNode.create(n.index(), arrayLength, NodeView.DEFAULT);
        if (boundsCheck.isTautology()) {
            return null;
        }
        return tool.createGuard(n, graph.addOrUniqueWithInputs(boundsCheck), DeoptimizationReason.BoundsCheckException, DeoptimizationAction.InvalidateReprofile);
    }

    private ValueNode readOrCreateArrayLength(AccessIndexedNode n, ValueNode array, LoweringTool tool, StructuredGraph graph) {
        ValueNode arrayLength = ArrayLengthNode.readArrayLength(array, tool.getConstantReflection());
        arrayLength = arrayLength == null ? this.createReadArrayLength(array, n, tool) : (arrayLength.isAlive() ? arrayLength : graph.addOrUniqueWithInputs(arrayLength));
        return arrayLength;
    }

    protected GuardingNode createNullCheck(ValueNode object, FixedNode before, LoweringTool tool) {
        if (StampTool.isPointerNonNull(object)) {
            return null;
        }
        return tool.createGuard(before, before.graph().unique(IsNullNode.create(object)), DeoptimizationReason.NullCheckException, DeoptimizationAction.InvalidateReprofile, SpeculationLog.NO_SPECULATION, true, null);
    }

    protected ValueNode createNullCheckedValue(ValueNode object, FixedNode before, LoweringTool tool) {
        GuardingNode nullCheck = this.createNullCheck(object, before, tool);
        if (nullCheck == null) {
            return object;
        }
        return before.graph().addOrUnique(PiNode.create(object, StampFactory.objectNonNull(), (ValueNode)((Object)nullCheck)));
    }

    @Override
    public ValueNode reconstructArrayIndex(JavaKind elementKind, AddressNode address) {
        StructuredGraph graph = address.graph();
        ValueNode offset = ((OffsetAddressNode)address).getOffset();
        int base = this.metaAccess.getArrayBaseOffset(elementKind);
        ValueNode scaledIndex = graph.unique(new SubNode(offset, ConstantNode.forIntegerStamp(offset.stamp(NodeView.DEFAULT), base, graph)));
        int shift = CodeUtil.log2((int)this.metaAccess.getArrayIndexScale(elementKind));
        ValueNode ret = graph.unique(new RightShiftNode(scaledIndex, ConstantNode.forInt(shift, graph)));
        return IntegerConvertNode.convert(ret, StampFactory.forKind(JavaKind.Int), graph, NodeView.DEFAULT);
    }

    @Override
    public boolean supportsOptimizedFilling(OptionValues options) {
        return false;
    }
}

