/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.BigIntegerMultiplyToLenNode;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class BigIntegerSnippets
implements Snippets {
    protected static final MetaAccessProvider INJECTED_METAACCESS = null;

    @Snippet(allowMissingProbabilities=true)
    public static int[] implMultiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] zIn) {
        int zLen;
        int[] zResult = zIn;
        if (zResult == null || zResult.length < xlen + ylen) {
            zLen = xlen + ylen;
            zResult = new int[xlen + ylen];
        } else {
            zLen = zIn.length;
        }
        BigIntegerMultiplyToLenNode.apply(BigIntegerSnippets.arrayStart(x), xlen, BigIntegerSnippets.arrayStart(y), ylen, BigIntegerSnippets.arrayStart(zResult), zLen);
        return zResult;
    }

    private static Word arrayStart(int[] a) {
        return (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(a, ReplacementsUtil.getArrayBaseOffset(INJECTED_METAACCESS, JavaKind.Int)));
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        public final SnippetTemplate.SnippetInfo implMultiplyToLen;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.implMultiplyToLen = this.snippet(providers, BigIntegerSnippets.class, "implMultiplyToLen", new LocationIdentity[0]);
        }
    }
}

