/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.printer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugVerifyHandler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;

public class NoDeadCodeVerifyHandler
implements DebugVerifyHandler {
    private static final int OFF = 0;
    private static final int INFO = 1;
    private static final int VERBOSE = 2;
    private static final int FATAL = 3;
    private static final Map<String, Boolean> discovered = new ConcurrentHashMap<String, Boolean>();

    @Override
    public void verify(DebugContext debug, Object object, String format, Object ... args) {
        OptionValues options = debug.getOptions();
        if (Options.NDCV.getValue(options) != 0 && object instanceof StructuredGraph) {
            StructuredGraph graph = (StructuredGraph)object;
            List<Node> before = graph.getNodes().snapshot();
            new DeadCodeEliminationPhase().run(graph);
            List<Node> after = graph.getNodes().snapshot();
            assert (after.size() <= before.size()) : Assertions.errorMessageContext("after", after, "before", before);
            if (before.size() != after.size() && discovered.put(format, Boolean.TRUE) == null) {
                before.removeAll(after);
                Object prefix = format == null ? "" : format + ": ";
                GraalError error = new GraalError("%sfound dead nodes in %s: %s", prefix, graph, before);
                if (Options.NDCV.getValue(options) == 1) {
                    System.out.println(error.getMessage());
                } else if (Options.NDCV.getValue(options) == 2) {
                    error.printStackTrace(System.out);
                } else {
                    assert (Options.NDCV.getValue(options) == 3) : "Must be fatal at that point";
                    throw error;
                }
            }
        }
    }

    static class Options {
        public static final OptionKey<Integer> NDCV = new OptionKey<Integer>(0);

        Options() {
        }
    }
}

