/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.printer;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugDumpHandler;
import jdk.graal.compiler.debug.DebugHandler;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.printer.BciBlockMappingDumpHandler;
import jdk.graal.compiler.printer.BinaryGraphPrinter;
import jdk.graal.compiler.printer.CFGPrinterObserver;
import jdk.graal.compiler.printer.CanonicalStringGraphPrinter;
import jdk.graal.compiler.printer.GraphPrinterDumpHandler;
import jdk.graal.compiler.printer.NoDeadCodeVerifyHandler;
import jdk.graal.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=DebugHandlersFactory.class)
public class GraalDebugHandlersFactory
implements DebugHandlersFactory {
    private final SnippetReflectionProvider snippetReflection;

    public GraalDebugHandlersFactory() {
        this.snippetReflection = null;
    }

    public GraalDebugHandlersFactory(SnippetReflectionProvider snippetReflection) {
        this.snippetReflection = snippetReflection;
    }

    @Override
    public List<DebugHandler> createHandlers(OptionValues options) {
        ArrayList<DebugHandler> handlers = new ArrayList<DebugHandler>();
        handlers.add(new GraphPrinterDumpHandler((debug, graph) -> new BinaryGraphPrinter(debug, this.snippetReflection)));
        if (DebugOptions.PrintCanonicalGraphStrings.getValue(options).booleanValue()) {
            handlers.add(new GraphPrinterDumpHandler((debug, graph) -> GraalDebugHandlersFactory.createStringPrinter(this.snippetReflection)));
        }
        handlers.add(new NodeDumper());
        handlers.add(new CFGPrinterObserver());
        handlers.add(new NoDeadCodeVerifyHandler());
        if (DebugOptions.PrintBlockMapping.getValue(options).booleanValue()) {
            handlers.add(new BciBlockMappingDumpHandler());
        }
        return handlers;
    }

    private static CanonicalStringGraphPrinter createStringPrinter(SnippetReflectionProvider snippetReflection) {
        return new CanonicalStringGraphPrinter(snippetReflection);
    }

    static StructuredGraph.ScheduleResult tryGetSchedule(DebugContext debug, StructuredGraph graph) {
        StructuredGraph.ScheduleResult scheduleResult = graph.getLastSchedule();
        if (scheduleResult == null && (DebugOptions.PrintGraphWithSchedule.getValue(graph.getOptions()).booleanValue() || debug.contextLookup(Throwable.class) != null)) {
            try (DebugCloseable noIntercept = debug.disableIntercept();){
                SchedulePhase.runWithoutContextOptimizations(graph);
                scheduleResult = graph.getLastSchedule();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return scheduleResult;
    }

    private static class NodeDumper
    implements DebugDumpHandler {
        private NodeDumper() {
        }

        @Override
        public void dump(Object object, DebugContext debug, boolean forced, String format, Object ... arguments) {
            if (debug.isLogEnabled() && object instanceof Node) {
                Node node = (Node)object;
                String location = GraphUtil.approxSourceLocation(node);
                String nodeName = node.toString(Verbosity.Debugger);
                if (location != null) {
                    debug.log("Context obj %s (approx. location: %s)", (Object)nodeName, (Object)location);
                } else {
                    debug.log("Context obj %s", (Object)nodeName);
                }
            }
        }
    }
}

