/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.util;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeFlood;
import jdk.graal.compiler.graph.NodeStack;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.GuardPhiNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.graph.ReentrantBlockIterator;
import jdk.graal.compiler.phases.graph.StatelessPostOrderNodeIterator;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class GraphOrder {
    private static final int MAX_DEAD_NODE_SEARCHES = 8;

    private GraphOrder() {
    }

    public static boolean assertNonCyclicGraph(StructuredGraph graph) {
        List<Node> order = GraphOrder.createOrder(graph);
        NodeBitMap visited = graph.createNodeBitMap();
        visited.clearAll();
        for (Node node : order) {
            if (node instanceof PhiNode && ((PhiNode)node).merge() instanceof LoopBeginNode) {
                assert (visited.isMarked(((PhiNode)node).valueAt(0)));
            } else {
                for (Node input : node.inputs()) {
                    if (!visited.isMarked(input) && !(input instanceof FrameState)) assert (false) : "unexpected cycle detected at input " + String.valueOf(node) + " -> " + String.valueOf(input);
                }
            }
            visited.mark(node);
        }
        return true;
    }

    private static List<Node> createOrder(StructuredGraph graph) {
        final ArrayList<Node> nodes = new ArrayList<Node>();
        final NodeBitMap visited = graph.createNodeBitMap();
        final NodeStack stack = new NodeStack();
        new StatelessPostOrderNodeIterator(graph.start()){

            @Override
            protected void node(FixedNode node) {
                GraphOrder.orderNodeAndNeighbors(nodes, visited, stack, node);
            }
        }.apply();
        return nodes;
    }

    private static void orderNodeAndNeighbors(ArrayList<Node> nodes, NodeBitMap visited, NodeStack stack, FixedNode fixedNode) {
        try {
            GraalError.guarantee(fixedNode == null || fixedNode.isAlive(), "%s not alive", (Object)fixedNode);
            if (fixedNode == null || visited.isMarked(fixedNode)) {
                return;
            }
            visited.mark(fixedNode);
            FrameState stateAfter = null;
            if (fixedNode instanceof StateSplit) {
                stateAfter = ((StateSplit)((Object)fixedNode)).stateAfter();
            }
            GraphOrder.visitTransitiveInputs(nodes, visited, fixedNode, stateAfter, stack);
            if (fixedNode instanceof EndNode) {
                EndNode end = (EndNode)fixedNode;
                for (PhiNode phi : end.merge().phis()) {
                    ValueNode phiValue = phi.valueAt(end);
                    if (phiValue == null) {
                        GraalError.guarantee(phi instanceof GuardPhiNode, "only guard phis may have null values: %s", (Object)phi);
                        continue;
                    }
                    if (visited.isMarked(phiValue)) continue;
                    visited.mark(phiValue);
                    GraphOrder.visitTransitiveInputs(nodes, visited, phiValue, stateAfter, stack);
                    nodes.add(phiValue);
                }
            }
            nodes.add(fixedNode);
            if (fixedNode instanceof AbstractMergeNode) {
                AbstractMergeNode merge = (AbstractMergeNode)fixedNode;
                for (PhiNode phi : merge.phis()) {
                    visited.mark(phi);
                    nodes.add(phi);
                }
            }
            if (stateAfter != null && !visited.isMarked(stateAfter)) {
                visited.mark(stateAfter);
                GraphOrder.visitTransitiveInputs(nodes, visited, stateAfter, null, stack);
                nodes.add(stateAfter);
            }
        }
        catch (GraalError e) {
            throw GraalGraphError.transformAndAddContext(e, fixedNode);
        }
    }

    private static void visitTransitiveInputs(ArrayList<Node> nodes, NodeBitMap visited, Node visitRoot, FrameState excludeNode, NodeStack stack) {
        GraalError.guarantee(stack.isEmpty(), "stack must be empty, it's only shared to avoid allocations");
        stack.push(visitRoot);
        while (!stack.isEmpty()) {
            Node top = stack.peek();
            for (Node input : top.inputs()) {
                if (input == excludeNode || visited.isMarked(input)) continue;
                stack.push(input);
            }
            if (stack.peek() != top) continue;
            if (top != visitRoot) {
                if (top instanceof FixedNode) {
                    throw new GraalError("unexpected reference to fixed node: %s (this indicates an unexpected cycle)", top);
                }
                if (!visited.isMarked(top)) {
                    nodes.add(top);
                }
                visited.mark(top);
            }
            stack.pop();
        }
    }

    public static boolean assertSchedulableGraph(StructuredGraph g) {
        assert (GraphOrder.assertNonCyclicGraph(g));
        assert (g.getGuardsStage().areFrameStatesAtDeopts() || GraphOrder.assertScheduleableBeforeFSA(g));
        if (g.getGuardsStage().areFrameStatesAtDeopts() && Assertions.detailedAssertionsEnabled(g.getOptions())) {
            SchedulePhase.runWithoutContextOptimizations(g, SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS, true);
        }
        return true;
    }

    private static boolean assertScheduleableBeforeFSA(final StructuredGraph graph) {
        assert (!graph.getGuardsStage().areFrameStatesAtDeopts()) : "Cannot use the BlockIteratorClosure after FrameState Assignment, HIR Loop Data Structures are no longer valid.";
        try (DebugContext.Scope s = graph.getDebug().scope("AssertSchedulableGraph");){
            SchedulePhase.runWithoutContextOptimizations(graph, GraphOrder.getSchedulingPolicy(graph), true);
            final EconomicMap loopEntryStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            final NodeBitMap deadNodes = GraphOrder.computeDeadFloatingNodes(graph);
            ReentrantBlockIterator.BlockIteratorClosure<NodeBitMap> closure = new ReentrantBlockIterator.BlockIteratorClosure<NodeBitMap>(){

                @Override
                protected NodeBitMap processBlock(final HIRBlock block, final NodeBitMap currentState) {
                    final List<Node> list = graph.getLastSchedule().getBlockToNodesMap().get(block);
                    AbstractBeginNode blockBegin = block.getBeginNode();
                    if (blockBegin instanceof AbstractMergeNode) {
                        AbstractMergeNode merge = (AbstractMergeNode)blockBegin;
                        currentState.markAll(merge.phis());
                        if (merge instanceof LoopBeginNode) {
                            LoopBeginNode loopBegin = (LoopBeginNode)merge;
                            loopEntryStates.put((Object)loopBegin, (Object)currentState.copy());
                        }
                    }
                    FrameState pendingStateAfter = null;
                    for (final Node node : list) {
                        FrameState stateAfter;
                        if (deadNodes.isMarked(node) || !(node instanceof ValueNode)) continue;
                        FrameState frameState = stateAfter = node instanceof StateSplit ? ((StateSplit)((Object)node)).stateAfter() : null;
                        if (node instanceof FullInfopointNode) {
                            stateAfter = ((FullInfopointNode)node).getState();
                        }
                        if (pendingStateAfter != null && node instanceof FixedNode) {
                            pendingStateAfter.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(this){

                                @Override
                                public void apply(Node from, Position p) {
                                    Node usage = from;
                                    Node nonVirtualNode = p.get(from);
                                    assert (currentState.isMarked(nonVirtualNode) || nonVirtualNode instanceof VirtualObjectNode || nonVirtualNode instanceof ConstantNode) : String.valueOf(nonVirtualNode) + " not available at virtualstate " + String.valueOf(usage) + " before " + String.valueOf(node) + " in block " + String.valueOf(block) + " \n" + String.valueOf(list);
                                }
                            });
                            pendingStateAfter = null;
                        }
                        if (node instanceof AbstractMergeNode) {
                            GraalError.guarantee(node == blockBegin, "block should contain only one merge, found %s, expected %s", (Object)node, (Object)blockBegin);
                        } else if (node instanceof ProxyNode) {
                            assert (false) : "proxy nodes should not be in the schedule";
                        } else if (node instanceof LoopExitNode) {
                            if (graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
                                for (ProxyNode proxy : ((LoopExitNode)node).proxies()) {
                                    for (Node input : proxy.inputs()) {
                                        if (input != proxy.proxyPoint()) assert (currentState.isMarked(input)) : String.valueOf(input) + " not available at " + String.valueOf(proxy) + " in block " + String.valueOf(block) + "\n" + String.valueOf(list);
                                    }
                                }
                                currentState.clearAll();
                                currentState.markAll((Iterable)loopEntryStates.get((Object)((LoopExitNode)node).loopBegin()));
                            }
                            currentState.markAll(((LoopExitNode)node).proxies());
                        } else {
                            for (Node input : node.inputs()) {
                                if (input == stateAfter) continue;
                                if (input instanceof FrameState) {
                                    ((FrameState)input).applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(this){

                                        @Override
                                        public void apply(Node from, Position p) {
                                            Node nonVirtual = p.get(from);
                                            assert (currentState.isMarked(nonVirtual)) : String.valueOf(nonVirtual) + " not available at " + String.valueOf(node) + " in block " + String.valueOf(block) + "\n" + String.valueOf(list);
                                        }
                                    });
                                    continue;
                                }
                                assert (currentState.isMarked(input) || input instanceof VirtualObjectNode || input instanceof ConstantNode) : String.valueOf(input) + " not available at " + String.valueOf(node) + " in block " + String.valueOf(block) + "\n" + String.valueOf(list);
                            }
                        }
                        if (node instanceof AbstractEndNode) {
                            AbstractMergeNode merge = ((AbstractEndNode)node).merge();
                            for (PhiNode phi : merge.phis()) {
                                if (deadNodes.isMarked(phi)) continue;
                                ValueNode phiValue = phi.valueAt((AbstractEndNode)node);
                                assert (phiValue == null || currentState.isMarked(phiValue) || phiValue instanceof ConstantNode) : String.valueOf(phiValue) + " not available at phi " + String.valueOf(phi) + " / end " + String.valueOf(node) + " in block " + String.valueOf(block);
                            }
                        }
                        if (stateAfter != null) {
                            assert (pendingStateAfter == null);
                            pendingStateAfter = stateAfter;
                        }
                        currentState.mark(node);
                    }
                    if (pendingStateAfter != null) {
                        pendingStateAfter.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(this){

                            @Override
                            public void apply(Node from, Position p) {
                                Node usage = from;
                                Node nonVirtualNode = p.get(from);
                                assert (currentState.isMarked(nonVirtualNode) || nonVirtualNode instanceof VirtualObjectNode || nonVirtualNode instanceof ConstantNode) : String.valueOf(nonVirtualNode) + " not available at virtualstate " + String.valueOf(usage) + " at end of block " + String.valueOf(block) + " \n" + String.valueOf(list);
                            }
                        });
                    }
                    return currentState;
                }

                @Override
                protected NodeBitMap merge(HIRBlock merge, List<NodeBitMap> states) {
                    NodeBitMap result = states.get(0);
                    for (int i = 1; i < states.size(); ++i) {
                        result.intersect(states.get(i));
                    }
                    return result;
                }

                @Override
                protected NodeBitMap getInitialState() {
                    NodeBitMap ret = graph.createNodeBitMap();
                    ret.markAll(graph.getNodes().filter(ConstantNode.class));
                    return ret;
                }

                @Override
                protected NodeBitMap cloneState(NodeBitMap oldState) {
                    return oldState.copy();
                }
            };
            ReentrantBlockIterator.apply(closure, schedule.getCFG().getStartBlock());
        }
        catch (Throwable t) {
            graph.getDebug().handle(t);
        }
        return true;
    }

    private static NodeBitMap computeDeadFloatingNodes(StructuredGraph graph) {
        NodeBitMap deadNodes = graph.createNodeBitMap();
        for (PhiNode phi : graph.getNodes().filter(PhiNode.class)) {
            NodeFlood nf;
            if (!phi.isLoopPhi() || !CanonicalizerPhase.isDeadLoopPhiCycle(phi, nf = graph.createNodeFlood())) continue;
            for (Node visitedNode : nf.getVisited()) {
                deadNodes.mark(visitedNode);
            }
        }
        int computes = 0;
        boolean change = true;
        NodeBitMap toProcess = graph.createNodeBitMap();
        while (change && computes++ <= 8) {
            toProcess.clearAll();
            change = false;
            for (Node dead : deadNodes) {
                for (Node input : dead.inputs()) {
                    if (deadNodes.contains(input)) continue;
                    toProcess.mark(input);
                }
            }
            block5: for (Node n : toProcess) {
                if (!GraphUtil.isFloatingNode(n) || GraphOrder.isNeverDeadFloatingNode(n) || deadNodes.isMarked(n)) continue;
                for (Node usage : n.usages()) {
                    if (deadNodes.isMarked(usage)) continue;
                    continue block5;
                }
                deadNodes.mark(n);
                change = true;
            }
        }
        return deadNodes;
    }

    private static boolean isNeverDeadFloatingNode(Node n) {
        return n instanceof GuardNode || n instanceof VirtualState;
    }

    private static SchedulePhase.SchedulingStrategy getSchedulingPolicy(StructuredGraph graph) {
        return graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) ? SchedulePhase.SchedulingStrategy.EARLIEST : SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS;
    }
}

