/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.schedule;

import java.util.ArrayDeque;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MemoryProxyNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.cfg.HIRLoop;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryPhiNode;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.phases.graph.ReentrantBlockIterator;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public final class ScheduleVerification
extends ReentrantBlockIterator.BlockIteratorClosure<EconomicSet<FloatingReadNode>> {
    private final BlockMap<List<Node>> blockToNodesMap;
    private final NodeMap<HIRBlock> nodeMap;
    private final StructuredGraph graph;

    public static boolean check(HIRBlock startBlock, BlockMap<List<Node>> blockToNodesMap, NodeMap<HIRBlock> nodeMap) {
        ReentrantBlockIterator.apply(new ScheduleVerification(blockToNodesMap, nodeMap, startBlock.getBeginNode().graph()), startBlock);
        return true;
    }

    private ScheduleVerification(BlockMap<List<Node>> blockToNodesMap, NodeMap<HIRBlock> nodeMap, StructuredGraph graph) {
        this.blockToNodesMap = blockToNodesMap;
        this.nodeMap = nodeMap;
        this.graph = graph;
    }

    @Override
    protected EconomicSet<FloatingReadNode> getInitialState() {
        return EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    }

    @Override
    protected EconomicSet<FloatingReadNode> processBlock(HIRBlock block, EconomicSet<FloatingReadNode> currentState) {
        AbstractBeginNode beginNode = block.getBeginNode();
        if (beginNode instanceof AbstractMergeNode) {
            AbstractMergeNode abstractMergeNode = (AbstractMergeNode)beginNode;
            for (PhiNode phi : abstractMergeNode.phis()) {
                if (!(phi instanceof MemoryPhiNode)) continue;
                MemoryPhiNode memoryPhiNode = (MemoryPhiNode)phi;
                ScheduleVerification.addFloatingReadUsages(currentState, memoryPhiNode);
            }
        }
        if (beginNode instanceof LoopExitNode) {
            LoopExitNode loopExitNode = (LoopExitNode)beginNode;
            for (ProxyNode proxy : loopExitNode.proxies()) {
                if (!(proxy instanceof MemoryProxyNode)) continue;
                LocationIdentity[] memoryProxyNode = (LocationIdentity[])proxy;
                ScheduleVerification.addFloatingReadUsages(currentState, (Node)memoryProxyNode);
            }
        }
        for (Node n : this.blockToNodesMap.get(block)) {
            FloatingReadNode floatingReadNode;
            if (MemoryKill.isMemoryKill(n)) {
                if (MemoryKill.isSingleMemoryKill(n)) {
                    SingleMemoryKill single = (SingleMemoryKill)((Object)n);
                    this.processLocation(n, single.getKilledLocationIdentity(), currentState);
                } else if (MemoryKill.isMultiMemoryKill(n)) {
                    MultiMemoryKill multi = (MultiMemoryKill)((Object)n);
                    for (LocationIdentity location : multi.getKilledLocationIdentities()) {
                        this.processLocation(n, location, currentState);
                    }
                }
                ScheduleVerification.addFloatingReadUsages(currentState, n);
            } else if (n instanceof MemoryAccess) {
                ScheduleVerification.addFloatingReadUsages(currentState, n);
            } else if (n instanceof FloatingReadNode && (floatingReadNode = (FloatingReadNode)n).getLastLocationAccess() != null && floatingReadNode.getLocationIdentity().isMutable()) {
                if (currentState.contains((Object)floatingReadNode)) {
                    currentState.remove((Object)floatingReadNode);
                } else {
                    throw new RuntimeException("Floating read node " + String.valueOf(n) + " was not found in the state, i.e., it was killed by a memory check point before its place in the schedule. Block=" + String.valueOf(block) + ", block begin: " + String.valueOf(block.getBeginNode()) + " block loop: " + String.valueOf(block.getLoop()) + ", " + String.valueOf(this.blockToNodesMap.get(block).get(0)));
                }
            }
            assert (this.nodeMap.get(n) == block) : Assertions.errorMessageContext("n", n, "block", block);
            if (!this.graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) || block.getLoop() == null || n instanceof VirtualState) continue;
            for (Node usage : n.usages()) {
                HIRBlock usageBlock;
                LoopExitNode loopExitNode;
                Node usageNode = usage;
                if (usageNode instanceof PhiNode) {
                    PhiNode phiNode = (PhiNode)usage;
                    usageNode = phiNode.merge();
                }
                if (usageNode instanceof LoopExitNode && ((loopExitNode = (LoopExitNode)usageNode).loopBegin() == n || loopExitNode.stateAfter() == n) || (usageBlock = this.nodeMap.get(usageNode)) == null && (usage instanceof FloatingNode || usage instanceof VirtualState || usage instanceof CallTargetNode) && !(usage instanceof GuardNode) && ScheduleVerification.nonFixedNodeTreeWithoutUsages(usage)) continue;
                assert (usageBlock != null || usage instanceof ProxyNode) : "Usage " + String.valueOf(usageNode) + " of node " + String.valueOf(n) + " has no block";
                CFGLoop<HIRBlock> usageLoop = null;
                if (usageNode instanceof ProxyNode) {
                    ProxyNode proxyNode = (ProxyNode)usageNode;
                    usageLoop = this.nodeMap.get(proxyNode.proxyPoint().loopBegin()).getLoop();
                } else if (usageBlock.getBeginNode() instanceof LoopExitNode) {
                    LoopExitNode loopExitNode2 = (LoopExitNode)usageBlock.getBeginNode();
                    usageLoop = this.nodeMap.get(loopExitNode2.loopBegin()).getLoop();
                } else {
                    usageLoop = usageBlock.getLoop();
                }
                assert (usageLoop != null) : String.valueOf(n) + ", " + String.valueOf(this.nodeMap.get(n)) + " / " + String.valueOf(usageNode) + ", " + String.valueOf(this.nodeMap.get(usageNode));
                while (usageLoop != block.getLoop() && usageLoop != null) {
                    usageLoop = usageLoop.getParent();
                }
                assert (usageLoop != null) : String.valueOf(n) + ", " + String.valueOf(usageNode) + ", " + String.valueOf(usageBlock) + ", " + String.valueOf(usageBlock.getLoop()) + ", " + String.valueOf(block) + ", " + String.valueOf(block.getLoop());
            }
        }
        return currentState;
    }

    private static boolean nonFixedNodeTreeWithoutUsages(Node n) {
        if (!(n instanceof FloatingNode || n instanceof VirtualState || n instanceof CallTargetNode)) {
            return false;
        }
        NodeBitMap visited = n.graph().createNodeBitMap();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        stack.push(n);
        while (!stack.isEmpty()) {
            Node cur = (Node)stack.pop();
            if (visited.isMarked(cur)) continue;
            if (!(cur instanceof FloatingNode || cur instanceof VirtualState || cur instanceof CallTargetNode)) {
                return false;
            }
            visited.mark(cur);
            for (Node usage : cur.usages()) {
                stack.push(usage);
            }
        }
        return true;
    }

    private static void addFloatingReadUsages(EconomicSet<FloatingReadNode> currentState, Node n) {
        for (FloatingReadNode read : n.usages().filter(FloatingReadNode.class)) {
            if (read.getLastLocationAccess() != n || !read.getLocationIdentity().isMutable()) continue;
            currentState.add((Object)read);
        }
    }

    private void processLocation(Node n, LocationIdentity location, EconomicSet<FloatingReadNode> currentState) {
        assert (n != null);
        if (location.isImmutable()) {
            return;
        }
        for (FloatingReadNode r : this.cloneState(currentState)) {
            if (!r.getLocationIdentity().overlaps(location)) continue;
            r.getDebug().log(3, "%s removing %s from state", (Object)n, (Object)r);
            currentState.remove((Object)r);
        }
    }

    @Override
    protected EconomicSet<FloatingReadNode> merge(HIRBlock merge, List<EconomicSet<FloatingReadNode>> states) {
        EconomicSet<FloatingReadNode> result = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            result.retainAll(states.get(i));
        }
        return result;
    }

    @Override
    protected EconomicSet<FloatingReadNode> cloneState(EconomicSet<FloatingReadNode> oldState) {
        EconomicSet result = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        if (oldState != null) {
            result.addAll(oldState);
        }
        return result;
    }

    @Override
    protected List<EconomicSet<FloatingReadNode>> processLoop(CFGLoop<HIRBlock> loop, EconomicSet<FloatingReadNode> initialState) {
        HIRLoop l = (HIRLoop)loop;
        for (MemoryPhiNode memoryPhi : ((LoopBeginNode)((HIRBlock)l.getHeader()).getBeginNode()).memoryPhis()) {
            for (FloatingReadNode r : this.cloneState(initialState)) {
                if (!r.getLocationIdentity().overlaps(memoryPhi.getLocationIdentity())) continue;
                initialState.remove((Object)r);
            }
        }
        return ReentrantBlockIterator.processLoop(this, loop, initialState).exitStates;
    }
}

