/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.graph;

import java.util.List;
import java.util.ListIterator;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.util.GraphUtil;

public abstract class ScheduledNodeIterator {
    private FixedWithNextNode lastFixed;
    private FixedWithNextNode reconnect;
    private ListIterator<Node> iterator;
    protected final StructuredGraph.ScheduleResult schedule;

    public ScheduledNodeIterator(StructuredGraph.ScheduleResult schedule) {
        this.schedule = schedule;
    }

    public void processNodes(HIRBlock block) {
        this.lastFixed = block.getBeginNode();
        assert (this.lastFixed != null);
        this.reconnect = null;
        this.iterator = this.schedule.nodesFor(block).listIterator();
        while (this.iterator.hasNext()) {
            Node node = this.iterator.next();
            if (!node.isAlive()) continue;
            if (this.reconnect != null && node instanceof FixedNode) {
                this.reconnect.setNext((FixedNode)node);
                this.reconnect = null;
            }
            if (node instanceof FixedWithNextNode) {
                this.lastFixed = (FixedWithNextNode)node;
            }
            this.processNode(node, block, this.iterator);
        }
        if (this.reconnect != null) {
            assert (block.getSuccessorCount() == 1) : Assertions.errorMessage(block);
            this.reconnect.setNext(block.getFirstSuccessor().getBeginNode());
        }
    }

    protected void insert(FixedNode start, FixedWithNextNode end) {
        this.lastFixed.setNext(start);
        this.lastFixed = end;
        this.reconnect = end;
    }

    protected void replaceCurrent(FixedWithNextNode newNode) {
        List<Node> nodes;
        HIRBlock bLastFixed;
        HIRBlock bCurrent;
        Node current = this.iterator.previous();
        this.iterator.next();
        FixedWithNextNode lastFixedNode = this.lastFixed;
        if (GraphUtil.isFloatingNode(current) && lastFixedNode instanceof AbstractBeginNode && (bCurrent = this.schedule.blockFor(current, true)) == (bLastFixed = this.schedule.blockFor(lastFixedNode, true)) && (nodes = this.schedule.nodesFor(bLastFixed)).indexOf(current) < nodes.indexOf(lastFixedNode)) {
            BeginNode b = this.lastFixed.graph().add(new BeginNode());
            lastFixedNode.replaceAtPredecessor(b);
            b.setNext(lastFixedNode);
            this.lastFixed = b;
            b.graph().getDebug().dump(5, (Object)b.graph(), "After adding new begin %s to establish proper dominance if we lower before", b);
        }
        current.replaceAndDelete(newNode);
        this.insert(newNode, newNode);
        this.iterator.set(newNode);
    }

    protected abstract void processNode(Node var1, HIRBlock var2, ListIterator<Node> var3);
}

