/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class ReentrantBlockIterator {
    private ReentrantBlockIterator() {
    }

    public static <StateT> LoopInfo<StateT> processLoop(BlockIteratorClosure<StateT> closure, CFGLoop<HIRBlock> loop, StateT initialState) {
        EconomicMap<FixedNode, StateT> blockEndStates = ReentrantBlockIterator.apply(closure, loop.getHeader(), initialState, block -> block.getLoop() != loop && !block.isLoopHeader());
        HIRBlock lh = loop.getHeader();
        int predCount = lh.getPredecessorCount();
        LoopInfo info = new LoopInfo(predCount - 1, loop.getLoopExits().size());
        for (int i = 1; i < predCount; ++i) {
            Object endState = blockEndStates.get((Object)((HIRBlock)lh.getPredecessorAt(i)).getEndNode());
            info.endStates.add(closure.cloneState(endState));
        }
        for (HIRBlock loopExit : loop.getLoopExits()) {
            assert (loopExit.getPredecessorCount() == 1) : Assertions.errorMessage(loop, loopExit);
            assert (blockEndStates.containsKey((Object)loopExit.getBeginNode())) : String.valueOf(loopExit.getBeginNode()) + " " + String.valueOf(blockEndStates);
            Object exitState = blockEndStates.get((Object)loopExit.getBeginNode());
            info.exitStates.add(closure.cloneState(exitState));
        }
        return info;
    }

    public static <StateT> void apply(BlockIteratorClosure<StateT> closure, HIRBlock start) {
        ReentrantBlockIterator.apply(closure, start, closure.getInitialState(), null);
    }

    public static <StateT> EconomicMap<FixedNode, StateT> apply(BlockIteratorClosure<StateT> closure, HIRBlock start, StateT initialState, Predicate<HIRBlock> stopAtBlock) {
        ArrayDeque<HIRBlock> blockQueue = new ArrayDeque<HIRBlock>();
        EconomicMap states = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        Object state = initialState;
        HIRBlock current = start;
        while (true) {
            CompilationAlarm.checkProgress(start.getCfg().graph);
            HIRBlock next = null;
            if (stopAtBlock != null && stopAtBlock.test(current)) {
                states.put((Object)current.getBeginNode(), state);
            } else {
                state = closure.processBlock(current, state);
                if (current.getSuccessorCount() != 0) {
                    if (current.getSuccessorCount() == 1) {
                        HIRBlock successor = (HIRBlock)current.getSuccessorAt(0);
                        if (successor.isLoopHeader()) {
                            if (current.isLoopEnd()) {
                                states.put((Object)current.getEndNode(), state);
                            } else {
                                ReentrantBlockIterator.recurseIntoLoop(closure, blockQueue, states, state, successor);
                            }
                        } else if (current.getEndNode() instanceof AbstractEndNode) {
                            AbstractEndNode end = (AbstractEndNode)current.getEndNode();
                            AbstractMergeNode merge = end.merge();
                            if (ReentrantBlockIterator.allEndsVisited(states, current, merge)) {
                                ArrayList<StateT> mergedStates = ReentrantBlockIterator.mergeStates(states, state, current, successor, merge);
                                state = closure.merge(successor, mergedStates);
                                next = successor;
                            } else {
                                assert (!states.containsKey((Object)end));
                                states.put((Object)end, state);
                            }
                        } else {
                            next = successor;
                        }
                    } else {
                        next = ReentrantBlockIterator.processMultipleSuccessors(closure, blockQueue, states, state, current);
                    }
                }
            }
            if (next != null) {
                current = next;
                continue;
            }
            if (blockQueue.isEmpty()) {
                return states;
            }
            current = (HIRBlock)blockQueue.removeFirst();
            assert (current.getPredecessorCount() == 1) : Assertions.errorMessage(current);
            assert (states.containsKey((Object)current.getBeginNode()));
            state = states.removeKey((Object)current.getBeginNode());
        }
    }

    private static <StateT> boolean allEndsVisited(EconomicMap<FixedNode, StateT> states, HIRBlock current, AbstractMergeNode merge) {
        for (AbstractEndNode abstractEndNode : merge.forwardEnds()) {
            if (abstractEndNode == current.getEndNode() || states.containsKey((Object)abstractEndNode)) continue;
            return false;
        }
        return true;
    }

    private static <StateT> HIRBlock processMultipleSuccessors(BlockIteratorClosure<StateT> closure, Deque<HIRBlock> blockQueue, EconomicMap<FixedNode, StateT> states, StateT state, HIRBlock current) {
        assert (current.getSuccessorCount() > 1) : Assertions.errorMessageContext("current", current);
        for (int i = 1; i < current.getSuccessorCount(); ++i) {
            HIRBlock successor = (HIRBlock)current.getSuccessorAt(i);
            blockQueue.addFirst(successor);
            states.put((Object)successor.getBeginNode(), closure.afterSplit(successor, closure.cloneState(state)));
        }
        return (HIRBlock)current.getSuccessorAt(0);
    }

    private static <StateT> ArrayList<StateT> mergeStates(EconomicMap<FixedNode, StateT> states, StateT state, HIRBlock current, HIRBlock successor, AbstractMergeNode merge) {
        ArrayList<StateT> mergedStates = new ArrayList<StateT>(merge.forwardEndCount());
        for (int i = 0; i < successor.getPredecessorCount(); ++i) {
            HIRBlock predecessor = (HIRBlock)successor.getPredecessorAt(i);
            assert (predecessor == current || states.containsKey((Object)predecessor.getEndNode()));
            StateT endState = predecessor == current ? state : states.removeKey((Object)predecessor.getEndNode());
            mergedStates.add(endState);
        }
        return mergedStates;
    }

    private static <StateT> void recurseIntoLoop(BlockIteratorClosure<StateT> closure, Deque<HIRBlock> blockQueue, EconomicMap<FixedNode, StateT> states, StateT state, HIRBlock successor) {
        CFGLoop<HIRBlock> loop = successor.getLoop();
        LoopBeginNode loopBegin = (LoopBeginNode)loop.getHeader().getBeginNode();
        assert (successor.getBeginNode() == loopBegin) : Assertions.errorMessage(successor, successor.getBeginNode(), loopBegin);
        List<StateT> exitStates = closure.processLoop(loop, state);
        int i = 0;
        assert (loop.getLoopExits().size() == exitStates.size()) : Assertions.errorMessage(loop, loop.getLoopExits(), exitStates);
        for (HIRBlock exit : loop.getLoopExits()) {
            states.put((Object)exit.getBeginNode(), exitStates.get(i++));
            blockQueue.addFirst(exit);
        }
    }

    public static abstract class BlockIteratorClosure<StateT> {
        protected abstract StateT getInitialState();

        protected abstract StateT processBlock(HIRBlock var1, StateT var2);

        protected abstract StateT merge(HIRBlock var1, List<StateT> var2);

        protected abstract StateT cloneState(StateT var1);

        protected StateT afterSplit(HIRBlock successor, StateT oldState) {
            return oldState;
        }

        protected List<StateT> processLoop(CFGLoop<HIRBlock> loop, StateT initialState) {
            return ReentrantBlockIterator.processLoop(this, loop, initialState).exitStates;
        }
    }

    public static class LoopInfo<StateT> {
        public final List<StateT> endStates;
        public final List<StateT> exitStates;

        public LoopInfo(int endCount, int exitCount) {
            this.endStates = new ArrayList<StateT>(endCount);
            this.exitStates = new ArrayList<StateT>(exitCount);
        }
    }
}

