/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Set;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.graph.MergeableState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public abstract class PostOrderNodeIterator<T extends MergeableState<T>> {
    private final NodeBitMap visitedEnds;
    private final Deque<AbstractBeginNode> nodeQueue;
    private final EconomicMap<FixedNode, T> nodeStates;
    private final FixedNode start;
    protected T state;

    public PostOrderNodeIterator(FixedNode start, T initialState) {
        StructuredGraph graph = start.graph();
        this.visitedEnds = graph.createNodeBitMap();
        this.nodeQueue = new ArrayDeque<AbstractBeginNode>();
        this.nodeStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        this.start = start;
        this.state = initialState;
    }

    public void apply() {
        FixedNode current = this.start;
        do {
            if (current instanceof InvokeWithExceptionNode) {
                this.invokeWithException((InvokeWithExceptionNode)current);
                this.queueSuccessors(current, null);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof LoopBeginNode) {
                ((MergeableState)this.state).loopBegin((LoopBeginNode)current);
                this.nodeStates.put((Object)current, this.state);
                this.state = (MergeableState)((MergeableState)this.state).clone();
                this.loopBegin((LoopBeginNode)current);
                current = ((LoopBeginNode)current).next();
                assert (current != null);
                continue;
            }
            if (current instanceof LoopEndNode) {
                this.loopEnd((LoopEndNode)current);
                this.finishLoopEnds((LoopEndNode)current);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof AbstractMergeNode) {
                this.merge((AbstractMergeNode)current);
                current = ((AbstractMergeNode)current).next();
                assert (current != null);
                continue;
            }
            if (current instanceof FixedWithNextNode) {
                FixedNode next = ((FixedWithNextNode)current).next();
                assert (next != null) : current;
                this.node(current);
                current = next;
                continue;
            }
            if (current instanceof EndNode) {
                this.end((EndNode)current);
                this.queueMerge((EndNode)current);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof ControlSinkNode) {
                this.node(current);
                current = this.nextQueuedNode();
                continue;
            }
            if (current instanceof ControlSplitNode) {
                Set<Node> successors = this.controlSplit((ControlSplitNode)current);
                this.queueSuccessors(current, successors);
                current = this.nextQueuedNode();
                continue;
            }
            assert (false) : current;
        } while (current != null);
        this.finished();
    }

    private void queueSuccessors(FixedNode x, Set<Node> successors) {
        this.nodeStates.put((Object)x, this.state);
        if (successors != null) {
            for (Node node : successors) {
                if (node == null) continue;
                this.nodeStates.put((Object)((FixedNode)node.predecessor()), this.state);
                this.nodeQueue.addFirst((AbstractBeginNode)node);
            }
        } else {
            for (Node node : x.successors()) {
                if (node == null) continue;
                this.nodeQueue.addFirst((AbstractBeginNode)node);
            }
        }
    }

    private FixedNode nextQueuedNode() {
        int maxIterations = this.nodeQueue.size();
        while (maxIterations-- > 0) {
            AbstractBeginNode node = this.nodeQueue.removeFirst();
            if (node instanceof AbstractMergeNode) {
                AbstractMergeNode merge = (AbstractMergeNode)node;
                this.state = (MergeableState)((MergeableState)this.nodeStates.get((Object)merge.forwardEndAt(0))).clone();
                ArrayList<MergeableState> states = new ArrayList<MergeableState>(merge.forwardEndCount() - 1);
                for (int i = 1; i < merge.forwardEndCount(); ++i) {
                    MergeableState other = (MergeableState)this.nodeStates.get((Object)merge.forwardEndAt(i));
                    assert (other != null);
                    states.add(other);
                }
                boolean ready = ((MergeableState)this.state).merge(merge, states);
                if (ready) {
                    return merge;
                }
                this.nodeQueue.addLast(merge);
                continue;
            }
            assert (node.predecessor() != null);
            this.state = (MergeableState)((MergeableState)this.nodeStates.get((Object)((FixedNode)node.predecessor()))).clone();
            ((MergeableState)this.state).afterSplit(node);
            return node;
        }
        return null;
    }

    private void finishLoopEnds(LoopEndNode end) {
        assert (!this.visitedEnds.isMarked(end));
        assert (!this.nodeStates.containsKey((Object)end));
        this.nodeStates.put((Object)end, this.state);
        this.visitedEnds.mark(end);
        LoopBeginNode begin = end.loopBegin();
        for (LoopEndNode loopEndNode : begin.loopEnds()) {
            if (this.visitedEnds.isMarked(loopEndNode)) continue;
            return;
        }
        ArrayList<MergeableState> states = new ArrayList<MergeableState>(begin.loopEnds().count());
        for (LoopEndNode le : begin.orderedLoopEnds()) {
            states.add((MergeableState)this.nodeStates.get((Object)le));
        }
        MergeableState mergeableState = (MergeableState)this.nodeStates.get((Object)begin);
        if (mergeableState != null) {
            mergeableState.loopEnds(begin, states);
        }
    }

    private void queueMerge(EndNode end) {
        assert (!this.visitedEnds.isMarked(end));
        assert (!this.nodeStates.containsKey((Object)end));
        this.nodeStates.put((Object)end, this.state);
        this.visitedEnds.mark(end);
        AbstractMergeNode merge = end.merge();
        boolean endsVisited = true;
        for (int i = 0; i < merge.forwardEndCount(); ++i) {
            if (this.visitedEnds.isMarked(merge.forwardEndAt(i))) continue;
            endsVisited = false;
            break;
        }
        if (endsVisited) {
            this.nodeQueue.add(merge);
        }
    }

    protected abstract void node(FixedNode var1);

    protected void end(EndNode endNode) {
        this.node(endNode);
    }

    protected void merge(AbstractMergeNode merge) {
        this.node(merge);
    }

    protected void loopBegin(LoopBeginNode loopBegin) {
        this.node(loopBegin);
    }

    protected void loopEnd(LoopEndNode loopEnd) {
        this.node(loopEnd);
    }

    protected Set<Node> controlSplit(ControlSplitNode controlSplit) {
        this.node(controlSplit);
        return null;
    }

    protected void invokeWithException(InvokeWithExceptionNode invoke) {
        this.node(invoke);
    }

    protected void finished() {
    }
}

