/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.graph;

import java.util.function.ToDoubleFunction;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class FixedNodeRelativeFrequencyCache
implements ToDoubleFunction<FixedNode> {
    private static final CounterKey computeNodeRelativeFrequencyCounter = DebugContext.counter("ComputeNodeRelativeFrequency");
    private final EconomicMap<FixedNode, Double> cache = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    private ControlFlowGraph lastCFG = null;
    private Graph.Mark lastCFGMark = null;

    @Override
    public double applyAsDouble(FixedNode node) {
        assert (node != null);
        computeNodeRelativeFrequencyCounter.increment(node.getDebug());
        FixedNode current = FixedNodeRelativeFrequencyCache.findBegin(node);
        if (current == null) {
            return 1.0;
        }
        assert (current instanceof AbstractBeginNode) : Assertions.errorMessage(current);
        Double cachedValue = (Double)this.cache.get((Object)current);
        if (cachedValue != null) {
            return cachedValue;
        }
        double relativeFrequency = 0.0;
        if (current.predecessor() == null) {
            if (current instanceof AbstractMergeNode) {
                relativeFrequency = this.handleMerge(current, relativeFrequency);
            } else {
                assert (current instanceof StartNode) : Assertions.errorMessage(current);
                relativeFrequency = 1.0;
            }
        } else {
            ControlSplitNode split = (ControlSplitNode)current.predecessor();
            relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(split.probability((AbstractBeginNode)current), this.applyAsDouble(split));
        }
        assert (!Double.isNaN(relativeFrequency) && !Double.isInfinite(relativeFrequency)) : String.valueOf(current) + " " + relativeFrequency;
        this.cache.put((Object)current, (Object)relativeFrequency);
        return relativeFrequency;
    }

    private double handleMerge(FixedNode current, double relativeFrequency) {
        double result = relativeFrequency;
        AbstractMergeNode currentMerge = (AbstractMergeNode)current;
        NodeInputList<EndNode> currentForwardEnds = currentMerge.forwardEnds();
        for (AbstractEndNode abstractEndNode : currentForwardEnds) {
            result += this.applyAsDouble(abstractEndNode);
        }
        if (current instanceof LoopBeginNode) {
            this.computeLazyCFG(current);
            result = ControlFlowGraph.multiplyRelativeFrequencies(result, this.lastCFG.localLoopFrequency((LoopBeginNode)current));
        }
        return result;
    }

    private void computeLazyCFG(FixedNode node) {
        if (this.lastCFG == null || !this.lastCFGMark.isCurrent()) {
            this.lastCFG = ControlFlowGraph.newBuilder(node.graph()).computeFrequency(true).build();
            this.lastCFGMark = node.graph().getMark();
        }
    }

    private static FixedNode findBegin(FixedNode node) {
        FixedNode current = node;
        while (true) {
            CompilationAlarm.checkProgress(node.graph());
            assert (current != null);
            Node predecessor = current.predecessor();
            if (current instanceof AbstractBeginNode) {
                if (predecessor == null) break;
                if (predecessor.successors().count() != 1) {
                    assert (predecessor instanceof ControlSplitNode) : "a FixedNode with multiple successors needs to be a ControlSplitNode: " + String.valueOf(current) + " / " + String.valueOf(predecessor);
                    break;
                }
            } else if (predecessor == null) {
                current = null;
                break;
            }
            current = (FixedNode)predecessor;
        }
        return current;
    }
}

