/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.contract;

import java.util.ArrayList;
import java.util.function.Function;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.contract.PhaseSizeContract;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class NodeCostUtil {
    private static final CounterKey sizeComputationCount = DebugContext.counter("GraphCostComputationCount_Size");
    private static final CounterKey sizeVerificationCount = DebugContext.counter("GraphCostVerificationCount_Size");
    private static final double DELTA = 0.001;

    public static int computeNodesSize(Iterable<Node> nodes) {
        int size = 0;
        for (Node n : nodes) {
            size += n.estimatedNodeSize().value;
        }
        assert (NumUtil.assertNonNegativeInt(size));
        return size;
    }

    public static int computeGraphSize(StructuredGraph graph) {
        sizeComputationCount.increment(graph.getDebug());
        int size = 0;
        for (Node n : graph.getNodes()) {
            size += n.estimatedNodeSize().value;
        }
        assert (NumUtil.assertNonNegativeInt(size));
        return size;
    }

    public static double computeGraphCycles(StructuredGraph graph, boolean fullSchedule) {
        Function<HIRBlock, Iterable> blockToNodes;
        ControlFlowGraph cfg;
        if (fullSchedule) {
            SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS, true);
            cfg = graph.getLastSchedule().getCFG();
            blockToNodes = b -> graph.getLastSchedule().getBlockToNodesMap().get((BasicBlock<?>)b);
        } else {
            cfg = ControlFlowGraph.newBuilder(graph).connectBlocks(true).computeLoops(true).computeFrequency(true).build();
            BlockMap nodes = new BlockMap(cfg);
            for (HIRBlock b2 : cfg.getBlocks()) {
                ArrayList<FixedNode> curNodes = new ArrayList<FixedNode>();
                for (FixedNode node : b2.getNodes()) {
                    curNodes.add(node);
                }
                nodes.put(b2, curNodes);
            }
            blockToNodes = b -> (Iterable)nodes.get((BasicBlock<?>)b);
        }
        double weightedCycles = 0.0;
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("NodeCostSummary");){
            for (HIRBlock block : cfg.getBlocks()) {
                for (Node n : blockToNodes.apply(block)) {
                    double probWeighted = (double)n.estimatedNodeCycles().value * block.getRelativeFrequency();
                    assert (Double.isFinite(probWeighted));
                    weightedCycles += probWeighted;
                    if (!debug.isLogEnabled()) continue;
                    debug.log("Node %s contributes cycles:%f size:%d to graph %s [block freq:%f]", n, (Object)((double)n.estimatedNodeCycles().value * block.getRelativeFrequency()), (Object)n.estimatedNodeSize().value, (Object)graph, (Object)block.getRelativeFrequency());
                }
            }
        }
        assert (NumUtil.assertNonNegativeDouble(weightedCycles));
        assert (Double.isFinite(weightedCycles));
        return weightedCycles;
    }

    private static int deltaCompare(double a, double b, double delta) {
        if (Math.abs(a - b) <= delta) {
            return 0;
        }
        return Double.compare(a, b);
    }

    public static void phaseFulfillsSizeContract(StructuredGraph graph, int codeSizeBefore, int codeSizeAfter, PhaseSizeContract contract) {
        if (codeSizeBefore > BasePhase.PhaseOptions.MinimalGraphNodeSizeCheckSize.getValue(graph.getOptions())) {
            sizeVerificationCount.increment(graph.getDebug());
            double codeSizeIncrease = contract.codeSizeIncrease();
            double graphSizeDelta = (double)codeSizeBefore * 0.001;
            if (NodeCostUtil.deltaCompare(codeSizeAfter, (double)codeSizeBefore * codeSizeIncrease, graphSizeDelta) > 0) {
                ResolvedJavaMethod method = graph.method();
                double increase = (double)codeSizeBefore == 0.0 ? (double)codeSizeAfter : (double)codeSizeAfter / (double)codeSizeBefore;
                throw new GraalGraphError("Phase %s expects to increase code size by at most a factor of %.2f but an increase of %.2f was seen (code size before: %d, after: %d)%s", contract.contractorName(), codeSizeIncrease, increase, codeSizeBefore, codeSizeAfter, method != null ? " when compiling method " + method.format("%H.%n(%p)") + "." : ".");
            }
        }
    }
}

