/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.util;

import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionKey;

public class OptimizationUtility {
    public static <X> X chooseAdaptiveBudgetFactor(StructuredGraph graph, OptionKey<X> coldOption, OptionKey<X> hotOption) {
        return OptimizationUtility.hotGlobalSelfTime(graph) ? hotOption.getValue(graph.getOptions()) : coldOption.getValue(graph.getOptions());
    }

    public static <X> X chooseAdaptiveBudgetFactor(StructuredGraph graph, X coldValue, OptionKey<X> hotOption) {
        return OptimizationUtility.hotGlobalSelfTime(graph) ? hotOption.getValue(graph.getOptions()) : coldValue;
    }

    public static <X> X chooseAdaptiveBudgetFactor(StructuredGraph graph, X coldValue, X hotValue) {
        return OptimizationUtility.hotGlobalSelfTime(graph) ? hotValue : coldValue;
    }

    public static boolean hotGlobalSelfTime(StructuredGraph graph) {
        return graph.globalProfileProvider().getGlobalSelfTimePercent() > Options.HotCodeMinSelfTime.getValue(graph.getOptions());
    }

    public static class Options {
        public static final OptionKey<Double> HotCodeMinSelfTime = new OptionKey<Double>(0.001);
    }
}

