/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.util;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.FloatingIntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.OpaqueValueNode;
import jdk.graal.compiler.nodes.loop.BasicInductionVariable;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;

public class LoopUtility {
    public static long tripCountSignedExact(CountedLoopInfo loop) {
        ValueNode maxTripCountNode = loop.maxTripCountNode();
        long maxTripCountAsSigned = maxTripCountNode.asJavaConstant().asLong();
        if (maxTripCountAsSigned < 0L) {
            throw new ArithmeticException("Unsigned value " + maxTripCountAsSigned + " overflows signed range");
        }
        return maxTripCountAsSigned;
    }

    public static long addExact(int bits, long a, long b) {
        if (bits == 8) {
            byte ba = NumUtil.safeToByteAE(a);
            byte bb = NumUtil.safeToByteAE(b);
            return LoopUtility.addExact(ba, bb);
        }
        if (bits == 16) {
            short sa = NumUtil.safeToShortAE(a);
            short sb = NumUtil.safeToShortAE(b);
            return LoopUtility.addExact(sa, sb);
        }
        if (bits == 32) {
            int ia = NumUtil.safeToIntAE(a);
            int ib = NumUtil.safeToIntAE(b);
            return Math.addExact(ia, ib);
        }
        if (bits == 64) {
            return Math.addExact(a, b);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes but is " + bits);
    }

    public static long subtractExact(int bits, long a, long b) {
        if (bits == 8) {
            byte ba = NumUtil.safeToByteAE(a);
            byte bb = NumUtil.safeToByteAE(b);
            return LoopUtility.subExact(ba, bb);
        }
        if (bits == 16) {
            short sa = NumUtil.safeToShortAE(a);
            short sb = NumUtil.safeToShortAE(b);
            return LoopUtility.subExact(sa, sb);
        }
        if (bits == 32) {
            int ia = NumUtil.safeToIntAE(a);
            int ib = NumUtil.safeToIntAE(b);
            return Math.subtractExact(ia, ib);
        }
        if (bits == 64) {
            return Math.subtractExact(a, b);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes but is " + bits);
    }

    public static long multiplyExact(int bits, long a, long b) {
        if (bits == 8) {
            byte ba = NumUtil.safeToByteAE(a);
            byte bb = NumUtil.safeToByteAE(b);
            return LoopUtility.mulExact(ba, bb);
        }
        if (bits == 16) {
            short sa = NumUtil.safeToShortAE(a);
            short sb = NumUtil.safeToShortAE(b);
            return LoopUtility.mulExact(sa, sb);
        }
        if (bits == 32) {
            int ia = NumUtil.safeToIntAE(a);
            int ib = NumUtil.safeToIntAE(b);
            return Math.multiplyExact(ia, ib);
        }
        if (bits == 64) {
            return Math.multiplyExact(a, b);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes but is " + bits);
    }

    private static byte addExact(byte x, byte y) {
        int iR = x + y;
        byte bR = (byte)iR;
        if (iR != bR) {
            throw new ArithmeticException("byte overflow");
        }
        return bR;
    }

    private static byte subExact(byte x, byte y) {
        int iR = x - y;
        byte bR = (byte)iR;
        if (iR != bR) {
            throw new ArithmeticException("byte overflow");
        }
        return bR;
    }

    private static byte mulExact(byte x, byte y) {
        int iR = x * y;
        byte bR = (byte)iR;
        if (iR != bR) {
            throw new ArithmeticException("byte overflow");
        }
        return bR;
    }

    private static short addExact(short x, short y) {
        int iR = x + y;
        short bR = (short)iR;
        if (iR != bR) {
            throw new ArithmeticException("short overflow");
        }
        return bR;
    }

    private static short subExact(short x, short y) {
        int iR = x - y;
        short bR = (short)iR;
        if (iR != bR) {
            throw new ArithmeticException("short overflow");
        }
        return bR;
    }

    private static short mulExact(short x, short y) {
        int iR = x * y;
        short bR = (short)iR;
        if (iR != bR) {
            throw new ArithmeticException("short overflow");
        }
        return bR;
    }

    public static boolean canUseWithoutProxy(ControlFlowGraph cfg, Node def, Node use) {
        StructuredGraph g;
        Graph graph = def.graph();
        if (graph instanceof StructuredGraph && (g = (StructuredGraph)graph).isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            return true;
        }
        if (!LoopUtility.isFixedNode(def) || !LoopUtility.isFixedNode(use)) {
            return false;
        }
        HIRBlock useBlock = cfg.blockFor(use);
        HIRBlock defBlock = cfg.blockFor(def);
        CFGLoop<HIRBlock> defLoop = defBlock.getLoop();
        CFGLoop<HIRBlock> useLoop = useBlock.getLoop();
        if (defLoop != null) {
            if (useLoop != null) {
                return useLoop.isAncestorOrSelf(defLoop);
            }
            return false;
        }
        return true;
    }

    private static boolean isFixedNode(Node n) {
        return n instanceof FixedNode;
    }

    public static boolean isNumericInteger(ValueNode v) {
        Stamp s = v.stamp(NodeView.DEFAULT);
        return s instanceof IntegerStamp;
    }

    public static boolean isLong(ValueNode v) {
        Stamp s = v.stamp(NodeView.DEFAULT);
        return s instanceof IntegerStamp && IntegerStamp.getBits(s) == 64;
    }

    public static boolean isInt(ValueNode v) {
        Stamp s = v.stamp(NodeView.DEFAULT);
        return s instanceof IntegerStamp && IntegerStamp.getBits(s) == 32;
    }

    public static void removeObsoleteProxies(StructuredGraph graph, CoreProviders context, CanonicalizerPhase canonicalizer) {
        LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
        EconomicSetNodeEventListener inputChanges = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.INPUT_CHANGED));
        try (Graph.NodeEventScope s = graph.trackNodeEvents(inputChanges);){
            for (Loop loop : loopsData.loops()) {
                LoopUtility.removeObsoleteProxiesForLoop(loop);
            }
        }
        canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)inputChanges.getNodes());
    }

    public static void removeObsoleteProxiesForLoop(Loop loop) {
        for (LoopExitNode lex : loop.loopBegin().loopExits()) {
            for (ProxyNode proxy : lex.proxies().snapshot()) {
                if (!loop.isOutsideLoop(proxy.value())) continue;
                proxy.replaceAtUsagesAndDelete(proxy.getOriginalNode());
            }
        }
    }

    public static void stepLoopIVs(StructuredGraph graph, Loop loop, ValueNode iterations) {
        for (InductionVariable iv : loop.getInductionVariables().getValues()) {
            if (!(iv instanceof BasicInductionVariable)) continue;
            ValuePhiNode phi = ((BasicInductionVariable)iv).valueNode();
            ValueNode convertedIterations = IntegerConvertNode.convert(iterations, iv.strideNode().stamp(NodeView.DEFAULT), NodeView.DEFAULT);
            ValueNode steppedInit = AddNode.create(phi.valueAt(0), MulNode.create(convertedIterations, iv.strideNode(), NodeView.DEFAULT), NodeView.DEFAULT);
            phi.setValueAt(0, graph.addOrUniqueWithInputs(steppedInit));
        }
    }

    public static void preserveCounterStampsForDivAfterUnroll(Loop loop) {
        for (Node n : loop.inside().nodes()) {
            boolean yInsideLoop;
            if (!(n instanceof FloatingIntegerDivRemNode)) continue;
            FloatingIntegerDivRemNode idiv = (FloatingIntegerDivRemNode)n;
            StructuredGraph graph = idiv.graph();
            ValueNode divisor = idiv.getY();
            IntegerStamp divisorStamp = (IntegerStamp)divisor.stamp(NodeView.DEFAULT);
            ValueNode dividend = idiv.getX();
            IntegerStamp dividendStamp = (IntegerStamp)dividend.stamp(NodeView.DEFAULT);
            GraalError.guarantee(!divisorStamp.contains(0L), "Divisor stamp must not contain 0 for floating divs - that could trap %s", (Object)idiv);
            boolean xInsideLoop = !loop.isOutsideLoop(dividend);
            boolean bl = yInsideLoop = !loop.isOutsideLoop(divisor);
            if (yInsideLoop) {
                idiv.setY(LoopUtility.piAnchorBeforeLoop(graph, divisor, divisorStamp, loop));
            }
            if (!xInsideLoop) continue;
            idiv.setX(LoopUtility.piAnchorBeforeLoop(graph, dividend, dividendStamp, loop));
        }
        loop.invalidateFragmentsAndIVs();
        loop.loopBegin().getDebug().dump(5, loop.loopBegin().graph(), "After preserving idiv stamps");
    }

    private static PiNode piAnchorBeforeLoop(StructuredGraph graph, ValueNode v, Stamp s, Loop loop) {
        ValueNode opaqueDivisor = graph.addWithoutUnique(new OpaqueValueNode(v));
        return graph.addWithoutUnique(new PiNode(opaqueDivisor, s, AbstractBeginNode.prevBegin(loop.loopBegin().forwardEnd())));
    }
}

