/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.walker;

import java.util.ArrayList;
import java.util.function.ToDoubleFunction;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeWorkList;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class ComputeInliningRelevance {
    private static final double EPSILON = 4.656612875245797E-10;
    private static final double UNINITIALIZED = -1.0;
    private static final int EXPECTED_MIN_INVOKE_COUNT = 3;
    private static final int EXPECTED_INVOKE_RATIO = 20;
    private static final int EXPECTED_LOOP_COUNT = 3;
    private final StructuredGraph graph;
    private final ToDoubleFunction<FixedNode> nodeProbabilities;
    private EconomicMap<FixedNode, Double> nodeRelevances;
    private Scope rootScope;

    public ComputeInliningRelevance(StructuredGraph graph, ToDoubleFunction<FixedNode> nodeProbabilities) {
        this.graph = graph;
        this.nodeProbabilities = nodeProbabilities;
    }

    public void compute() {
        this.rootScope = null;
        if (!this.graph.hasLoops()) {
            this.rootScope = new Scope(this.graph.start(), null);
        } else {
            if (this.nodeRelevances == null) {
                this.nodeRelevances = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)(3 + InliningUtil.getNodeCount(this.graph) / 20));
            }
            NodeWorkList workList = this.graph.createNodeWorkList();
            EconomicMap loops = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)3);
            Scope topScope = new Scope(this.graph.start(), null);
            for (LoopBeginNode loopBegin : this.graph.getNodes(LoopBeginNode.TYPE)) {
                this.createLoopScope(loopBegin, (EconomicMap<LoopBeginNode, Scope>)loops, topScope);
            }
            topScope.process(workList);
            for (Scope scope : loops.getValues()) {
                scope.process(workList);
            }
        }
    }

    public double getRelevance(Invoke invoke) {
        if (this.rootScope != null) {
            return this.rootScope.computeInvokeRelevance(invoke);
        }
        assert (this.nodeRelevances != null) : "uninitialized relevance";
        return (Double)this.nodeRelevances.get((Object)invoke.asFixedNode());
    }

    private Scope createLoopScope(LoopBeginNode loopBegin, EconomicMap<LoopBeginNode, Scope> loops, Scope topScope) {
        Scope scope = (Scope)loops.get((Object)loopBegin);
        if (scope == null) {
            Scope parent;
            FixedNode current = loopBegin.forwardEnd();
            while (true) {
                CompilationAlarm.checkProgress(this.graph);
                if (current.predecessor() == null) {
                    if (current instanceof LoopBeginNode) {
                        parent = this.createLoopScope((LoopBeginNode)current, loops, topScope);
                        break;
                    }
                    if (current instanceof StartNode) {
                        parent = topScope;
                        break;
                    }
                    assert (current instanceof MergeNode) : current;
                    current = ((AbstractMergeNode)current).forwardEndAt(0);
                    continue;
                }
                if (current instanceof LoopExitNode) {
                    parent = this.createLoopScope((LoopBeginNode)((LoopExitNode)current).loopBegin(), loops, (Scope)topScope).parent;
                    break;
                }
                current = (FixedNode)current.predecessor();
            }
            scope = new Scope(loopBegin, parent);
            loops.put((Object)loopBegin, (Object)scope);
        }
        return scope;
    }

    private double computeFastPathMinProbability(FixedNode scopeStart) {
        ArrayList<FixedNode> pathBeginNodes = new ArrayList<FixedNode>();
        pathBeginNodes.add(scopeStart);
        double minPathProbability = this.nodeProbabilities.applyAsDouble(scopeStart);
        boolean isLoopScope = scopeStart instanceof LoopBeginNode;
        do {
            Node current = (Node)pathBeginNodes.remove(pathBeginNodes.size() - 1);
            do {
                if (isLoopScope && current instanceof LoopExitNode && ((LoopBeginNode)scopeStart).loopExits().contains((LoopExitNode)current)) {
                    return minPathProbability;
                }
                if (current instanceof LoopBeginNode && current != scopeStart) {
                    current = this.getMaxProbabilityLoopExit((LoopBeginNode)current, pathBeginNodes);
                    minPathProbability = this.getMinPathProbability((FixedNode)current, minPathProbability);
                    continue;
                }
                if (current instanceof ControlSplitNode) {
                    current = ComputeInliningRelevance.getMaxProbabilitySux((ControlSplitNode)current, pathBeginNodes);
                    minPathProbability = this.getMinPathProbability((FixedNode)current, minPathProbability);
                    continue;
                }
                assert (current.successors().count() <= 1) : Assertions.errorMessage(current);
                current = current.successors().first();
            } while (current != null);
        } while (!pathBeginNodes.isEmpty());
        return minPathProbability;
    }

    private double getMinPathProbability(FixedNode current, double minPathProbability) {
        return current == null ? minPathProbability : Math.min(minPathProbability, this.nodeProbabilities.applyAsDouble(current));
    }

    private static Node getMaxProbabilitySux(ControlSplitNode controlSplit, ArrayList<FixedNode> pathBeginNodes) {
        Node maxSux = null;
        double maxProbability = 0.0;
        int pathBeginCount = pathBeginNodes.size();
        for (Node sux : controlSplit.successors()) {
            double probability = controlSplit.probability((AbstractBeginNode)sux);
            if (probability > maxProbability) {
                maxProbability = probability;
                maxSux = sux;
                ComputeInliningRelevance.truncate(pathBeginNodes, pathBeginCount);
                continue;
            }
            if (probability != maxProbability) continue;
            pathBeginNodes.add((FixedNode)sux);
        }
        return maxSux;
    }

    private Node getMaxProbabilityLoopExit(LoopBeginNode loopBegin, ArrayList<FixedNode> pathBeginNodes) {
        LoopExitNode maxSux = null;
        double maxProbability = 0.0;
        int pathBeginCount = pathBeginNodes.size();
        for (LoopExitNode sux : loopBegin.loopExits()) {
            double probability = this.nodeProbabilities.applyAsDouble(sux);
            if (probability > maxProbability) {
                maxProbability = probability;
                maxSux = sux;
                ComputeInliningRelevance.truncate(pathBeginNodes, pathBeginCount);
                continue;
            }
            if (probability != maxProbability) continue;
            pathBeginNodes.add(sux);
        }
        return maxSux;
    }

    private static void truncate(ArrayList<FixedNode> pathBeginNodes, int pathBeginCount) {
        for (int i = pathBeginNodes.size() - pathBeginCount; i > 0; --i) {
            pathBeginNodes.remove(pathBeginNodes.size() - 1);
        }
    }

    private class Scope {
        public final FixedNode start;
        public final Scope parent;
        private double fastPathMinProbability = -1.0;
        private double scopeRelevanceWithinParent = -1.0;

        Scope(FixedNode start, Scope parent) {
            this.start = start;
            this.parent = parent;
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="comparing against -1D is accurate")
        public double getFastPathMinProbability() {
            if (this.fastPathMinProbability == -1.0) {
                this.fastPathMinProbability = Math.max(4.656612875245797E-10, ComputeInliningRelevance.this.computeFastPathMinProbability(this.start));
            }
            return this.fastPathMinProbability;
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="comparing against -1D is accurate")
        public double getScopeRelevanceWithinParent() {
            if (this.scopeRelevanceWithinParent == -1.0) {
                if (this.start instanceof LoopBeginNode) {
                    assert (this.parent != null);
                    double scopeEntryProbability = ComputeInliningRelevance.this.nodeProbabilities.applyAsDouble(((LoopBeginNode)this.start).forwardEnd());
                    this.scopeRelevanceWithinParent = scopeEntryProbability / this.parent.getFastPathMinProbability();
                } else {
                    this.scopeRelevanceWithinParent = 1.0;
                }
            }
            return this.scopeRelevanceWithinParent;
        }

        public void process(NodeWorkList workList) {
            assert (!(this.start instanceof Invoke)) : this.start;
            workList.addAll(this.start.successors());
            for (Node current : workList) {
                assert (current.isAlive()) : current;
                if (current instanceof Invoke) {
                    ComputeInliningRelevance.this.nodeRelevances.put((Object)((FixedNode)current), (Object)this.computeInvokeRelevance((Invoke)((Object)current)));
                    workList.addAll(current.successors());
                    continue;
                }
                if (current instanceof LoopBeginNode) {
                    ((LoopBeginNode)current).loopExits().forEach(exit -> workList.add(exit.next()));
                    continue;
                }
                if (current instanceof LoopEndNode || current instanceof LoopExitNode) continue;
                if (current instanceof FixedWithNextNode) {
                    workList.add(((FixedWithNextNode)current).next());
                    continue;
                }
                if (current instanceof EndNode) {
                    workList.add(((EndNode)current).merge());
                    continue;
                }
                if (current instanceof ControlSinkNode) continue;
                if (current instanceof ControlSplitNode) {
                    workList.addAll(current.successors());
                    continue;
                }
                assert (false) : current;
            }
        }

        public double computeInvokeRelevance(Invoke invoke) {
            double invokeProbability = ComputeInliningRelevance.this.nodeProbabilities.applyAsDouble(invoke.asFixedNode());
            assert (!Double.isNaN(invokeProbability));
            double relevance = invokeProbability / this.getFastPathMinProbability() * Math.min(1.0, this.getScopeRelevanceWithinParent());
            assert (!Double.isNaN(relevance)) : String.valueOf(invoke) + ": " + relevance + " / " + invokeProbability + " / " + this.getFastPathMinProbability() + " / " + this.getScopeRelevanceWithinParent();
            return relevance;
        }
    }
}

