/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.info.elem;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.common.DominatorBasedGlobalValueNumberingPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.common.inlining.info.elem.Inlineable;
import jdk.graal.compiler.phases.graph.FixedNodeRelativeFrequencyCache;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class InlineableGraph
implements Inlineable {
    private final StructuredGraph graph;
    private FixedNodeRelativeFrequencyCache probabilites = new FixedNodeRelativeFrequencyCache();

    public InlineableGraph(ResolvedJavaMethod method, Invoke invoke, HighTierContext context, CanonicalizerPhase canonicalizer, boolean trackNodeSourcePosition) {
        StructuredGraph original = context.getReplacements().getInlineSubstitution(method, invoke.bci(), invoke.isInOOMETry(), invoke.getInlineControl(), trackNodeSourcePosition, null, invoke.asNode().graph().allowAssumptions(), invoke.asNode().getOptions());
        if (original == null) {
            original = InlineableGraph.parseBytecodes(method, invoke, context, canonicalizer, invoke.asNode().graph(), trackNodeSourcePosition);
        } else if (original.isFrozen()) {
            original = (StructuredGraph)original.copy(invoke.asNode().getDebug());
        }
        this.graph = original;
        this.specializeGraphToArguments(invoke, context, canonicalizer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean specializeGraphToArguments(Invoke invoke, HighTierContext context, CanonicalizerPhase canonicalizer) {
        DebugContext debug = this.graph.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"InlineGraph", this.graph);){
            ArrayList<Node> parameterUsages = this.replaceParamsWithMoreInformativeArguments(invoke, context);
            if (parameterUsages != null) {
                assert (!parameterUsages.isEmpty()) : "The caller didn't have more information about arguments after all";
                canonicalizer.applyIncremental(this.graph, (CoreProviders)context, parameterUsages);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private static boolean isArgMoreInformativeThanParam(ValueNode arg, ParameterNode param) {
        return arg.isConstant() || InlineableGraph.canStampBeImproved(arg, param);
    }

    private static boolean canStampBeImproved(ValueNode arg, ParameterNode param) {
        return InlineableGraph.improvedStamp(arg, param) != null;
    }

    private static Stamp improvedStamp(ValueNode arg, ParameterNode param) {
        Stamp joinedStamp = param.stamp(NodeView.DEFAULT).join(arg.stamp(NodeView.DEFAULT));
        if (joinedStamp == null || joinedStamp.equals(param.stamp(NodeView.DEFAULT))) {
            return null;
        }
        return joinedStamp;
    }

    private ArrayList<Node> replaceParamsWithMoreInformativeArguments(Invoke invoke, HighTierContext context) {
        NodeInputList<ValueNode> args = invoke.callTarget().arguments();
        ArrayList<Node> parameterUsages = null;
        List<ParameterNode> params = this.graph.getNodes(ParameterNode.TYPE).snapshot();
        assert (params.size() <= args.size()) : Assertions.errorMessageContext("params", params, "args", args);
        for (ParameterNode param : params) {
            if (!param.usages().isNotEmpty()) continue;
            ValueNode arg = (ValueNode)args.get(param.index());
            if (arg.isConstant()) {
                ConstantNode constant = (ConstantNode)arg;
                parameterUsages = InlineableGraph.trackParameterUsages(param, parameterUsages);
                param.replaceAtUsagesAndDelete(this.graph.unique(ConstantNode.forConstant(arg.stamp(NodeView.DEFAULT), constant.getValue(), constant.getStableDimension(), constant.isDefaultStable(), context.getMetaAccess())));
                continue;
            }
            Stamp impro = InlineableGraph.improvedStamp(arg, param);
            if (impro != null) {
                param.setStamp(impro);
                parameterUsages = InlineableGraph.trackParameterUsages(param, parameterUsages);
                continue;
            }
            assert (!InlineableGraph.isArgMoreInformativeThanParam(arg, param));
        }
        assert (parameterUsages == null || !parameterUsages.isEmpty());
        return parameterUsages;
    }

    private static ArrayList<Node> trackParameterUsages(ParameterNode param, ArrayList<Node> parameterUsages) {
        ArrayList<Node> result = parameterUsages == null ? new ArrayList<Node>() : parameterUsages;
        param.usages().snapshotTo(result);
        return result;
    }

    private static StructuredGraph parseBytecodes(ResolvedJavaMethod method, Invoke invoke, HighTierContext context, CanonicalizerPhase canonicalizer, StructuredGraph caller, boolean trackNodeSourcePosition) {
        DebugContext debug = caller.getDebug();
        StructuredGraph newGraph = new StructuredGraph.Builder(caller.getOptions(), debug, caller.allowAssumptions()).method(method).trackNodeSourcePosition(trackNodeSourcePosition).profileProvider(caller.getProfileProvider()).speculationLog(caller.getSpeculationLog()).build();
        DebugContext.Scope s = debug.scope((Object)"InlineGraph", newGraph);
        try {
            PhaseSuite<HighTierContext> graphBuilder;
            if (!caller.isUnsafeAccessTrackingEnabled()) {
                newGraph.disableUnsafeAccessTracking();
            }
            if ((graphBuilder = context.getGraphBuilderSuiteForCallee(invoke)) != null) {
                graphBuilder.apply(newGraph, context);
            }
            assert (newGraph.start().next() != null) : "graph needs to be populated by the GraphBuilderSuite " + String.valueOf(method) + ", " + method.canBeInlined();
            new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(newGraph);
            canonicalizer.apply(newGraph, context);
            if (GraalOptions.EarlyGVN.getValue(newGraph.getOptions()).booleanValue()) {
                new DominatorBasedGlobalValueNumberingPhase(canonicalizer).apply(newGraph, context);
            }
            StructuredGraph structuredGraph = newGraph;
            if (s != null) {
                s.close();
            }
            return structuredGraph;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    @Override
    public int getNodeCount() {
        return InliningUtil.getNodeCount(this.graph);
    }

    @Override
    public Iterable<Invoke> getInvokes() {
        return this.graph.getInvokes();
    }

    @Override
    public double getProbability(Invoke invoke) {
        return this.probabilites.applyAsDouble(invoke.asFixedNode());
    }

    public StructuredGraph getGraph() {
        return this.graph;
    }
}

