/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining;

import java.util.LinkedList;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.common.AbstractInliningPhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.inlining.policy.InliningPolicy;
import jdk.graal.compiler.phases.common.inlining.walker.InliningData;
import jdk.graal.compiler.phases.tiers.HighTierContext;

public class InliningPhase
extends AbstractInliningPhase {
    private final InliningPolicy inliningPolicy;
    private final CanonicalizerPhase canonicalizer;
    private final LinkedList<Invoke> rootInvokes;
    private final int maxMethodPerInlining = Integer.MAX_VALUE;

    public InliningPhase(InliningPolicy policy, CanonicalizerPhase canonicalizer) {
        this(policy, canonicalizer, null);
    }

    public InliningPhase(InliningPolicy policy, CanonicalizerPhase canonicalizer, LinkedList<Invoke> rootInvokes) {
        this.inliningPolicy = policy;
        this.canonicalizer = canonicalizer;
        this.rootInvokes = rootInvokes;
    }

    public CanonicalizerPhase getCanonicalizer() {
        return this.canonicalizer;
    }

    @Override
    public float codeSizeIncrease() {
        return 10000.0f;
    }

    @Override
    protected void runInlining(StructuredGraph graph, HighTierContext context) {
        InliningData data = new InliningData(graph, context, Integer.MAX_VALUE, this.canonicalizer, this.inliningPolicy, this.rootInvokes);
        int count = 0;
        assert (data.repOK());
        int limit = Options.MethodInlineBailoutLimit.getValue(graph.getOptions());
        while (data.hasUnprocessedGraphs()) {
            boolean wasInlined = data.moveForward();
            assert (data.repOK());
            if (wasInlined || limit <= 0 || ++count != limit) continue;
            break;
        }
        assert (data.inliningDepth() == 0 || count == limit) : data.inliningDepth() + " " + count + " " + limit;
        assert (data.graphCount() == 0 || count == limit) : data.graphCount() + " " + count + " " + limit;
    }

    public static class Options {
        public static final OptionKey<Boolean> AlwaysInlineIntrinsics = new OptionKey<Boolean>(false);
        public static final OptionKey<Integer> MethodInlineBailoutLimit = new OptionKey<Integer>(1000);
    }
}

