/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;

public class WriteBarrierAdditionPhase
extends BasePhase<CoreProviders> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.BARRIER_ADDITION, graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.MID_TIER_LOWERING, graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.FSA, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        BarrierSet barrierSet = context.getPlatformConfigurationProvider().getBarrierSet();
        if (barrierSet.hasWriteBarrier()) {
            for (FixedAccessNode n : graph.getNodes(FixedAccessNode.TYPE)) {
                try (DebugCloseable scope = n.graph().withNodeSourcePosition(n);){
                    barrierSet.addBarriers(n);
                }
            }
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.BARRIER_ADDITION);
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

