/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractDeoptimizeNode;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.DeoptimizingFixedWithNextNode;
import jdk.graal.compiler.nodes.DynamicDeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.NullCheckNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.UseTrappingOperationPhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;

public class UseTrappingNullChecksPhase
extends UseTrappingOperationPhase {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.ADDRESS_LOWERING, graphState), BasePhase.NotApplicable.when(!graphState.getGuardsStage().areFrameStatesAtDeopts(), "This should happen after FSA"));
    }

    @Override
    protected void run(StructuredGraph graph, LowTierContext context) {
        assert (context.getTarget().implicitNullCheckLimit > 0) : "The implicitNullCheckLimit should be greater than 0.";
        if (!Options.UseTrappingNullChecks.getValue(graph.getOptions()).booleanValue()) {
            return;
        }
        MetaAccessProvider metaAccessProvider = context.getMetaAccess();
        for (DeoptimizeNode deoptimizeNode : graph.getNodes(DeoptimizeNode.TYPE)) {
            this.tryUseTrappingVersion(deoptimizeNode, deoptimizeNode.predecessor(), deoptimizeNode.getSpeculation(), deoptimizeNode.getActionAndReason(metaAccessProvider).asJavaConstant(), deoptimizeNode.getSpeculation(metaAccessProvider).asJavaConstant(), context);
        }
        for (DynamicDeoptimizeNode dynamicDeoptimizeNode : graph.getNodes(DynamicDeoptimizeNode.TYPE)) {
            this.tryUseTrappingVersion(metaAccessProvider, dynamicDeoptimizeNode, context);
        }
    }

    @Override
    public boolean canReplaceCondition(LogicNode condition, IfNode ifNode) {
        return condition instanceof IsNullNode;
    }

    @Override
    public boolean useAddressOptimization(AddressNode adr, LowTierContext context) {
        return adr.getMaxConstantDisplacement() < (long)context.getTarget().implicitNullCheckLimit;
    }

    @Override
    public boolean isSupportedReason(DeoptimizationReason reason) {
        return reason == DeoptimizationReason.NullCheckException || reason != DeoptimizationReason.UnreachedCode || reason == DeoptimizationReason.TypeCheckedInliningViolated;
    }

    @Override
    public DeoptimizingFixedWithNextNode tryReplaceExisting(StructuredGraph graph, AbstractBeginNode nonTrappingContinuation, AbstractBeginNode trappingContinuation, LogicNode condition, IfNode ifNode, AbstractDeoptimizeNode deopt, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation, LowTierContext context) {
        IsNullNode isNullNode = (IsNullNode)condition;
        FixedNode nextNonTrapping = nonTrappingContinuation.next();
        ValueNode value = isNullNode.getValue();
        if (GraalOptions.OptImplicitNullChecks.getValue(graph.getOptions()).booleanValue() && nextNonTrapping instanceof FixedAccessNode) {
            FixedAccessNode fixedAccessNode = (FixedAccessNode)nextNonTrapping;
            AddressNode address = fixedAccessNode.getAddress();
            if (fixedAccessNode.canNullCheck() && this.useAddressOptimization(address, context)) {
                ValueNode base = address.getBase();
                ValueNode index = address.getIndex();
                if (base != null && base instanceof CompressionNode) {
                    base = ((CompressionNode)base).getValue();
                }
                if (index != null && index instanceof CompressionNode) {
                    index = ((CompressionNode)index).getValue();
                }
                if (base == value && index == null || base == null && index == value) {
                    fixedAccessNode.setStateBefore(deopt.stateBefore());
                    fixedAccessNode.setUsedAsNullCheck(true);
                    fixedAccessNode.setImplicitDeoptimization(deoptReasonAndAction, deoptSpeculation);
                    graph.removeSplit(ifNode, nonTrappingContinuation);
                    graph.getOptimizationLog().report(UseTrappingNullChecksPhase.class, "ImplicitNullCheck", isNullNode);
                    return fixedAccessNode;
                }
            }
        }
        return null;
    }

    @Override
    public DeoptimizingFixedWithNextNode createImplicitNode(StructuredGraph graph, LogicNode condition, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        IsNullNode isNullNode = (IsNullNode)condition;
        return graph.add(NullCheckNode.create(isNullNode.getValue(), deoptReasonAndAction, deoptSpeculation));
    }

    @Override
    public boolean trueSuccessorIsDeopt() {
        return true;
    }

    @Override
    public void finalAction(DeoptimizingFixedWithNextNode trappingVersionNode, LogicNode condition) {
    }

    @Override
    public void actionBeforeGuardRewrite(DeoptimizingFixedWithNextNode trappingVersionNode) {
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }

    public static class Options {
        public static final OptionKey<Boolean> UseTrappingNullChecks = new OptionKey<Boolean>(true);
    }
}

