/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.tiers.TargetProvider;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.nodes.LateLoweredNode;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.collections.EconomicMap;

public class TransplantGraphsPhase
extends BasePhase<LowTierContext> {
    private final Suites suitesForLateCallee;
    static final boolean LOG_TTY = Boolean.parseBoolean(GraalServices.getSavedProperty("debug.graal.TransplantLowTierSnippets"));

    public TransplantGraphsPhase(Suites suitesForLateSnippets) {
        this.suitesForLateCallee = suitesForLateSnippets;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.FINAL_SCHEDULE, graphState));
    }

    private static void verifyCalleeIntegrity(StructuredGraph graph) {
        GraalError.guarantee(graph.getNodes(ReturnNode.TYPE).count() == 1, "Need one return");
        GraalError.guarantee(graph.getNodes(UnwindNode.TYPE).count() == 0, "No unwinds allowed");
    }

    private static LateInliningData lateInline(final LateLoweredNode lateLoweredNode, StructuredGraph callee) {
        StructuredGraph callerGraph = lateLoweredNode.graph();
        NodeSourcePosition callerNSP = lateLoweredNode.getNodeSourcePosition();
        BeginNode b = callerGraph.add(new BeginNode());
        FixedWithNextNode oldPred = (FixedWithNextNode)lateLoweredNode.predecessor();
        oldPred.setNext(null);
        b.setNext(lateLoweredNode);
        oldPred.setNext(b);
        FixedNode oldNext = lateLoweredNode.next();
        final BeginNode prevBegin = b;
        final StartNode entryPointNode = callee.start();
        Graph.DuplicationReplacement localReplacement = new Graph.DuplicationReplacement(){

            @Override
            public Node replacement(Node node) {
                if (node instanceof ParameterNode) {
                    ParameterNode parameterNode = (ParameterNode)node;
                    ValueNode argument = (ValueNode)lateLoweredNode.getArguments().get(parameterNode.index());
                    return argument;
                }
                if (node == entryPointNode) {
                    return prevBegin;
                }
                return node;
            }
        };
        callerGraph.recordMethod(callee.method());
        callerGraph.getDebug().dump(5, (Object)callerGraph, "Before inlining at LateLoweredNode %s", lateLoweredNode);
        boolean gvn = false;
        Graph.Mark before = callerGraph.getMark();
        EconomicMap<Node, Node> duplicates = callerGraph.addDuplicates(callee.getNodes(), callee, callee.getNodeCount(), localReplacement, false);
        callerGraph.getDebug().dump(5, (Object)callerGraph, "After inlining at LateLoweredNode %s", lateLoweredNode);
        for (Node n : callerGraph.getNewNodes(before)) {
            if (n.isAlive() && n.getNodeSourcePosition() != null) {
                n.setNodeSourcePosition(n.getNodeSourcePosition().addCaller(callerNSP));
            }
            if (!n.isAlive() || !(n instanceof FrameState)) continue;
            FrameState fs = (FrameState)n;
            if (fs.outerFrameState() == null) {
                fs.setOuterFrameState(lateLoweredNode.stateDuring());
            }
            if (fs.bci == -2) {
                fs.replaceAtUsages(lateLoweredNode.stateBefore());
                continue;
            }
            if (fs.bci != -3) continue;
            fs.replaceAtUsages(lateLoweredNode.stateAfter());
        }
        lateLoweredNode.setNext(null);
        ReturnNode calleeReturn = callee.getNodes(ReturnNode.TYPE).first();
        ReturnNode copyInCaller = (ReturnNode)duplicates.get((Object)calleeReturn);
        assert (copyInCaller != null);
        lateLoweredNode.replaceAtUsages(copyInCaller.result());
        FixedWithNextNode retNext = (FixedWithNextNode)copyInCaller.predecessor();
        retNext.setNext(null);
        copyInCaller.safeDelete();
        retNext.setNext(oldNext);
        callerGraph.getDebug().dump(5, (Object)callerGraph, "After fixing control flow at %s", lateLoweredNode);
        return new LateInliningData(duplicates, oldNext);
    }

    @Override
    protected void run(StructuredGraph graph, final LowTierContext context) {
        List<LateLoweredNode> lateLoweredNodes = graph.getNodes(LateLoweredNode.TYPE).snapshot();
        if (lateLoweredNodes.size() == 0) {
            return;
        }
        StructuredGraph.ScheduleResult finalScheduleBeforeTransplant = graph.getLastSchedule();
        ControlFlowGraph finalCFGBeforeTransplant = finalScheduleBeforeTransplant.getCFG();
        ControlFlowGraph patchedFinalCFG = finalCFGBeforeTransplant.deepCopyReversePostOrderOnly();
        BlockMap<List<Node>> patchedBlockToNodesMap = finalScheduleBeforeTransplant.getBlockToNodesMap();
        for (LateLoweredNode lateLoweredNode : lateLoweredNodes) {
            StructuredGraph calleeGraph = null;
            SnippetTemplate template = lateLoweredNode.getTemplateProducer().get();
            calleeGraph = (StructuredGraph)template.getSnippet().copy(graph.getDebug());
            this.suitesForLateCallee.getHighTier().apply(calleeGraph, new HighTierContext((Providers)context.getProviders(), null, OptimisticOptimizations.NONE));
            this.suitesForLateCallee.getMidTier().apply(calleeGraph, new MidTierContext((Providers)context.getProviders(), new TargetProvider(){

                @Override
                public TargetDescription getTarget() {
                    return context.getTarget();
                }
            }, OptimisticOptimizations.NONE, null));
            this.suitesForLateCallee.getLowTier().apply(calleeGraph, context);
            TransplantGraphsPhase.verifyCalleeIntegrity(calleeGraph);
            LateInliningData lateInlineData = TransplantGraphsPhase.lateInline(lateLoweredNode, calleeGraph);
            int oldBlockBeforeTransplantThatIsSplit = patchedFinalCFG.blockFor(lateLoweredNode).getId();
            EconomicMap<HIRBlock, ControlFlowGraph.BlockTransplantData> newToOldBlocks = patchedFinalCFG.transplantAndRenumber(lateLoweredNode, calleeGraph.getLastCFG(), lateInlineData.duplicates);
            GraphUtil.killCFG(lateLoweredNode);
            if (LOG_TTY) {
                patchedFinalCFG.printCFGToStdout();
            }
            BlockMap<List<Node>> newBlockToNodesMap = TransplantGraphsPhase.transplantScheduleResult(graph, patchedFinalCFG, patchedBlockToNodesMap, calleeGraph, lateInlineData, oldBlockBeforeTransplantThatIsSplit, newToOldBlocks);
            patchedBlockToNodesMap = newBlockToNodesMap;
        }
        TransplantGraphsPhase.recomputeDominators(patchedFinalCFG);
        graph.setLastCFG(patchedFinalCFG);
        NodeMap<HIRBlock> patchedNodeToBlock = new NodeMap<HIRBlock>(graph);
        for (HIRBlock b : patchedFinalCFG.reversePostOrder()) {
            for (Node n : patchedBlockToNodesMap.get(b)) {
                patchedNodeToBlock.put(n, b);
            }
        }
        StructuredGraph.ScheduleResult scheduleResult = new StructuredGraph.ScheduleResult(patchedFinalCFG, patchedNodeToBlock, patchedBlockToNodesMap, finalScheduleBeforeTransplant.strategy);
        graph.setLastSchedule(scheduleResult);
        if (LOG_TTY) {
            patchedFinalCFG.printCFGToStdout();
            TTY.printf("%s%n", graph.getLastSchedule().print());
        }
        assert (TransplantGraphsPhase.verifyTransplantedGraphAndSchedule(graph, context, scheduleResult));
    }

    private static boolean verifyTransplantedGraphAndSchedule(StructuredGraph graph, LowTierContext context, StructuredGraph.ScheduleResult patchedFinalSchedule) {
        NodeMap<Integer> seenOccurences = new NodeMap<Integer>(graph);
        for (Node n : graph.getNodes()) {
            if (n instanceof PhiNode) continue;
            int seen = seenOccurences.containsKey(n) ? (Integer)seenOccurences.get(n) : 0;
            seenOccurences.put(n, ++seen);
            HIRBlock b = graph.getLastSchedule().getNodeToBlockMap().get(n);
            assert (b != null) : Assertions.errorMessage("Must have a block for every node", n);
        }
        for (Node n : graph.getNodes()) {
            Integer seen = (Integer)seenOccurences.get(n);
            if (seen != null) assert (seen == 1) : Assertions.errorMessage("Must only see a node once, but found node more often", n, seen);
        }
        for (HIRBlock b : patchedFinalSchedule.getCFG().getBlocks()) {
            List<Node> nodes = patchedFinalSchedule.getBlockToNodesMap().get(b);
            for (Node n : nodes) {
                assert (n.isAlive());
                assert (patchedFinalSchedule.getNodeToBlockMap().get(n) == b) : Assertions.errorMessage("Node to block gives different block for node ", patchedFinalSchedule.getNodeToBlockMap().get(n), n, b);
                StructuredGraph g = (StructuredGraph)n.graph();
                if (g.hasLoops() && g.getGuardsStage().areFrameStatesAtDeopts() && n instanceof DeoptimizeNode) assert (b.getLoopDepth() == 0) : n;
            }
        }
        StructuredGraph copyToSchedule = graph.copy(graph.method(), graph.getOptions(), graph.getDebug(), false);
        new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS).apply(copyToSchedule, context);
        return true;
    }

    private static BlockMap<List<Node>> transplantScheduleResult(StructuredGraph graph, ControlFlowGraph patchedFinalCFG, BlockMap<List<Node>> patchedBlockToNodesMap, StructuredGraph calleeGraph, LateInliningData lateInlineData, int oldBlockBeforeTransplantThatIsSplit, EconomicMap<HIRBlock, ControlFlowGraph.BlockTransplantData> newToOldBlocks) {
        boolean successorBlock;
        if (LOG_TTY) {
            TTY.printf("Transplanting schedule result with old one %s%n", patchedBlockToNodesMap);
        }
        BlockMap<List<Node>> newBlockToNodesMap = new BlockMap<List<Node>>(patchedFinalCFG);
        for (HIRBlock b : patchedFinalCFG.reversePostOrder()) {
            ArrayList<Node> blockNodes = new ArrayList<Node>();
            ControlFlowGraph.BlockTransplantData data = (ControlFlowGraph.BlockTransplantData)newToOldBlocks.get((Object)b);
            assert (data != null);
            if (data.source() == ControlFlowGraph.BlockTransplantOrigin.CALLER) {
                for (Node n : patchedBlockToNodesMap.get(data.oldBlockIDBeforeTransplant())) {
                    if (!n.isAlive()) continue;
                    assert (n.graph() == graph) : Assertions.errorMessage("Node Graph must be graph", n, n.graph(), graph);
                    blockNodes.add(n);
                }
            } else if (data.source() == ControlFlowGraph.BlockTransplantOrigin.CALLEE) {
                HIRBlock oldBlock = data.oldBlock();
                assert (oldBlock.getCfg().graph == calleeGraph) : Assertions.errorMessage("Graphs must be the same", oldBlock.getCfg().graph, calleeGraph);
                for (Node calleeGraphNode : calleeGraph.getLastSchedule().getBlockToNodesMap().get(data.oldBlockIDBeforeTransplant())) {
                    Node callerGraphNode;
                    if (calleeGraphNode instanceof ParameterNode || !(callerGraphNode = (Node)lateInlineData.duplicates.get((Object)calleeGraphNode)).isAlive()) continue;
                    assert (callerGraphNode.graph() == graph) : Assertions.errorMessage("Node Graph must be graph", callerGraphNode, callerGraphNode.graph(), graph);
                    blockNodes.add(callerGraphNode);
                }
            } else {
                throw GraalError.shouldNotReachHere("Unkown block source");
            }
            newBlockToNodesMap.put(b, blockNodes);
        }
        HIRBlock currentBlock = patchedFinalCFG.blockFor(lateInlineData.nextAfterInline);
        List callerBlockList = (List)newBlockToNodesMap.get(currentBlock);
        List<Node> oldPatchList = patchedBlockToNodesMap.get(oldBlockBeforeTransplantThatIsSplit);
        boolean bl = successorBlock = currentBlock.getBeginNode() == lateInlineData.nextAfterInline;
        if (successorBlock) {
            callerBlockList = (List)newBlockToNodesMap.get(patchedFinalCFG.blockFor(lateInlineData.nextAfterInline.predecessor()));
        }
        for (Node n : oldPatchList) {
            if (!n.isAlive()) continue;
            assert (n.graph() == graph) : Assertions.errorMessage("Node Graph must be graph", n, n.graph(), graph);
            callerBlockList.add(n);
        }
        return newBlockToNodesMap;
    }

    private static void recomputeDominators(ControlFlowGraph patchedFinalCFG) {
        for (HIRBlock b : patchedFinalCFG.reversePostOrder()) {
            ((BasicBlock)b).resetDominators();
        }
        patchedFinalCFG.computeDominators();
        patchedFinalCFG.computePostdominators();
        patchedFinalCFG.computeLoopInformation();
        patchedFinalCFG.computeFrequencies();
    }

    private static class LateInliningData {
        private EconomicMap<Node, Node> duplicates;
        private FixedNode nextAfterInline;

        LateInliningData(EconomicMap<Node, Node> duplicates, FixedNode nextAfterInline) {
            this.duplicates = duplicates;
            this.nextAfterInline = nextAfterInline;
        }
    }
}

