/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class SnippetFrameStateAssignment {

    public static class SnippetFrameStateAssignmentClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<NodeStateAssignment> {
        private final NodeMap<NodeStateAssignment> stateMapping;
        private static final boolean RUN_WITH_LOG_ON_ERROR = false;
        private final boolean logOnInvalid;

        public NodeMap<NodeStateAssignment> getStateMapping() {
            return this.stateMapping;
        }

        public boolean verify() {
            MapCursor<Node, NodeStateAssignment> stateAssignments = this.stateMapping.getEntries();
            while (stateAssignments.advance()) {
                Node nodeWithState = (Node)stateAssignments.getKey();
                NodeStateAssignment fsRequirements = (NodeStateAssignment)((Object)stateAssignments.getValue());
                switch (fsRequirements.ordinal()) {
                    case 4: {
                        throw GraalError.shouldNotReachHere("Invalid snippet replacing a node before FS assignment with node " + String.valueOf(nodeWithState) + " for graph " + String.valueOf(nodeWithState.graph()) + " other assignments=" + String.valueOf(this.stateMapping));
                    }
                }
            }
            return true;
        }

        public SnippetFrameStateAssignmentClosure(StructuredGraph graph) {
            this(graph, false);
        }

        public SnippetFrameStateAssignmentClosure(StructuredGraph graph, boolean logOnInvalid) {
            this.stateMapping = new NodeMap(graph);
            this.logOnInvalid = logOnInvalid;
        }

        @Override
        protected NodeStateAssignment processNode(FixedNode node, NodeStateAssignment stateAssignment) {
            NodeStateAssignment nextStateAssignment = stateAssignment;
            if (node instanceof LoopExitNode) {
                this.stateMapping.put(node, stateAssignment);
            }
            if (node instanceof StateSplit && ((StateSplit)((Object)node)).hasSideEffect() && !(node instanceof StartNode) && !(node instanceof AbstractMergeNode)) {
                if (node instanceof ExceptionObjectNode) {
                    nextStateAssignment = NodeStateAssignment.AFTER_EXCEPTION_BCI;
                } else if (stateAssignment == NodeStateAssignment.BEFORE_BCI) {
                    nextStateAssignment = NodeStateAssignment.AFTER_BCI;
                } else if (stateAssignment == NodeStateAssignment.AFTER_BCI_INVALID_FOR_DEOPTIMIZATION) {
                    nextStateAssignment = NodeStateAssignment.AFTER_BCI_INVALID_FOR_DEOPTIMIZATION;
                } else {
                    if (this.logOnInvalid) {
                        node.getDebug().log(5, "Node %s creating invalid assignment", (Object)node);
                    }
                    nextStateAssignment = NodeStateAssignment.INVALID;
                }
                this.stateMapping.put(node, nextStateAssignment);
            }
            return nextStateAssignment;
        }

        @Override
        protected NodeStateAssignment merge(AbstractMergeNode merge, List<NodeStateAssignment> states) {
            NodeStateAssignment mergeAssignment = null;
            block6: for (int i = 0; i < states.size(); ++i) {
                NodeStateAssignment assignment = states.get(i);
                switch (assignment.ordinal()) {
                    case 0: {
                        if (mergeAssignment != null) continue block6;
                        mergeAssignment = NodeStateAssignment.BEFORE_BCI;
                        continue block6;
                    }
                    case 1: 
                    case 2: {
                        if (mergeAssignment == NodeStateAssignment.AFTER_BCI || mergeAssignment == NodeStateAssignment.AFTER_BCI_INVALID_FOR_DEOPTIMIZATION) {
                            GraalError.guarantee(mergeAssignment == assignment, "Cannot mix valid and invalid AFTER_BCI versions");
                        }
                        mergeAssignment = assignment;
                        continue block6;
                    }
                    case 3: {
                        if (mergeAssignment == null || mergeAssignment == NodeStateAssignment.AFTER_EXCEPTION_BCI) {
                            mergeAssignment = NodeStateAssignment.AFTER_EXCEPTION_BCI;
                            continue block6;
                        }
                        mergeAssignment = NodeStateAssignment.INVALID;
                        break block6;
                    }
                    case 4: {
                        mergeAssignment = NodeStateAssignment.INVALID;
                        break block6;
                    }
                    default: {
                        throw GraalError.shouldNotReachHere("Unhandled node state assignment: " + String.valueOf((Object)assignment) + " at merge " + String.valueOf(merge));
                    }
                }
            }
            assert (mergeAssignment != null);
            this.stateMapping.put(merge, mergeAssignment);
            return mergeAssignment;
        }

        @Override
        protected NodeStateAssignment afterSplit(AbstractBeginNode node, NodeStateAssignment oldState) {
            return oldState;
        }

        @Override
        protected EconomicMap<LoopExitNode, NodeStateAssignment> processLoop(LoopBeginNode loop, NodeStateAssignment initialState) {
            ReentrantNodeIterator.LoopInfo<NodeStateAssignment> loopInfo = ReentrantNodeIterator.processLoop(this, loop, initialState);
            int afterCount = 0;
            int invalidCount = 0;
            for (LoopEndNode loopEnd : loop.loopEnds()) {
                if (loopInfo.endStates.get((Object)loopEnd) == NodeStateAssignment.INVALID) {
                    ++invalidCount;
                    continue;
                }
                if (loopInfo.endStates.get((Object)loopEnd) != NodeStateAssignment.AFTER_BCI) continue;
                ++afterCount;
            }
            NodeStateAssignment selected = null;
            selected = invalidCount > 0 ? NodeStateAssignment.INVALID : (afterCount > 0 ? NodeStateAssignment.AFTER_BCI : NodeStateAssignment.BEFORE_BCI);
            this.stateMapping.put(loop, selected);
            if (selected != initialState) {
                for (LoopExitNode exit : loop.loopExits()) {
                    loopInfo.exitStates.put((Object)exit, (Object)selected);
                }
                if (selected == NodeStateAssignment.AFTER_BCI) {
                    for (LoopExitNode exit : loop.loopExits()) {
                        if (!exit.proxies().filter(ValueProxyNode.class).isNotEmpty()) continue;
                        GraalError.shouldNotReachHere("Snippet graphs containing loops with value proxies are not supported by snippet frame state assignment.");
                    }
                    this.stateMapping.put(loop, NodeStateAssignment.AFTER_BCI_INVALID_FOR_DEOPTIMIZATION);
                    ReentrantNodeIterator.processLoop(this, loop, NodeStateAssignment.AFTER_BCI_INVALID_FOR_DEOPTIMIZATION);
                }
            }
            return loopInfo.exitStates;
        }
    }

    public static enum NodeStateAssignment {
        BEFORE_BCI,
        AFTER_BCI,
        AFTER_BCI_INVALID_FOR_DEOPTIMIZATION,
        AFTER_EXCEPTION_BCI,
        INVALID;

    }
}

