/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;

public class RemoveValueProxyPhase
extends PostRunCanonicalizationPhase<CoreProviders> {
    public RemoveValueProxyPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.MID_TIER_LOWERING, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.when(!graphState.canWeakenFrameStateVerification(GraphState.FrameStateVerification.ALL_EXCEPT_LOOP_EXIT), "Cannot apply %s because the frame state verification has already been weakened to %s", new Object[]{this.getName(), graphState.getFrameStateVerification()}));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (LoopExitNode exit : graph.getNodes(LoopExitNode.TYPE)) {
            exit.removeProxies();
            FrameState frameState = exit.stateAfter();
            if (frameState == null || !frameState.isExceptionHandlingBCI()) continue;
            exit.setStateAfter(null);
            GraphUtil.tryKillUnused(frameState);
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL);
        graphState.weakenFrameStateVerification(GraphState.FrameStateVerification.ALL_EXCEPT_LOOP_EXIT);
    }
}

