/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.loop.BasicInductionVariable;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.DerivedInductionVariable;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;
import org.graalvm.collections.EconomicMap;

public class OptimizeOffsetAddressPhase
extends PostRunCanonicalizationPhase<CoreProviders> {
    private static final int ADDRESS_BITS = 64;
    private static final int INT_BITS = 32;

    public OptimizeOffsetAddressPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FIXED_READS, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (graph.hasLoops()) {
            LoopsData loopsData = context.getLoopsDataProvider().getLoopsData(graph);
            loopsData.detectCountedLoops();
            for (Loop loop : loopsData.countedLoops()) {
                for (OffsetAddressNode offsetAddressNode : loop.whole().nodes().filter(OffsetAddressNode.class)) {
                    OptimizeOffsetAddressPhase.tryOptimize(offsetAddressNode, loop);
                }
            }
        }
    }

    private static void tryOptimize(OffsetAddressNode offsetAddressNode, Loop loop) {
        ValueNode currentNode;
        EconomicMap<Node, InductionVariable> ivs = loop.getInductionVariables();
        InductionVariable currentIV = (InductionVariable)ivs.get((Object)offsetAddressNode.getOffset());
        while (currentIV instanceof DerivedInductionVariable && !(currentNode = currentIV.valueNode()).isDeleted()) {
            if (currentNode instanceof ZeroExtendNode) {
                ZeroExtendNode zeroExtendNode = (ZeroExtendNode)currentNode;
                OptimizeOffsetAddressPhase.tryOptimize(zeroExtendNode, loop);
                break;
            }
            if (currentNode instanceof NarrowNode) break;
            currentIV = ((DerivedInductionVariable)currentIV).getBase();
        }
    }

    private static void tryOptimize(ZeroExtendNode zeroExtendNode, Loop loop) {
        AddNode addNode;
        Object object;
        ValueNode input;
        if (zeroExtendNode.getInputBits() == 32 && zeroExtendNode.getResultBits() == 64 && ((IntegerStamp)zeroExtendNode.getValue().stamp(NodeView.DEFAULT)).isPositive() && (input = GraphUtil.unproxify(zeroExtendNode.getValue())) instanceof AddNode && (object = (addNode = (AddNode)input).getX()) instanceof PhiNode) {
            ConstantNode cst;
            PhiNode phi = (PhiNode)object;
            object = addNode.getY();
            if (object instanceof ConstantNode && (cst = (ConstantNode)object).asJavaConstant() != null && (object = loop.getInductionVariables().get((Object)phi)) instanceof BasicInductionVariable) {
                BasicInductionVariable inductionVariable = (BasicInductionVariable)object;
                CountedLoopInfo countedLoopInfo = loop.counted();
                IntegerStamp initStamp = (IntegerStamp)inductionVariable.initNode().stamp(NodeView.DEFAULT);
                if (initStamp.isPositive()) {
                    int cstAsInt = cst.asJavaConstant().asInt();
                    if (countedLoopInfo.counterNeverOverflows() && inductionVariable.isConstantInit() && inductionVariable.isConstantStride() && inductionVariable.isConstantExtremum()) {
                        long init = inductionVariable.constantInit();
                        long stride = inductionVariable.constantStride();
                        long extremum = inductionVariable.constantExtremum();
                        if (init >= 0L && extremum >= 0L) {
                            long shortestTrip = (extremum - init) / stride + 1L;
                            if (countedLoopInfo.constantMaxTripCount().equals(shortestTrip)) {
                                OptimizeOffsetAddressPhase.replace(zeroExtendNode, phi, cstAsInt);
                                return;
                            }
                        }
                    }
                    if (countedLoopInfo.getLimitCheckedIV() == inductionVariable && inductionVariable.direction() == InductionVariable.Direction.Up && (countedLoopInfo.getOverFlowGuard() != null || countedLoopInfo.counterNeverOverflows())) {
                        OptimizeOffsetAddressPhase.replace(zeroExtendNode, phi, cstAsInt);
                    }
                }
            }
        }
    }

    private static void replace(ZeroExtendNode zeroExtendNode, PhiNode phi, long cst) {
        StructuredGraph graph = zeroExtendNode.graph();
        ZeroExtendNode newZeroExtendNode = graph.unique(new ZeroExtendNode(phi, 32, 64));
        AddNode newAddNode = graph.unique(new AddNode(newZeroExtendNode, ConstantNode.forLong(cst, graph)));
        zeroExtendNode.replaceAndDelete(newAddNode);
    }
}

