/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.GuardedNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryMapNode;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.memory.SideEffectFreeWriteNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.CoreProvidersDelegate;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicSet;
import org.graalvm.word.LocationIdentity;

public abstract class LoweringPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;
    private final LoweringTool.StandardLoweringStage loweringStage;
    private final boolean lowerOptimizableMacroNodes;
    private final GraphState.StageFlag postRunStage;
    private static final ClassValue<LoweringStatistics> statisticsClassValue = new ClassValue<LoweringStatistics>(){

        @Override
        protected LoweringStatistics computeValue(Class<?> c) {
            return new LoweringStatistics(c);
        }
    };

    @Override
    public boolean checkContract() {
        return false;
    }

    LoweringPhase(CanonicalizerPhase canonicalizer, LoweringTool.StandardLoweringStage loweringStage, boolean lowerOptimizableMacroNodes, GraphState.StageFlag postRunStage) {
        this.canonicalizer = canonicalizer;
        this.loweringStage = loweringStage;
        this.lowerOptimizableMacroNodes = lowerOptimizableMacroNodes;
        this.postRunStage = postRunStage;
    }

    LoweringPhase(CanonicalizerPhase canonicalizer, LoweringTool.StandardLoweringStage loweringStage, GraphState.StageFlag postRunStage) {
        this(canonicalizer, loweringStage, false, postRunStage);
    }

    @Override
    protected boolean shouldDumpBeforeAtBasicLevel() {
        return this.loweringStage == LoweringTool.StandardLoweringStage.HIGH_TIER;
    }

    private boolean checkPostLowering(StructuredGraph graph, CoreProviders context) {
        Graph.Mark expectedMark = graph.getMark();
        this.lower(graph, context, LoweringMode.VERIFY_LOWERING);
        Graph.Mark mark = graph.getMark();
        assert (mark.equals(expectedMark) || graph.getNewNodes(mark).count() == 0) : String.valueOf(graph) + ": a second round in the current lowering phase introduced these new nodes: " + String.valueOf(graph.getNewNodes(expectedMark).snapshot());
        return true;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return this.canonicalizer.notApplicableTo(graphState);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        this.lower(graph, context, LoweringMode.LOWERING);
        assert (this.checkPostLowering(graph, context));
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(this.postRunStage);
    }

    private void lower(StructuredGraph graph, CoreProviders context, LoweringMode mode) {
        boolean immutableSchedule = mode == LoweringMode.VERIFY_LOWERING;
        OptionValues options = graph.getOptions();
        new SchedulePhase(immutableSchedule, options).apply(graph, context);
        if (Options.PrintLoweringScheduleToTTY.getValue(graph.getOptions()).booleanValue()) {
            TTY.printf("%s%n", graph.getLastSchedule().print());
        }
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            schedule.getCFG().computePostdominators();
            HIRBlock startBlock = schedule.getCFG().getStartBlock();
            ProcessFrame rootFrame = new ProcessFrame(context, startBlock, graph.createNodeBitMap(), startBlock.getBeginNode(), null, schedule);
            LoweringPhase.processBlock(rootFrame);
        }
        if (!listener.getNodes().isEmpty()) {
            this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkPostNodeLowering(Node justLoweredNode, LoweringToolImpl loweringTool, Graph.Mark preLoweringMark, Collection<Node> unscheduledUsages) {
        StructuredGraph graph = (StructuredGraph)justLoweredNode.graph();
        Graph.Mark postLoweringMark = graph.getMark();
        NodeIterable<Node> newNodesAfterLowering = graph.getNewNodes(preLoweringMark);
        if (justLoweredNode instanceof FloatingNode && !unscheduledUsages.isEmpty()) {
            for (Node n : newNodesAfterLowering) {
                assert (!(n instanceof FixedNode)) : String.valueOf(justLoweredNode.graph()) + ": cannot lower floatable node " + String.valueOf(justLoweredNode) + " as it introduces fixed node(s) but has the following unscheduled usages: " + String.valueOf(unscheduledUsages);
            }
        }
        boolean wasMemoryAccessBefore = justLoweredNode instanceof MemoryAccess;
        boolean wasMemoryKillBefore = MemoryKill.isMemoryKill(justLoweredNode);
        for (Node newNodeAfterLowering : newNodesAfterLowering) {
            if (newNodeAfterLowering instanceof Lowerable) {
                ((Lowerable)((Object)newNodeAfterLowering)).lower(loweringTool);
                Graph.Mark mark = graph.getMark();
                assert (postLoweringMark.equals(mark)) : String.valueOf(graph) + ": lowering of " + String.valueOf(justLoweredNode) + " produced lowerable " + String.valueOf(newNodeAfterLowering) + " that should have been recursively lowered as it introduces these new nodes: " + String.valueOf(graph.getNewNodes(postLoweringMark).snapshot());
            }
            if (!graph.isSubstitution() && loweringTool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                MemoryAccess access;
                if (!(newNodeAfterLowering instanceof ForeignCall || newNodeAfterLowering instanceof UnreachableBeginNode || justLoweredNode instanceof WithExceptionNode || newNodeAfterLowering instanceof MemoryMapNode || justLoweredNode instanceof CommitAllocationNode || newNodeAfterLowering instanceof SideEffectFreeWriteNode || !MemoryKill.isMemoryKill(newNodeAfterLowering))) {
                    if (MemoryKill.isSingleMemoryKill(newNodeAfterLowering)) {
                        SingleMemoryKill singleKill = (SingleMemoryKill)((Object)newNodeAfterLowering);
                        if (!singleKill.getKilledLocationIdentity().equals(MemoryKill.NO_LOCATION)) {
                            if (!wasMemoryKillBefore) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s was not a kill but %s is", justLoweredNode, newNodeAfterLowering));
                            }
                            if (!MemoryKill.isSingleMemoryKill(justLoweredNode)) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s was not a single kill but %s is", justLoweredNode, newNodeAfterLowering));
                            }
                            SingleMemoryKill oldKill = (SingleMemoryKill)((Object)justLoweredNode);
                            if (!(!oldKill.getKilledLocationIdentity().isSingle() && singleKill.getKilledLocationIdentity().isSingle() || oldKill.getKilledLocationIdentity().equals(singleKill.getKilledLocationIdentity()))) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s kills %s while new node %s kills %s", justLoweredNode, oldKill.getKilledLocationIdentity(), singleKill, singleKill.getKilledLocationIdentity()));
                            }
                        }
                    } else {
                        if (!MemoryKill.isMultiMemoryKill(newNodeAfterLowering)) throw GraalError.shouldNotReachHere("Unknown memory kill " + String.valueOf(newNodeAfterLowering));
                        if (!wasMemoryKillBefore) {
                            throw GraalError.shouldNotReachHere(String.format("Original node %s was not a kill but %s is", justLoweredNode, newNodeAfterLowering));
                        }
                        if (!MemoryKill.isMultiMemoryKill(justLoweredNode)) {
                            throw GraalError.shouldNotReachHere(String.format("Original node %s was not a multi kill but %s is", justLoweredNode, newNodeAfterLowering));
                        }
                        MultiMemoryKill newKill = (MultiMemoryKill)((Object)newNodeAfterLowering);
                        MultiMemoryKill oldKill = (MultiMemoryKill)((Object)justLoweredNode);
                        EconomicSet killed = EconomicSet.create();
                        for (LocationIdentity loc : newKill.getKilledLocationIdentities()) {
                            killed.add((Object)loc);
                        }
                        for (LocationIdentity oldLoc : oldKill.getKilledLocationIdentities()) {
                            if (!killed.contains((Object)oldLoc)) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s kills %s while new node %s does not kill that location", oldKill, oldLoc, newKill));
                            }
                            killed.remove((Object)oldLoc);
                        }
                        Iterator iterator = killed.iterator();
                        if (iterator.hasNext()) {
                            LocationIdentity newLoc = (LocationIdentity)iterator.next();
                            throw GraalError.shouldNotReachHere(String.format("New kill %s kills location %s while old kill %s does not", newKill, newLoc, oldKill));
                        }
                    }
                } else if (newNodeAfterLowering instanceof MemoryAccess && (access = (MemoryAccess)((Object)newNodeAfterLowering)).getLocationIdentity().isMutable()) {
                    if (wasMemoryKillBefore && !wasMemoryAccessBefore) {
                        if (MemoryKill.isSingleMemoryKill(justLoweredNode)) {
                            if (!((SingleMemoryKill)((Object)justLoweredNode)).getKilledLocationIdentity().overlaps(access.getLocationIdentity())) {
                                GraalError.shouldNotReachHere(String.format("Node %s was a memory kill killing %s but lowered to a memory access %s which accesses %s", justLoweredNode, ((SingleMemoryKill)((Object)justLoweredNode)).getKilledLocationIdentity(), newNodeAfterLowering, access.getLocationIdentity()));
                            }
                        } else {
                            if (!MemoryKill.isMultiMemoryKill(justLoweredNode)) throw GraalError.shouldNotReachHere("Unknown type of memory kill " + String.valueOf(justLoweredNode));
                            boolean found = false;
                            for (LocationIdentity ident : ((MultiMemoryKill)((Object)justLoweredNode)).getKilledLocationIdentities()) {
                                if (!ident.overlaps(access.getLocationIdentity())) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                GraalError.shouldNotReachHere(String.format("Node %s was a memory kill not killing the location accessed by the lowered node: %s which accesses %s", justLoweredNode, newNodeAfterLowering, access.getLocationIdentity()));
                            }
                        }
                    } else if (wasMemoryAccessBefore) {
                        if (!access.getLocationIdentity().overlaps(((MemoryAccess)((Object)justLoweredNode)).getLocationIdentity())) {
                            GraalError.shouldNotReachHere(String.format("Node %s was a memory access (%s) but lowered to a memory access %s %s", justLoweredNode, ((MemoryAccess)((Object)justLoweredNode)).getLocationIdentity(), newNodeAfterLowering, access.getLocationIdentity()));
                        }
                    } else {
                        GraalError.shouldNotReachHere(String.format("Node %s was not a memory access but lowered to a memory access %s", justLoweredNode, newNodeAfterLowering));
                    }
                }
            }
            if (!MemoryKill.isMemoryKill(newNodeAfterLowering) || newNodeAfterLowering instanceof MemoryMapNode || wasMemoryKillBefore || justLoweredNode instanceof ControlSinkNode || LoweringPhase.replaceeWithExceptionHandler(justLoweredNode, newNodeAfterLowering)) continue;
            boolean isAny = false;
            if (MemoryKill.isSingleMemoryKill(newNodeAfterLowering)) {
                isAny = ((SingleMemoryKill)((Object)newNodeAfterLowering)).getKilledLocationIdentity().isAny();
            } else {
                if (!MemoryKill.isMultiMemoryKill(newNodeAfterLowering)) throw GraalError.shouldNotReachHere("Unknown type of memory kill " + String.valueOf(newNodeAfterLowering));
                for (LocationIdentity ident : ((MultiMemoryKill)((Object)newNodeAfterLowering)).getKilledLocationIdentities()) {
                    if (!ident.isAny()) continue;
                    isAny = true;
                }
            }
            if (isAny && newNodeAfterLowering instanceof FixedWithNextNode) {
                for (FixedWithNextNode cur = (FixedWithNextNode)newNodeAfterLowering; cur != null && graph.isNew(preLoweringMark, cur); cur = (FixedWithNextNode)cur.next()) {
                    if (cur.next() instanceof ControlSinkNode) {
                        isAny = false;
                        break;
                    }
                    if (!(cur.next() instanceof FixedWithNextNode)) break;
                }
            }
            assert (!isAny) : String.valueOf(justLoweredNode) + " " + String.valueOf(newNodeAfterLowering);
        }
        return true;
    }

    private static boolean replaceeWithExceptionHandler(Node n, Node newNodeAfterLowering) {
        if (n instanceof WithExceptionNode && !n.isAlive() && newNodeAfterLowering instanceof FixedNode) {
            FixedNode f = (FixedNode)newNodeAfterLowering;
            return SnippetTemplate.walkBackToExceptionEdgeStart(f) instanceof ExceptionObjectNode.LoweredExceptionObjectBegin;
        }
        return false;
    }

    private AnchoringNode process(CoreProviders context, HIRBlock b, NodeBitMap activeGuards, AnchoringNode startAnchor, StructuredGraph.ScheduleResult schedule) {
        FixedWithNextNode lastFixedNode = b.getBeginNode();
        if (b.getBeginNode() instanceof LoopExitNode) {
            FixedNode pred = (FixedNode)lastFixedNode.predecessor();
            if (!(pred instanceof FixedWithNextNode)) {
                AbstractBeginNode begin = b.getBeginNode().graph().add(new BeginNode());
                pred.replaceFirstSuccessor(lastFixedNode, begin);
                begin.setNext(lastFixedNode);
                lastFixedNode = begin;
            } else {
                lastFixedNode = (FixedWithNextNode)pred;
            }
        }
        LoweringToolImpl loweringTool = new LoweringToolImpl(context, startAnchor, activeGuards, lastFixedNode, schedule.getNodeToBlockMap());
        DebugContext debug = startAnchor.asNode().getDebug();
        List<Node> nodes = schedule.nodesFor(b);
        for (Node node : nodes) {
            if (node.isDeleted()) continue;
            FixedNode nextNode = null;
            nextNode = node instanceof FixedWithNextNode ? ((FixedWithNextNode)node).next() : loweringTool.lastFixedNode().next();
            if (node instanceof Lowerable) {
                Collection<Node> unscheduledUsages = null;
                assert ((unscheduledUsages = LoweringPhase.getUnscheduledUsages(node, schedule)) != null);
                Graph.Mark preLoweringMark = node.graph().getMark();
                try (DebugCloseable s = node.graph().withNodeSourcePosition(node);){
                    TimerKey timer = null;
                    if (debug.areMetricsEnabled()) {
                        LoweringStatistics statistics = statisticsClassValue.get(node.getClass());
                        statistics.counters[this.loweringStage.ordinal()].increment(debug);
                        timer = statistics.timers[this.loweringStage.ordinal()];
                    }
                    try (DebugCloseable a = timer != null ? timer.start(debug) : null;
                         DebugCloseable a2 = this.loweringStage.timer.start(debug);){
                        ((Lowerable)((Object)node)).lower(loweringTool);
                    }
                }
                if (loweringTool.guardAnchor.asNode().isDeleted()) {
                    assert (nextNode.isAlive());
                    loweringTool.guardAnchor = AbstractBeginNode.prevBegin(nextNode);
                }
                assert (LoweringPhase.checkPostNodeLowering(node, loweringTool, preLoweringMark, unscheduledUsages));
            }
            if (!nextNode.isAlive()) break;
            Node nextLastFixed = nextNode.predecessor();
            if (!(nextLastFixed instanceof FixedWithNextNode)) {
                AbstractBeginNode begin = node.graph().add(new BeginNode());
                nextLastFixed.replaceFirstSuccessor(nextNode, begin);
                begin.setNext(nextNode);
                nextLastFixed = begin;
            }
            loweringTool.setLastFixedNode((FixedWithNextNode)nextLastFixed);
            if (!Options.DumpAfterEveryLowering.getValue(debug.getOptions()).booleanValue()) continue;
            debug.dump(5, (Object)b.getBeginNode().graph(), "After lowering %s", node);
        }
        return loweringTool.getCurrentGuardAnchor();
    }

    private static Collection<Node> getUnscheduledUsages(Node node, StructuredGraph.ScheduleResult schedule) {
        ArrayList<Node> unscheduledUsages = new ArrayList<Node>();
        if (node instanceof FloatingNode) {
            for (Node usage : node.usages()) {
                if (!(usage instanceof ValueNode) || usage instanceof PhiNode || usage instanceof ProxyNode || !schedule.getCFG().getNodeToBlock().isNew(usage) && schedule.getCFG().blockFor(usage) != null) continue;
                unscheduledUsages.add(usage);
            }
        }
        return unscheduledUsages;
    }

    public static void processBlock(Frame<?> rootFrame) {
        ProcessBlockState state = ProcessBlockState.ST_PROCESS;
        Frame<Object> f = rootFrame;
        while (f != null) {
            ProcessBlockState nextState;
            if (state == ProcessBlockState.ST_PROCESS || state == ProcessBlockState.ST_PROCESS_ALWAYS_REACHED) {
                f.preprocess();
                nextState = state == ProcessBlockState.ST_PROCESS_ALWAYS_REACHED ? ProcessBlockState.ST_ENTER : ProcessBlockState.ST_ENTER_ALWAYS_REACHED;
            } else if (state == ProcessBlockState.ST_ENTER_ALWAYS_REACHED) {
                if (f.alwaysReachedBlock != null && f.alwaysReachedBlock.getDominator() == f.block) {
                    f = f.enterAlwaysReached(f.alwaysReachedBlock);
                    nextState = ProcessBlockState.ST_PROCESS;
                } else {
                    nextState = ProcessBlockState.ST_ENTER;
                }
            } else if (state == ProcessBlockState.ST_ENTER) {
                if (f.dominated != null) {
                    HIRBlock n = f.dominated;
                    f.dominated = (HIRBlock)n.getDominatedSibling();
                    if (n == f.alwaysReachedBlock) {
                        if (f.dominated != null) {
                            n = f.dominated;
                            f.dominated = (HIRBlock)n.getDominatedSibling();
                        } else {
                            n = null;
                        }
                    }
                    if (n == null) {
                        nextState = ProcessBlockState.ST_LEAVE;
                    } else {
                        f = f.enter(n);
                        assert (f.block.getDominator() == ((Frame)f.parent).block) : Assertions.errorMessage(f.block, f.block.getDominator(), ((Frame)f.parent).block);
                        nextState = ProcessBlockState.ST_PROCESS;
                    }
                } else {
                    nextState = ProcessBlockState.ST_LEAVE;
                }
            } else if (state == ProcessBlockState.ST_LEAVE) {
                f.postprocess();
                f = f.parent;
                nextState = ProcessBlockState.ST_ENTER;
            } else {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)state);
            }
            state = nextState;
        }
    }

    private static enum LoweringMode {
        LOWERING,
        VERIFY_LOWERING;

    }

    public static class Options {
        public static final OptionKey<Boolean> PrintLoweringScheduleToTTY = new OptionKey<Boolean>(false);
        public static final OptionKey<Boolean> DumpAfterEveryLowering = new OptionKey<Boolean>(false);
    }

    private class ProcessFrame
    extends Frame<ProcessFrame> {
        private final NodeBitMap activeGuards;
        private AnchoringNode anchor;
        private final StructuredGraph.ScheduleResult schedule;
        private final CoreProviders context;

        ProcessFrame(CoreProviders context, HIRBlock block, NodeBitMap activeGuards, AnchoringNode anchor, ProcessFrame parent, StructuredGraph.ScheduleResult schedule) {
            super(block, parent);
            this.context = context;
            this.activeGuards = activeGuards;
            this.anchor = anchor;
            this.schedule = schedule;
        }

        @Override
        public void preprocess() {
            this.anchor = LoweringPhase.this.process(this.context, this.block, this.activeGuards, this.anchor, this.schedule);
        }

        public ProcessFrame enter(HIRBlock b) {
            return new ProcessFrame(this.context, b, this.activeGuards, b.getBeginNode(), this, this.schedule);
        }

        @Override
        public Frame<?> enterAlwaysReached(HIRBlock b) {
            AnchoringNode newAnchor = this.anchor;
            if (this.parent != null && b.getLoop() != ((ProcessFrame)this.parent).block.getLoop() && !b.isLoopHeader()) {
                newAnchor = b.getBeginNode();
            }
            return new ProcessFrame(this.context, b, this.activeGuards, newAnchor, this, this.schedule);
        }

        @Override
        public void postprocess() {
            if (this.anchor == this.block.getBeginNode() && GraalOptions.OptEliminateGuards.getValue(this.activeGuards.graph().getOptions()).booleanValue()) {
                for (GuardNode guard : this.anchor.asNode().usages().filter(GuardNode.class)) {
                    if (!this.activeGuards.isMarkedAndGrow(guard)) continue;
                    this.activeGuards.clear(guard);
                }
            }
        }
    }

    public static abstract class Frame<T extends Frame<?>> {
        protected final HIRBlock block;
        final T parent;
        HIRBlock dominated;
        final HIRBlock alwaysReachedBlock;

        public Frame(HIRBlock block, T parent) {
            this.block = block;
            this.alwaysReachedBlock = block.getPostdominator();
            this.dominated = (HIRBlock)block.getFirstDominated();
            this.parent = parent;
        }

        public Frame<?> enterAlwaysReached(HIRBlock b) {
            return this.enter(b);
        }

        public abstract Frame<?> enter(HIRBlock var1);

        public abstract void preprocess();

        public abstract void postprocess();
    }

    final class LoweringToolImpl
    extends CoreProvidersDelegate
    implements LoweringTool {
        private final NodeBitMap activeGuards;
        private AnchoringNode guardAnchor;
        private FixedWithNextNode lastFixedNode;
        private NodeMap<HIRBlock> nodeMap;

        LoweringToolImpl(CoreProviders context, AnchoringNode guardAnchor, NodeBitMap activeGuards, FixedWithNextNode lastFixedNode, NodeMap<HIRBlock> nodeMap) {
            super(context);
            this.guardAnchor = guardAnchor;
            this.activeGuards = activeGuards;
            this.lastFixedNode = lastFixedNode;
            this.nodeMap = nodeMap;
        }

        @Override
        public LoweringTool.LoweringStage getLoweringStage() {
            return LoweringPhase.this.loweringStage;
        }

        @Override
        public AnchoringNode getCurrentGuardAnchor() {
            return this.guardAnchor;
        }

        @Override
        public boolean lowerOptimizableMacroNodes() {
            return LoweringPhase.this.lowerOptimizableMacroNodes;
        }

        @Override
        public GuardingNode createGuard(FixedNode before, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action) {
            return this.createGuard(before, condition, deoptReason, action, SpeculationLog.NO_SPECULATION, false, null);
        }

        @Override
        public GuardingNode createGuard(FixedNode before, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated, NodeSourcePosition noDeoptSuccessorPosition) {
            StructuredGraph graph = before.graph();
            if (GraalOptions.OptEliminateGuards.getValue(graph.getOptions()).booleanValue()) {
                for (GuardNode usage : condition.usages().filter(GuardNode.class)) {
                    if (this.activeGuards.isNew(usage) || !this.activeGuards.isMarked(usage) || usage.isNegated() != negated) continue;
                    ValueNode anchor = usage.getAnchor().asNode();
                    if (!before.graph().isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) && (this.nodeMap.isNew(anchor) || !this.nodeMap.get(anchor).isInSameOrOuterLoopOf(this.nodeMap.get(before)))) continue;
                    return usage;
                }
            }
            if (!condition.graph().getGuardsStage().allowsFloatingGuards()) {
                FixedGuardNode fixedGuard = graph.add(new FixedGuardNode(condition, deoptReason, action, speculation, negated, noDeoptSuccessorPosition));
                graph.addBeforeFixed(before, fixedGuard);
                DummyGuardHandle handle = graph.add(new DummyGuardHandle(fixedGuard));
                fixedGuard.lower(this);
                GuardingNode result = handle.getGuard();
                handle.safeDelete();
                return result;
            }
            GuardNode newGuard = graph.unique(new GuardNode(condition, this.guardAnchor, deoptReason, action, negated, speculation, noDeoptSuccessorPosition));
            if (GraalOptions.OptEliminateGuards.getValue(graph.getOptions()).booleanValue()) {
                this.activeGuards.markAndGrow(newGuard);
            }
            return newGuard;
        }

        @Override
        public FixedWithNextNode lastFixedNode() {
            GraalError.guarantee(this.lastFixedNode.isAlive(), "The last fixed node %s was deleted by a previous lowering", (Object)this.lastFixedNode);
            return this.lastFixedNode;
        }

        private void setLastFixedNode(FixedWithNextNode n) {
            GraalError.guarantee(n.isAlive(), "Cannot add last fixed node %s because it is not alive", (Object)n);
            this.lastFixedNode = n;
        }
    }

    public static class LoweringStatistics {
        static final EnumSet<LoweringTool.StandardLoweringStage> stages = EnumSet.allOf(LoweringTool.StandardLoweringStage.class);
        private final TimerKey[] timers = new TimerKey[stages.size()];
        private final CounterKey[] counters = new CounterKey[stages.size()];

        public LoweringStatistics(Class<?> clazz) {
            for (LoweringTool.StandardLoweringStage loweringStage : stages) {
                this.timers[loweringStage.ordinal()] = DebugContext.timer("LoweringTime_%s_%s", loweringStage, clazz);
                this.counters[loweringStage.ordinal()] = DebugContext.counter("LoweringCount_%s_%s", loweringStage, clazz);
            }
        }
    }

    static enum ProcessBlockState {
        ST_ENTER,
        ST_PROCESS,
        ST_ENTER_ALWAYS_REACHED,
        ST_LEAVE,
        ST_PROCESS_ALWAYS_REACHED;

    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    static final class DummyGuardHandle
    extends ValueNode
    implements GuardedNode {
        public static final NodeClass<DummyGuardHandle> TYPE = NodeClass.create(DummyGuardHandle.class);
        @Node.Input(value=InputType.Guard)
        GuardingNode guard;

        protected DummyGuardHandle(GuardingNode guard) {
            super(TYPE, StampFactory.forVoid());
            this.guard = guard;
        }

        @Override
        public GuardingNode getGuard() {
            return this.guard;
        }

        @Override
        public void setGuard(GuardingNode guard) {
            this.updateUsagesInterface(this.guard, guard);
            this.guard = guard;
        }
    }
}

