/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Objects;
import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.ConditionalEliminationPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;

public class IterativeConditionalEliminationPhase
extends BasePhase<CoreProviders> {
    private final boolean fullSchedule;
    private final ConditionalEliminationPhase conditionalEliminationPhase;

    public IterativeConditionalEliminationPhase(CanonicalizerPhase canonicalizer, boolean fullSchedule) {
        this.fullSchedule = fullSchedule;
        this.conditionalEliminationPhase = new ConditionalEliminationPhase(canonicalizer, fullSchedule);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return this.conditionalEliminationPhase.notApplicableTo(graphState);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        int maxIterations = GraalOptions.ConditionalEliminationMaxIterations.getValue(graph.getOptions());
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        for (int count = 0; count < maxIterations; ++count) {
            try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
                this.conditionalEliminationPhase.apply(graph, context);
            }
            if (listener.getNodes().isEmpty()) break;
            listener.getNodes().clear();
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().getName(), this.fullSchedule, this.conditionalEliminationPhase);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IterativeConditionalEliminationPhase)) {
            return false;
        }
        IterativeConditionalEliminationPhase that = (IterativeConditionalEliminationPhase)obj;
        return this.getClass().equals(that.getClass()) && this.fullSchedule == that.fullSchedule && this.conditionalEliminationPhase.equals(that.conditionalEliminationPhase);
    }
}

