/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.extended.PublishWritesNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.memory.MemoryAnchorNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.RecursivePhase;
import jdk.graal.compiler.phases.VerifyPhase;
import jdk.graal.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public class InitMemoryVerificationPhase
extends VerifyPhase<CoreProviders>
implements RecursivePhase {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.MID_TIER_LOWERING, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.LOW_TIER_LOWERING, graphState));
    }

    @Override
    protected void verify(StructuredGraph graph, CoreProviders context) {
        ReentrantNodeIterator.apply(new InitBarrierVerificationClosure(), graph.start(), 0);
        ReentrantNodeIterator.apply(new AllocPublishVerificationClosure(), graph.start(), EconomicSet.create());
    }

    private static class InitBarrierVerificationClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<Integer> {
        private InitBarrierVerificationClosure() {
        }

        @Override
        protected Integer processNode(FixedNode node, Integer kills) {
            int liveKills = kills;
            if (node instanceof MembarNode) {
                MembarNode memBar = (MembarNode)node;
                if (memBar.getFenceKind().isInit()) {
                    liveKills = 0;
                } else if (liveKills > 0) {
                    throw new VerifyPhase.VerificationError("%s is a non-init barrier, but there are %d live init writes", memBar, liveKills);
                }
            } else if (MemoryKill.isMemoryKill(node) && ((MemoryKill)((Object)node)).killsInit()) {
                if (!(node instanceof MemoryAnchorNode)) {
                    ++liveKills;
                }
            } else if (node instanceof ReturnNode && liveKills > 0) {
                throw new VerifyPhase.VerificationError("%d writes to init memory not guarded by an init barrier at node %s", liveKills, node);
            }
            return liveKills;
        }

        @Override
        protected Integer merge(AbstractMergeNode merge, List<Integer> states) {
            int sum = 0;
            for (int kills : states) {
                sum += kills;
            }
            return sum;
        }

        @Override
        protected Integer afterSplit(AbstractBeginNode node, Integer kills) {
            return kills;
        }

        @Override
        protected EconomicMap<LoopExitNode, Integer> processLoop(LoopBeginNode loop, Integer kills) {
            ReentrantNodeIterator.LoopInfo<Integer> loopInfo = ReentrantNodeIterator.processLoop(this, loop, kills);
            return loopInfo.exitStates;
        }
    }

    private static class AllocPublishVerificationClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<EconomicSet<AbstractNewObjectNode>> {
        private AllocPublishVerificationClosure() {
        }

        private static void processAlloc(AbstractNewObjectNode allocation, EconomicSet<AbstractNewObjectNode> unpublished) {
            if (allocation.emitMemoryBarrier() && allocation.fillContents()) {
                return;
            }
            unpublished.add((Object)allocation);
        }

        private static void markPublished(ValueNode node, EconomicSet<AbstractNewObjectNode> unpublished) {
            if (node instanceof ValuePhiNode) {
                ValuePhiNode phi = (ValuePhiNode)node;
                for (ValueNode value : phi.values()) {
                    AllocPublishVerificationClosure.markPublished(value, unpublished);
                }
            } else if (node instanceof AbstractNewObjectNode) {
                AbstractNewObjectNode newObject = (AbstractNewObjectNode)node;
                unpublished.remove((Object)newObject);
            }
        }

        @Override
        protected EconomicSet<AbstractNewObjectNode> processNode(FixedNode node, EconomicSet<AbstractNewObjectNode> unpublished) {
            if (node instanceof AbstractNewObjectNode) {
                AbstractNewObjectNode allocation = (AbstractNewObjectNode)node;
                AllocPublishVerificationClosure.processAlloc(allocation, unpublished);
            } else if (node instanceof PublishWritesNode) {
                PublishWritesNode publish = (PublishWritesNode)node;
                AllocPublishVerificationClosure.markPublished(publish.allocation(), unpublished);
            } else if (node instanceof ReturnNode && !unpublished.isEmpty()) {
                throw new VerifyPhase.VerificationError("unpublished allocations at node %s: %s", unpublished, node);
            }
            return unpublished;
        }

        @Override
        protected EconomicSet<AbstractNewObjectNode> merge(AbstractMergeNode merge, List<EconomicSet<AbstractNewObjectNode>> states) {
            EconomicSet merged = EconomicSet.create();
            for (EconomicSet<AbstractNewObjectNode> state : states) {
                merged.addAll(state);
            }
            return merged;
        }

        @Override
        protected EconomicSet<AbstractNewObjectNode> afterSplit(AbstractBeginNode node, EconomicSet<AbstractNewObjectNode> oldState) {
            return EconomicSet.create(oldState);
        }

        @Override
        protected EconomicMap<LoopExitNode, EconomicSet<AbstractNewObjectNode>> processLoop(LoopBeginNode loop, EconomicSet<AbstractNewObjectNode> initialState) {
            ReentrantNodeIterator.LoopInfo<EconomicSet<AbstractNewObjectNode>> loopInfo = ReentrantNodeIterator.processLoop(this, loop, initialState);
            return loopInfo.exitStates;
        }
    }
}

