/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.Phase;
import jdk.graal.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.collections.EconomicMap;

public class FrameStateAssignmentPhase
extends Phase {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.when(graphState.getGuardsStage().allowsFloatingGuards(), "Floating guards should not be allowed."), BasePhase.NotApplicable.when(graphState.getGuardsStage().areFrameStatesAtDeopts(), "This phase must run before FSA"));
    }

    @Override
    protected void run(StructuredGraph graph) {
        assert (!FrameStateAssignmentPhase.hasFloatingDeopts(graph));
        ReentrantNodeIterator.apply(new FrameStateAssignmentClosure(), graph.start(), null);
        GraphUtil.killAllWithUnusedFloatingInputs(graph.getNodes(FrameState.TYPE).filter(state -> state.hasNoUsages()), false);
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterFSA();
        graphState.weakenFrameStateVerification(GraphState.FrameStateVerification.NONE);
        graphState.addFutureStageRequirement(GraphState.StageFlag.CANONICALIZATION);
    }

    private static boolean hasFloatingDeopts(StructuredGraph graph) {
        for (Node n : graph.getNodes()) {
            DeoptimizingNode deoptimizingNode;
            if (!(n instanceof DeoptimizingNode) || !GraphUtil.isFloatingNode(n) || !(deoptimizingNode = (DeoptimizingNode)((Object)n)).canDeoptimize()) continue;
            return true;
        }
        return false;
    }

    private static FrameState singleFrameState(List<FrameState> states) {
        FrameState singleState = states.get(0);
        for (int i = 1; i < states.size(); ++i) {
            if (states.get(i) == singleState) continue;
            return null;
        }
        if (singleState != null && singleState.bci != -6) {
            return singleState;
        }
        return null;
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    private static class FrameStateAssignmentClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<FrameState> {
        private FrameStateAssignmentClosure() {
        }

        @Override
        protected FrameState processNode(FixedNode node, FrameState previousState) {
            StateSplit stateSplit;
            FrameState stateAfter;
            DeoptimizingNode deopt;
            FrameState currentState = previousState;
            if (node instanceof DeoptimizingNode.DeoptBefore) {
                deopt = (DeoptimizingNode.DeoptBefore)((Object)node);
                if (deopt.canDeoptimize() && deopt.stateBefore() == null) {
                    GraalError.guarantee(currentState != null, "no FrameState at DeoptimizingNode %s", (Object)deopt);
                    deopt.setStateBefore(currentState);
                }
                if (deopt.canDeoptimize() && deopt.validateDeoptFrameStates() && !deopt.stateBefore().isValidForDeoptimization()) {
                    throw GraalError.shouldNotReachHere(String.format("Invalid framestate for %s: %s", deopt, deopt.stateBefore()));
                }
            }
            if (node instanceof StateSplit && (stateAfter = (stateSplit = (StateSplit)((Object)node)).stateAfter()) != null) {
                currentState = stateAfter.bci == -6 ? null : stateAfter;
                stateSplit.setStateAfter(null);
            }
            if (node instanceof DeoptimizingNode.DeoptDuring) {
                deopt = (DeoptimizingNode.DeoptDuring)((Object)node);
                if (deopt.canDeoptimize() && deopt.stateDuring() == null) {
                    GraalError.guarantee(currentState != null, "no FrameState at DeoptimizingNode %s", (Object)deopt);
                    deopt.computeStateDuring(currentState);
                }
                if (deopt.canDeoptimize() && deopt.validateDeoptFrameStates() && !deopt.stateDuring().isValidForDeoptimization()) {
                    throw GraalError.shouldNotReachHere(String.format("Invalid framestate for %s: %s", deopt, deopt.stateDuring()));
                }
            }
            if (node instanceof DeoptimizingNode.DeoptAfter) {
                deopt = (DeoptimizingNode.DeoptAfter)((Object)node);
                if (deopt.canDeoptimize() && deopt.stateAfter() == null) {
                    GraalError.guarantee(currentState != null, "no FrameState at DeoptimizingNode %s", (Object)deopt);
                    deopt.setStateAfter(currentState);
                }
                if (deopt.canDeoptimize() && deopt.validateDeoptFrameStates() && !deopt.stateAfter().isValidForDeoptimization()) {
                    throw GraalError.shouldNotReachHere(String.format("Invalid framestate for %s: %s", deopt, deopt.stateAfter()));
                }
            }
            return currentState;
        }

        @Override
        protected FrameState merge(AbstractMergeNode merge, List<FrameState> states) {
            FrameState singleFrameState = FrameStateAssignmentPhase.singleFrameState(states);
            return singleFrameState == null ? merge.stateAfter() : singleFrameState;
        }

        @Override
        protected FrameState afterSplit(AbstractBeginNode node, FrameState oldState) {
            return oldState;
        }

        @Override
        protected EconomicMap<LoopExitNode, FrameState> processLoop(LoopBeginNode loop, FrameState initialState) {
            return ReentrantNodeIterator.processLoop(this, (LoopBeginNode)loop, initialState).exitStates;
        }
    }
}

