/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MemoryMapControlSinkNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.cfg.HIRLoop;
import jdk.graal.compiler.nodes.memory.AddressableMemoryAccess;
import jdk.graal.compiler.nodes.memory.FloatableAccessNode;
import jdk.graal.compiler.nodes.memory.FloatingAccessNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryAnchorNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryMap;
import jdk.graal.compiler.nodes.memory.MemoryMapNode;
import jdk.graal.compiler.nodes.memory.MemoryPhiNode;
import jdk.graal.compiler.nodes.memory.MultiMemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.RecursivePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.graal.compiler.phases.graph.ReentrantNodeIterator;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.word.LocationIdentity;

public class FloatingReadPhase
extends PostRunCanonicalizationPhase<CoreProviders>
implements RecursivePhase {
    private final boolean createMemoryMapNodes;

    public FloatingReadPhase(CanonicalizerPhase canonicalizer) {
        this(false, canonicalizer);
    }

    public FloatingReadPhase(boolean createMemoryMapNodes, CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
        this.createMemoryMapNodes = createMemoryMapNodes;
    }

    @Override
    public float codeSizeIncrease() {
        return 1.5f;
    }

    private static EconomicSet<Node> removeExternallyUsedNodes(EconomicSet<Node> set) {
        boolean change;
        do {
            change = false;
            Iterator iter = set.iterator();
            block1: while (iter.hasNext()) {
                Node node = (Node)iter.next();
                for (Node usage : node.usages()) {
                    if (set.contains((Object)usage)) continue;
                    change = true;
                    iter.remove();
                    continue block1;
                }
            }
        } while (change);
        return set;
    }

    protected void processNode(FixedNode node, EconomicSet<LocationIdentity> currentState) {
        if (MemoryKill.isSingleMemoryKill(node)) {
            FloatingReadPhase.processIdentity(currentState, ((SingleMemoryKill)((Object)node)).getKilledLocationIdentity());
        } else if (MemoryKill.isMemoryKill(node)) {
            for (LocationIdentity identity : ((MultiMemoryKill)((Object)node)).getKilledLocationIdentities()) {
                FloatingReadPhase.processIdentity(currentState, identity);
            }
        }
    }

    private static void processIdentity(EconomicSet<LocationIdentity> currentState, LocationIdentity identity) {
        if (identity.isMutable()) {
            currentState.add((Object)identity);
        }
    }

    protected void processBlock(HIRBlock b, EconomicSet<LocationIdentity> currentState) {
        for (FixedNode n : b.getNodes()) {
            this.processNode(n, currentState);
        }
    }

    private EconomicSet<LocationIdentity> processLoop(HIRLoop loop, EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>> modifiedInLoops) {
        LoopBeginNode loopBegin = (LoopBeginNode)((HIRBlock)loop.getHeader()).getBeginNode();
        EconomicSet result = (EconomicSet)modifiedInLoops.get((Object)loopBegin);
        if (result != null) {
            return result;
        }
        result = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (CFGLoop inner : loop.getChildren()) {
            result.addAll(this.processLoop((HIRLoop)inner, modifiedInLoops));
        }
        for (HIRBlock b : loop.getBlocks()) {
            if (b.getLoop() != loop) continue;
            this.processBlock(b, (EconomicSet<LocationIdentity>)result);
        }
        modifiedInLoops.put((Object)loopBegin, (Object)result);
        return result;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.FLOATING_READS, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.HIGH_TIER_LOWERING, graphState), BasePhase.NotApplicable.when(graphState.getGuardsStage().areFrameStatesAtDeopts(), "This phase must run before FSA"));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        EconomicSet initMemory = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        EconomicMap modifiedInLoops = null;
        if (graph.hasLoops()) {
            modifiedInLoops = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            ControlFlowGraph cfg = ControlFlowGraph.newBuilder(graph).connectBlocks(true).computeLoops(true).computeFrequency(true).build();
            for (CFGLoop<HIRBlock> l : cfg.getLoops()) {
                HIRLoop loop = (HIRLoop)l;
                this.processLoop(loop, (EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>>)modifiedInLoops);
            }
        }
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener(EnumSet.of(Graph.NodeEvent.NODE_ADDED, Graph.NodeEvent.ZERO_USAGES));
        try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
            ReentrantNodeIterator.apply(new FloatingReadClosure((EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>>)modifiedInLoops, true, this.createMemoryMapNodes, (EconomicSet<ValueNode>)initMemory), graph.start(), new MemoryMapImpl(graph.start()));
        }
        for (Node n : FloatingReadPhase.removeExternallyUsedNodes(listener.getNodes())) {
            if (!n.isAlive() || !(n instanceof FloatingNode)) continue;
            n.replaceAtUsages(null);
            GraphUtil.killWithUnusedFloatingInputs(n);
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.FLOATING_READS);
    }

    public static MemoryMapImpl mergeMemoryMaps(AbstractMergeNode merge, List<? extends MemoryMap> states) {
        MemoryMapImpl newState = new MemoryMapImpl();
        EconomicSet keys = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (MemoryMap memoryMap : states) {
            keys.addAll(memoryMap.getLocations());
        }
        assert (FloatingReadPhase.checkNoImmutableLocations((EconomicSet<LocationIdentity>)keys));
        try (DebugCloseable position = merge.withNodeSourcePosition();){
            for (LocationIdentity key : keys) {
                int mergedStatesCount = 0;
                boolean isPhi = false;
                MemoryKill merged = null;
                for (MemoryMap memoryMap : states) {
                    MemoryKill last = memoryMap.getLastLocationAccess(key);
                    if (isPhi) {
                        ((MemoryPhiNode)merged).addInput(ValueNodeInterface.asNode(last));
                    } else if (merged != last) {
                        if (merged == null) {
                            merged = last;
                        } else {
                            MemoryPhiNode phi = merge.graph().addWithoutUnique(new MemoryPhiNode(merge, key));
                            for (int j = 0; j < mergedStatesCount; ++j) {
                                phi.addInput(ValueNodeInterface.asNode(merged));
                            }
                            phi.addInput(ValueNodeInterface.asNode(last));
                            merged = phi;
                            isPhi = true;
                        }
                    }
                    ++mergedStatesCount;
                }
                newState.getMap().put((Object)key, merged);
            }
        }
        return newState;
    }

    private static boolean checkNoImmutableLocations(EconomicSet<LocationIdentity> keys) {
        keys.forEach(t -> {
            assert (t.isMutable());
        });
        return true;
    }

    public static class FloatingReadClosure
    extends ReentrantNodeIterator.NodeIteratorClosure<MemoryMapImpl> {
        private final EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>> modifiedInLoops;
        private boolean createFloatingReads;
        private boolean createMemoryMapNodes;
        private final EconomicSet<ValueNode> initMemory;

        public FloatingReadClosure(EconomicMap<LoopBeginNode, EconomicSet<LocationIdentity>> modifiedInLoops, boolean createFloatingReads, boolean createMemoryMapNodes, EconomicSet<ValueNode> initMemory) {
            this.modifiedInLoops = modifiedInLoops;
            this.createFloatingReads = createFloatingReads;
            this.createMemoryMapNodes = createMemoryMapNodes;
            this.initMemory = initMemory;
        }

        @Override
        protected MemoryMapImpl processNode(FixedNode node, MemoryMapImpl state) {
            if (node instanceof LoopExitNode) {
                LoopExitNode loopExitNode = (LoopExitNode)node;
                EconomicSet modifiedInLoop = (EconomicSet)this.modifiedInLoops.get((Object)loopExitNode.loopBegin());
                boolean anyModified = modifiedInLoop.contains((Object)LocationIdentity.any());
                state.getMap().replaceAll((locationIdentity, memoryNode) -> anyModified || modifiedInLoop.contains(locationIdentity) ? ProxyNode.forMemory(memoryNode, loopExitNode, locationIdentity) : memoryNode);
            }
            if (node instanceof MemoryAnchorNode) {
                FloatingReadClosure.processAnchor((MemoryAnchorNode)node, state);
                return state;
            }
            if (node instanceof MemoryAccess) {
                FloatingReadClosure.processAccess((MemoryAccess)((Object)node), state);
            }
            if (this.createFloatingReads && node instanceof FloatableAccessNode) {
                this.processFloatable((FloatableAccessNode)node, state);
            }
            if (MemoryKill.isSingleMemoryKill(node)) {
                assert (!MemoryKill.isMultiMemoryKill(node)) : "Node cannot be single and multi kill concurrently " + String.valueOf(node);
                this.processCheckpoint((SingleMemoryKill)((Object)node), state);
            } else if (MemoryKill.isMultiMemoryKill(node)) {
                this.processCheckpoint((MultiMemoryKill)((Object)node), state);
            } else assert (!MemoryKill.isMemoryKill(node)) : "Node must be single or multi kill " + String.valueOf(node);
            if (this.createMemoryMapNodes && node instanceof MemoryMapControlSinkNode) {
                try (DebugCloseable position = node.withNodeSourcePosition();){
                    ((MemoryMapControlSinkNode)node).setMemoryMap(node.graph().unique(new MemoryMapNode(state.getMap())));
                }
            }
            return state;
        }

        private static void processAnchor(MemoryAnchorNode anchor, MemoryMapImpl state) {
            for (Node node : anchor.usages().snapshot()) {
                MemoryAccess access;
                if (!(node instanceof MemoryAccess) || (access = (MemoryAccess)((Object)node)).getLastLocationAccess() != anchor) continue;
                MemoryKill lastLocationAccess = state.getLastLocationAccess(access.getLocationIdentity());
                assert (lastLocationAccess != null);
                access.setLastLocationAccess(lastLocationAccess);
            }
            if (anchor.hasNoUsages()) {
                anchor.graph().removeFixed(anchor);
            }
        }

        private static void processAccess(MemoryAccess access, MemoryMapImpl state) {
            LocationIdentity locationIdentity = access.getLocationIdentity();
            if (!locationIdentity.equals(LocationIdentity.any()) && locationIdentity.isMutable()) {
                MemoryKill lastLocationAccess = state.getLastLocationAccess(locationIdentity);
                access.setLastLocationAccess(lastLocationAccess);
            }
        }

        private void processCheckpoint(SingleMemoryKill checkpoint, MemoryMapImpl state) {
            this.processIdentity(checkpoint.getKilledLocationIdentity(), checkpoint, state);
        }

        private void processCheckpoint(MultiMemoryKill checkpoint, MemoryMapImpl state) {
            for (LocationIdentity identity : checkpoint.getKilledLocationIdentities()) {
                this.processIdentity(identity, checkpoint, state);
            }
        }

        private void processIdentity(LocationIdentity identity, MemoryKill checkpoint, MemoryMapImpl state) {
            if (identity.isAny()) {
                state.getMap().clear();
            }
            if (identity.isMutable()) {
                state.getMap().put((Object)identity, (Object)checkpoint);
            }
            if (checkpoint instanceof AddressableMemoryAccess) {
                AddressNode address = ((AddressableMemoryAccess)((Object)checkpoint)).getAddress();
                if (identity.equals(LocationIdentity.init())) {
                    this.initMemory.add((Object)address.getBase());
                }
            }
        }

        private void processFloatable(FloatableAccessNode accessNode, MemoryMapImpl state) {
            StructuredGraph graph = accessNode.graph();
            LocationIdentity locationIdentity = accessNode.getLocationIdentity();
            if (accessNode.canFloat()) {
                GraalError.guarantee(!this.initMemory.contains((Object)accessNode.getAddress().getBase()), "base used for init cannot be used for other accesses: %s", (Object)accessNode);
                assert (!accessNode.getUsedAsNullCheck());
                MemoryKill lastLocationAccess = state.getLastLocationAccess(locationIdentity);
                try (DebugCloseable position = accessNode.withNodeSourcePosition();){
                    FloatingAccessNode floatingNode = accessNode.asFloatingNode();
                    assert (floatingNode.getLastLocationAccess() == lastLocationAccess) : Assertions.errorMessage(floatingNode, floatingNode.getLastLocationAccess(), lastLocationAccess);
                    graph.replaceFixedWithFloating(accessNode, floatingNode);
                    graph.getOptimizationLog().report(FloatingReadPhase.class, "FixedWithFloatingReplacement", accessNode);
                }
            }
        }

        @Override
        protected MemoryMapImpl merge(AbstractMergeNode merge, List<MemoryMapImpl> states) {
            return FloatingReadPhase.mergeMemoryMaps(merge, states);
        }

        @Override
        protected MemoryMapImpl afterSplit(AbstractBeginNode node, MemoryMapImpl oldState) {
            return new MemoryMapImpl(oldState);
        }

        @Override
        protected EconomicMap<LoopExitNode, MemoryMapImpl> processLoop(LoopBeginNode loop, MemoryMapImpl initialState) {
            EconomicSet modifiedLocations = (EconomicSet)this.modifiedInLoops.get((Object)loop);
            EconomicMap phis = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            if (modifiedLocations.contains((Object)LocationIdentity.any())) {
                modifiedLocations = EconomicSet.create((Equivalence)Equivalence.DEFAULT, (UnmodifiableEconomicSet)modifiedLocations);
                modifiedLocations.addAll(initialState.getMap().getKeys());
            }
            for (LocationIdentity location : modifiedLocations) {
                FloatingReadClosure.createMemoryPhi(loop, initialState, (EconomicMap<LocationIdentity, MemoryPhiNode>)phis, location);
            }
            initialState.getMap().putAll((UnmodifiableEconomicMap)phis);
            ReentrantNodeIterator.LoopInfo<MemoryMapImpl> loopInfo = ReentrantNodeIterator.processLoop(this, loop, initialState);
            MapCursor endStateCursor = loopInfo.endStates.getEntries();
            while (endStateCursor.advance()) {
                int endIndex = loop.phiPredecessorIndex((AbstractEndNode)endStateCursor.getKey());
                MapCursor phiCursor = phis.getEntries();
                while (phiCursor.advance()) {
                    LocationIdentity key = (LocationIdentity)phiCursor.getKey();
                    PhiNode phi = (PhiNode)phiCursor.getValue();
                    phi.initializeValueAt(endIndex, ValueNodeInterface.asNode(((MemoryMapImpl)endStateCursor.getValue()).getLastLocationAccess(key)));
                }
            }
            return loopInfo.exitStates;
        }

        private static void createMemoryPhi(LoopBeginNode loop, MemoryMapImpl initialState, EconomicMap<LocationIdentity, MemoryPhiNode> phis, LocationIdentity location) {
            try (DebugCloseable position = loop.withNodeSourcePosition();){
                MemoryPhiNode phi = loop.graph().addWithoutUnique(new MemoryPhiNode(loop, location));
                phi.addInput(ValueNodeInterface.asNode(initialState.getLastLocationAccess(location)));
                phis.put((Object)location, (Object)phi);
            }
        }
    }

    public static class MemoryMapImpl
    implements MemoryMap {
        private final EconomicMap<LocationIdentity, MemoryKill> lastMemorySnapshot;

        public MemoryMapImpl(MemoryMapImpl memoryMap) {
            this.lastMemorySnapshot = EconomicMap.create((Equivalence)Equivalence.DEFAULT, memoryMap.lastMemorySnapshot);
        }

        public MemoryMapImpl(StartNode start) {
            this();
            this.lastMemorySnapshot.put((Object)LocationIdentity.any(), (Object)start);
        }

        public MemoryMapImpl() {
            this.lastMemorySnapshot = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        }

        @Override
        public MemoryKill getLastLocationAccess(LocationIdentity locationIdentity) {
            if (locationIdentity.isImmutable()) {
                return null;
            }
            MemoryKill lastLocationAccess = (MemoryKill)this.lastMemorySnapshot.get((Object)locationIdentity);
            if (lastLocationAccess == null) {
                lastLocationAccess = (MemoryKill)this.lastMemorySnapshot.get((Object)LocationIdentity.any());
                assert (lastLocationAccess != null);
            }
            return lastLocationAccess;
        }

        @Override
        public Iterable<LocationIdentity> getLocations() {
            return this.lastMemorySnapshot.getKeys();
        }

        public EconomicMap<LocationIdentity, MemoryKill> getMap() {
            return this.lastMemorySnapshot;
        }
    }
}

