/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeFlood;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.Phase;

public class DeadCodeEliminationPhase
extends Phase {
    private final boolean optional;

    public DeadCodeEliminationPhase() {
        this(Optionality.Required);
    }

    public DeadCodeEliminationPhase(Optionality optionality) {
        this.optional = optionality == Optionality.Optional;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    public void run(StructuredGraph graph) {
        int totalMarkedCount;
        if (this.optional && Options.ReduceDCE.getValue(graph.getOptions()).booleanValue()) {
            return;
        }
        NodeFlood flood = graph.createNodeFlood();
        int totalNodeCount = graph.getNodeCount();
        flood.add(graph.start());
        DeadCodeEliminationPhase.iterateSuccessorsAndInputs(flood);
        boolean changed = false;
        for (GuardNode guard : graph.getNodes(GuardNode.TYPE)) {
            if (!flood.isMarked(guard.getAnchor().asNode())) continue;
            flood.add(guard);
            changed = true;
        }
        if (changed) {
            DeadCodeEliminationPhase.iterateSuccessorsAndInputs(flood);
        }
        if (totalNodeCount == (totalMarkedCount = flood.getTotalMarkedCount())) {
            return;
        }
        assert (totalNodeCount > totalMarkedCount) : Assertions.errorMessage(totalNodeCount, totalMarkedCount, flood);
        DeadCodeEliminationPhase.deleteNodes(flood, graph);
    }

    private static void iterateSuccessorsAndInputs(final NodeFlood flood) {
        Node.EdgeVisitor consumer = new Node.EdgeVisitor(){

            @Override
            public Node apply(Node n, Node succOrInput) {
                assert (succOrInput.isAlive()) : "dead successor or input " + String.valueOf(succOrInput) + " in " + String.valueOf(n);
                flood.add(succOrInput);
                return succOrInput;
            }
        };
        for (Node current : flood) {
            if (current instanceof AbstractEndNode) {
                AbstractEndNode end = (AbstractEndNode)current;
                flood.add(end.merge());
                continue;
            }
            current.applySuccessors(consumer);
            current.applyInputs(consumer);
        }
    }

    private static void deleteNodes(final NodeFlood flood, StructuredGraph graph) {
        Node.EdgeVisitor consumer = new Node.EdgeVisitor(){

            @Override
            public Node apply(Node n, Node input) {
                if (input.isAlive() && flood.isMarked(input)) {
                    input.removeUsage(n);
                }
                return input;
            }
        };
        for (Node node : graph.getNodes()) {
            if (flood.isMarked(node)) continue;
            node.markDeleted();
            node.applyInputs(consumer);
            graph.getOptimizationLog().report(5, DeadCodeEliminationPhase.class, "NodeRemoval", node);
        }
    }

    public static enum Optionality {
        Optional,
        Required;

    }

    public static class Options {
        public static final OptionKey<Boolean> ReduceDCE = new OptionKey<Boolean>(true);
    }
}

