/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.ArrayDeque;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.BinaryOpLogicNode;
import jdk.graal.compiler.nodes.DeoptimizingGuard;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.UnaryOpLogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.Pair;

public class ConditionalEliminationUtil {
    public static Stamp getSafeStamp(ValueNode x) {
        return x.stamp(NodeView.DEFAULT);
    }

    public static Stamp getOtherSafeStamp(ValueNode x) {
        if (x.isConstant() || x.graph().isAfterStage(GraphState.StageFlag.FIXED_READS)) {
            return x.stamp(NodeView.DEFAULT);
        }
        return x.stamp(NodeView.DEFAULT).unrestricted();
    }

    public static Pair<InfoElement, Stamp> recursiveFoldStamp(InfoElementProvider infoElementProvider, Node node) {
        block6: {
            block5: {
                if (!(node instanceof UnaryNode)) break block5;
                UnaryNode unary = (UnaryNode)node;
                ValueNode value = unary.getValue();
                InfoElement infoElement = infoElementProvider.infoElements(value);
                while (infoElement != null) {
                    Stamp result = unary.foldStamp(infoElement.getStamp());
                    if (result != null) {
                        return Pair.create((Object)infoElement, (Object)result);
                    }
                    infoElement = infoElementProvider.nextElement(infoElement);
                }
                break block6;
            }
            if (!(node instanceof BinaryNode)) break block6;
            BinaryNode binary = (BinaryNode)node;
            ValueNode y = binary.getY();
            ValueNode x = binary.getX();
            if (y.isConstant()) {
                InfoElement infoElement = infoElementProvider.infoElements(x);
                while (infoElement != null) {
                    Stamp result = binary.foldStamp(infoElement.getStamp(), y.stamp(NodeView.DEFAULT));
                    if (result != null) {
                        return Pair.create((Object)infoElement, (Object)result);
                    }
                    infoElement = infoElementProvider.nextElement(infoElement);
                }
            }
        }
        return null;
    }

    public static Pair<InfoElement, Stamp> recursiveFoldStampFromInfo(InfoElementProvider infoElementProvider, Node node) {
        return ConditionalEliminationUtil.recursiveFoldStamp(infoElementProvider, node);
    }

    public static boolean rewireGuards(GuardingNode guard, boolean result, ValueNode proxifiedInput, Stamp guardedValueStamp, GuardRewirer rewireGuardFunction) {
        return rewireGuardFunction.rewire(guard, result, guardedValueStamp, proxifiedInput);
    }

    public static boolean tryProveGuardCondition(InfoElementProvider infoElementProvider, ArrayDeque<GuardedCondition> conditions, GuardFolding guardFolding, DeoptimizingGuard thisGuard, LogicNode node, GuardRewirer rewireGuardFunction) {
        InfoElement infoElement = infoElementProvider.infoElements(node);
        while (infoElement != null) {
            Stamp stamp = infoElement.getStamp();
            JavaConstant constant = (JavaConstant)stamp.asConstant();
            if (constant != null) {
                return ConditionalEliminationUtil.rewireGuards(infoElement.getGuard(), constant.asBoolean(), null, null, rewireGuardFunction);
            }
            infoElement = infoElementProvider.nextElement(infoElement);
        }
        for (GuardedCondition guardedCondition : conditions) {
            TriState result2 = guardedCondition.getCondition().implies(guardedCondition.isNegated(), node);
            if (!result2.isKnown()) continue;
            return ConditionalEliminationUtil.rewireGuards(guardedCondition.getGuard(), result2.toBoolean(), null, null, rewireGuardFunction);
        }
        if (node instanceof UnaryOpLogicNode) {
            Stamp newStamp;
            TriState result3;
            UnaryOpLogicNode unaryLogicNode = (UnaryOpLogicNode)node;
            ValueNode value = unaryLogicNode.getValue();
            infoElement = infoElementProvider.infoElements(value);
            while (infoElement != null) {
                Stamp stamp = infoElement.getStamp();
                result3 = unaryLogicNode.tryFold(stamp);
                if (result3.isKnown()) {
                    return ConditionalEliminationUtil.rewireGuards(infoElement.getGuard(), result3.toBoolean(), infoElement.getProxifiedInput(), infoElement.getStamp(), rewireGuardFunction);
                }
                infoElement = infoElementProvider.nextElement(infoElement);
            }
            Pair<InfoElement, Stamp> foldResult = ConditionalEliminationUtil.recursiveFoldStampFromInfo(infoElementProvider, value);
            if (foldResult != null && (result3 = unaryLogicNode.tryFold((Stamp)foldResult.getRight())).isKnown()) {
                return ConditionalEliminationUtil.rewireGuards(((InfoElement)foldResult.getLeft()).getGuard(), result3.toBoolean(), ((InfoElement)foldResult.getLeft()).getProxifiedInput(), (Stamp)foldResult.getRight(), rewireGuardFunction);
            }
            if (thisGuard != null && guardFolding != null && (newStamp = unaryLogicNode.getSucceedingStampForValue(thisGuard.isNegated())) != null && guardFolding.foldGuard(thisGuard, value, newStamp, rewireGuardFunction)) {
                return true;
            }
        } else if (node instanceof BinaryOpLogicNode) {
            AndNode and;
            BinaryArithmeticNode binary;
            TriState result4;
            BinaryOpLogicNode binaryOpLogicNode = (BinaryOpLogicNode)node;
            ValueNode x = binaryOpLogicNode.getX();
            ValueNode y = binaryOpLogicNode.getY();
            infoElement = infoElementProvider.infoElements(x);
            while (infoElement != null) {
                result4 = binaryOpLogicNode.tryFold(infoElement.getStamp(), y.stamp(NodeView.DEFAULT));
                if (result4.isKnown()) {
                    return ConditionalEliminationUtil.rewireGuards(infoElement.getGuard(), result4.toBoolean(), infoElement.getProxifiedInput(), infoElement.getStamp(), rewireGuardFunction);
                }
                infoElement = infoElementProvider.nextElement(infoElement);
            }
            if (y.isConstant()) {
                TriState result5;
                Pair<InfoElement, Stamp> foldResult = ConditionalEliminationUtil.recursiveFoldStampFromInfo(infoElementProvider, x);
                if (foldResult != null && (result5 = binaryOpLogicNode.tryFold((Stamp)foldResult.getRight(), y.stamp(NodeView.DEFAULT))).isKnown()) {
                    return ConditionalEliminationUtil.rewireGuards(((InfoElement)foldResult.getLeft()).getGuard(), result5.toBoolean(), ((InfoElement)foldResult.getLeft()).getProxifiedInput(), (Stamp)foldResult.getRight(), rewireGuardFunction);
                }
            } else {
                infoElement = infoElementProvider.infoElements(y);
                while (infoElement != null) {
                    result4 = binaryOpLogicNode.tryFold(x.stamp(NodeView.DEFAULT), infoElement.getStamp());
                    if (result4.isKnown()) {
                        return ConditionalEliminationUtil.rewireGuards(infoElement.getGuard(), result4.toBoolean(), infoElement.getProxifiedInput(), infoElement.getStamp(), rewireGuardFunction);
                    }
                    infoElement = infoElementProvider.nextElement(infoElement);
                }
            }
            if (x instanceof BinaryArithmeticNode && y.isConstant() && (binary = (BinaryArithmeticNode)x).getY().isConstant()) {
                infoElement = infoElementProvider.infoElements(binary.getX());
                while (infoElement != null) {
                    Stamp newStampX = binary.foldStamp(infoElement.getStamp(), binary.getY().stamp(NodeView.DEFAULT));
                    TriState result6 = binaryOpLogicNode.tryFold(newStampX, y.stamp(NodeView.DEFAULT));
                    if (result6.isKnown()) {
                        return ConditionalEliminationUtil.rewireGuards(infoElement.getGuard(), result6.toBoolean(), infoElement.getProxifiedInput(), newStampX, rewireGuardFunction);
                    }
                    infoElement = infoElementProvider.nextElement(infoElement);
                }
            }
            if (thisGuard != null && guardFolding != null && binaryOpLogicNode instanceof IntegerEqualsNode && !thisGuard.isNegated() && y.isConstant() && x instanceof AndNode && (and = (AndNode)x).getY() == y) {
                ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> op = ArithmeticOpTable.forStamp(x.stamp(NodeView.DEFAULT)).getOr();
                IntegerStamp newStampX = (IntegerStamp)op.foldStamp(ConditionalEliminationUtil.getSafeStamp(and.getX()), ConditionalEliminationUtil.getOtherSafeStamp(y));
                if (guardFolding.foldGuard(thisGuard, and.getX(), newStampX, rewireGuardFunction)) {
                    return true;
                }
            }
            if (thisGuard != null && guardFolding != null) {
                Stamp newStampY;
                Stamp newStampX;
                if (!x.isConstant() && (newStampX = binaryOpLogicNode.getSucceedingStampForX(thisGuard.isNegated(), ConditionalEliminationUtil.getSafeStamp(x), ConditionalEliminationUtil.getOtherSafeStamp(y))) != null && guardFolding.foldGuard(thisGuard, x, newStampX, rewireGuardFunction)) {
                    return true;
                }
                if (!y.isConstant() && (newStampY = binaryOpLogicNode.getSucceedingStampForY(thisGuard.isNegated(), ConditionalEliminationUtil.getOtherSafeStamp(x), ConditionalEliminationUtil.getSafeStamp(y))) != null && guardFolding.foldGuard(thisGuard, y, newStampY, rewireGuardFunction)) {
                    return true;
                }
            }
        } else if (node instanceof ShortCircuitOrNode) {
            ShortCircuitOrNode shortCircuitOrNode = (ShortCircuitOrNode)node;
            return ConditionalEliminationUtil.tryProveGuardCondition(infoElementProvider, conditions, guardFolding, null, shortCircuitOrNode.getX(), (guard, result, guardedValueStamp, newInput) -> {
                if (result == !shortCircuitOrNode.isXNegated()) {
                    return ConditionalEliminationUtil.rewireGuards(guard, true, newInput, guardedValueStamp, rewireGuardFunction);
                }
                return ConditionalEliminationUtil.tryProveGuardCondition(infoElementProvider, conditions, guardFolding, null, shortCircuitOrNode.getY(), (innerGuard, innerResult, innerGuardedValueStamp, innerNewInput) -> {
                    ValueNode proxifiedInput = newInput;
                    if (proxifiedInput == null) {
                        proxifiedInput = innerNewInput;
                    } else if (innerNewInput != null && innerNewInput != newInput) {
                        return false;
                    }
                    if (innerGuard == guard) {
                        return ConditionalEliminationUtil.rewireGuards(guard, innerResult ^ shortCircuitOrNode.isYNegated(), proxifiedInput, guardedValueStamp, rewireGuardFunction);
                    }
                    return false;
                });
            });
        }
        return false;
    }

    @FunctionalInterface
    public static interface InfoElementProvider {
        public InfoElement infoElements(ValueNode var1);

        default public InfoElement nextElement(InfoElement current) {
            InfoElement parent = current.getParent();
            if (parent != null) {
                return parent;
            }
            ValueNode proxifiedInput = current.getProxifiedInput();
            if (proxifiedInput instanceof PiNode) {
                PiNode piNode = (PiNode)proxifiedInput;
                return this.infoElements(piNode.getOriginalNode());
            }
            return null;
        }
    }

    public static final class InfoElement {
        private final Stamp stamp;
        private final GuardingNode guard;
        private final ValueNode proxifiedInput;
        private final InfoElement parent;

        public InfoElement(Stamp stamp, GuardingNode guard, ValueNode proxifiedInput, InfoElement parent) {
            this.stamp = stamp;
            this.guard = guard;
            this.proxifiedInput = proxifiedInput;
            this.parent = parent;
        }

        public InfoElement getParent() {
            return this.parent;
        }

        public Stamp getStamp() {
            return this.stamp;
        }

        public GuardingNode getGuard() {
            return this.guard;
        }

        public ValueNode getProxifiedInput() {
            return this.proxifiedInput;
        }

        public String toString() {
            return String.valueOf(this.stamp) + " -> " + String.valueOf(this.guard);
        }
    }

    @FunctionalInterface
    public static interface GuardRewirer {
        public boolean rewire(GuardingNode var1, boolean var2, Stamp var3, ValueNode var4);
    }

    public static final class GuardedCondition {
        private final GuardingNode guard;
        private final LogicNode condition;
        private final boolean negated;

        public GuardedCondition(GuardingNode guard, LogicNode condition, boolean negated) {
            this.guard = guard;
            this.condition = condition;
            this.negated = negated;
        }

        public GuardingNode getGuard() {
            return this.guard;
        }

        public LogicNode getCondition() {
            return this.condition;
        }

        public boolean isNegated() {
            return this.negated;
        }
    }

    @FunctionalInterface
    public static interface GuardFolding {
        public boolean foldGuard(DeoptimizingGuard var1, ValueNode var2, Stamp var3, GuardRewirer var4);
    }

    public static class InputFilter
    extends Node.EdgeVisitor {
        boolean ok;
        private ValueNode value;

        InputFilter(ValueNode value) {
            this.value = value;
            this.ok = true;
        }

        @Override
        public Node apply(Node node, Node curNode) {
            if (!this.ok) {
                return curNode;
            }
            if (!(curNode instanceof ValueNode)) {
                this.ok = false;
                return curNode;
            }
            ValueNode curValue = (ValueNode)curNode;
            if (curValue.isConstant() || curValue == this.value || curValue instanceof ParameterNode) {
                return curNode;
            }
            if (curValue instanceof BinaryNode || curValue instanceof UnaryNode) {
                curValue.applyInputs(this);
            } else {
                this.ok = false;
            }
            return curNode;
        }
    }

    public static final class Marks {
        final int infoElementOperations;
        final int conditions;

        public Marks(int infoElementOperations, int conditions) {
            this.infoElementOperations = infoElementOperations;
            this.conditions = conditions;
        }

        public int getInfoElementOperations() {
            return this.infoElementOperations;
        }

        public int getConditions() {
            return this.conditions;
        }
    }
}

