/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;

public class BoxNodeIdentityPhase
extends BasePhase<CoreProviders> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FINAL_PARTIAL_ESCAPE, graphState);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (BoxNode box : graph.getNodes(BoxNode.TYPE)) {
            if (!box.isAlive() || box.hasIdentity() || box.getValue() instanceof BoxNode.TrustedBoxedValue) continue;
            for (Node usage : box.usages()) {
                if (!(usage instanceof ObjectEqualsNode)) continue;
                ObjectEqualsNode eq = (ObjectEqualsNode)usage;
                ValueNode other = eq.getX();
                if (other == box) {
                    other = eq.getY();
                }
                if (!(other instanceof BoxNode)) continue;
                BoxNode otherBox = (BoxNode)other;
                if (box.getValue() != otherBox.getValue()) continue;
                box.setHasIdentity();
                otherBox.setHasIdentity();
            }
        }
    }
}

