/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;

public class BarrierSetVerificationPhase
extends BasePhase<CoreProviders> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.LOW_TIER_LOWERING, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.ADDRESS_LOWERING, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        BarrierSet barrierSet = context.getPlatformConfigurationProvider().getBarrierSet();
        barrierSet.verifyBarriers(graph);
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

