/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.DisableOverflownCountedLoopsPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;

public abstract class AbstractInliningPhase
extends BasePhase<HighTierContext> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.HIGH_TIER_LOWERING, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FINAL_CANONICALIZATION, graphState));
    }

    @Override
    protected final void run(StructuredGraph graph, HighTierContext context) {
        Graph.Mark mark = graph.getMark();
        this.runInlining(graph, context);
        if (!mark.isCurrent() && graph.getSpeculationLog() != null && graph.hasLoops()) {
            new DisableOverflownCountedLoopsPhase().run(graph);
        }
    }

    protected abstract void runInlining(StructuredGraph var1, HighTierContext var2);
}

