/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases;

import java.util.Optional;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;

public class PlaceholderPhase<C>
extends BasePhase<C> {
    private final Class<? extends BasePhase<? super C>> phaseClass;

    public PlaceholderPhase(Class<? extends BasePhase<? super C>> phaseClass) {
        this.phaseClass = phaseClass;
    }

    public Class<? extends BasePhase<? super C>> getPhaseClass() {
        return this.phaseClass;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return Optional.of(new BasePhase.NotApplicable("This is a " + String.valueOf(this.getName()) + " for " + String.valueOf(this.phaseClass)));
    }

    @Override
    public void run(StructuredGraph graph, C context) {
        throw GraalError.shouldNotReachHere(String.valueOf(this.getName()) + " for " + String.valueOf(this.phaseClass) + " should have been replaced in the phase plan before execution.");
    }
}

