/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.options;

import java.util.EnumSet;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicSet;

public class EnumMultiOptionKey<T extends Enum<T>>
extends OptionKey<EconomicSet<T>> {
    private final Class<T> enumClass;

    public EnumMultiOptionKey(Class<T> enumClass, EconomicSet<T> defaultValue) {
        super(defaultValue);
        this.enumClass = enumClass;
    }

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    public EnumSet<T> getAllValues() {
        return EnumSet.allOf(this.enumClass);
    }

    public Object valueOf(String name) {
        String[] names;
        EconomicSet value = EconomicSet.create();
        if (name.isEmpty()) {
            return value;
        }
        for (String splitName : names = name.split(",")) {
            try {
                value.add(Enum.valueOf(this.enumClass, splitName));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("\"" + splitName + "\" is not a valid option for " + this.getName() + ". Valid values are " + String.valueOf(this.getAllValues()));
            }
        }
        return value;
    }
}

