/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.virtual;

import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.LockState;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public abstract class VirtualObjectNode
extends ValueNode
implements LIRLowerable,
IterableNodeType {
    public static final NodeClass<VirtualObjectNode> TYPE = NodeClass.create(VirtualObjectNode.class);
    protected boolean hasIdentity;
    private int objectId = -1;

    protected VirtualObjectNode(NodeClass<? extends VirtualObjectNode> c, ResolvedJavaType type, boolean hasIdentity) {
        super(c, StampFactory.objectNonNull(TypeReference.createExactTrusted(type)));
        this.hasIdentity = hasIdentity;
    }

    public final int getObjectId() {
        return this.objectId;
    }

    public final void resetObjectId() {
        this.objectId = -1;
    }

    public final void setObjectId(int objectId) {
        assert (objectId != -1);
        this.objectId = objectId;
    }

    @Override
    protected void afterClone(Node other) {
        super.afterClone(other);
        this.resetObjectId();
    }

    public abstract ResolvedJavaType type();

    public abstract int entryCount();

    public abstract String entryName(int var1);

    public abstract int entryIndexForOffset(MetaAccessProvider var1, long var2, JavaKind var4);

    public abstract JavaKind entryKind(MetaAccessExtensionProvider var1, int var2);

    public abstract VirtualObjectNode duplicate();

    public boolean hasIdentity() {
        return this.hasIdentity;
    }

    public void setIdentity(boolean identity) {
        this.hasIdentity = identity;
    }

    public abstract ValueNode getMaterializedRepresentation(FixedNode var1, ValueNode[] var2, LockState var3);

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    public boolean canVirtualizeLargeByteArrayUnsafeRead(ValueNode entry, int index, JavaKind accessKind, VirtualizerTool tool) {
        return (tool.canVirtualizeLargeByteArrayUnsafeAccess() || accessKind == JavaKind.Byte) && !entry.isIllegalConstant() && entry.getStackKind() == accessKind.getStackKind() && this.isVirtualByteArrayAccess(tool.getMetaAccessExtensionProvider(), accessKind) && accessKind.getByteCount() == ((VirtualArrayNode)this).byteArrayEntryByteCount(index, tool);
    }

    public boolean isVirtualByteArrayAccess(MetaAccessExtensionProvider metaAccessExtensionProvider, JavaKind accessKind) {
        return accessKind.isPrimitive() && this.isVirtualByteArray(metaAccessExtensionProvider);
    }

    public boolean isVirtualByteArray(MetaAccessExtensionProvider metaAccessExtensionProvider) {
        return this.isVirtualArray() && this.entryCount() > 0 && this.entryKind(metaAccessExtensionProvider, 0) == JavaKind.Byte;
    }

    private boolean isVirtualArray() {
        return this instanceof VirtualArrayNode;
    }
}

