/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.util;

import java.nio.ByteOrder;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ConstantReflectionUtil {
    private ConstantReflectionUtil() {
    }

    public static boolean isStableJavaArray(ValueNode array) {
        return array.isJavaConstant() && ((ConstantNode)array).getStableDimension() > 0;
    }

    public static int[] loadIntArrayConstant(ConstantReflectionProvider crp, JavaConstant targetArg, int maxLength) {
        int targetArgLength = Integer.min(maxLength, crp.readArrayLength(targetArg));
        int[] targetCharArray = new int[targetArgLength];
        for (int i = 0; i < targetArgLength; ++i) {
            targetCharArray[i] = (char)crp.readArrayElement(targetArg, i).asInt();
        }
        return targetCharArray;
    }

    public static boolean shouldConstantFoldArrayOperation(CanonicalizerTool tool, int arrayLength) {
        return arrayLength < GraalOptions.StringIndexOfConstantLimit.getValue(tool.getOptions());
    }

    public static boolean boundsCheckTypePunned(long typePunnedOffset, int typePunnedLength, Stride typePunnedStride, int arrayLength, JavaKind arrayKind) {
        long byteOffset = typePunnedOffset * (long)typePunnedStride.value;
        long byteLength = (long)typePunnedLength * (long)typePunnedStride.value;
        long arrayByteLength = (long)arrayLength * (long)arrayKind.getByteCount();
        return Long.compareUnsigned(byteOffset + byteLength, arrayByteLength) <= 0 && byteOffset >= 0L && byteLength >= 0L;
    }

    public static int readTypePunned(ConstantReflectionProvider provider, JavaConstant array, JavaKind arrayKind, Stride stride, int index) {
        assert (arrayKind == JavaKind.Byte || arrayKind == JavaKind.Char || arrayKind == JavaKind.Int) : arrayKind;
        assert (stride.value <= 4) : stride.value;
        assert (stride.value >= arrayKind.getByteCount()) : Assertions.errorMessageContext("stride.val", stride.value, "arrayKind", arrayKind);
        if (arrayKind == JavaKind.Byte) {
            int i = index * stride.value;
            if (stride == Stride.S1) {
                return provider.readArrayElement(array, i).asInt() & 0xFF;
            }
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                if (stride == Stride.S2) {
                    return provider.readArrayElement(array, i).asInt() & 0xFF | (provider.readArrayElement(array, i + 1).asInt() & 0xFF) << 8;
                }
                return provider.readArrayElement(array, i).asInt() & 0xFF | (provider.readArrayElement(array, i + 1).asInt() & 0xFF) << 8 | (provider.readArrayElement(array, i + 2).asInt() & 0xFF) << 16 | (provider.readArrayElement(array, i + 3).asInt() & 0xFF) << 24;
            }
            if (stride == Stride.S2) {
                return provider.readArrayElement(array, i + 1).asInt() & 0xFF | (provider.readArrayElement(array, i).asInt() & 0xFF) << 8;
            }
            return provider.readArrayElement(array, i + 3).asInt() & 0xFF | (provider.readArrayElement(array, i + 2).asInt() & 0xFF) << 8 | (provider.readArrayElement(array, i + 1).asInt() & 0xFF) << 16 | (provider.readArrayElement(array, i).asInt() & 0xFF) << 24;
        }
        if (arrayKind == JavaKind.Char) {
            if (stride == Stride.S2) {
                return provider.readArrayElement(array, index).asInt() & 0xFFFF;
            }
            assert (stride == Stride.S4) : Assertions.errorMessage(new Object[]{stride});
            int i = index * 2;
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                return provider.readArrayElement(array, i).asInt() & 0xFFFF | (provider.readArrayElement(array, i + 1).asInt() & 0xFFFF) << 16;
            }
            return provider.readArrayElement(array, i + 1).asInt() & 0xFFFF | (provider.readArrayElement(array, i).asInt() & 0xFFFF) << 16;
        }
        assert (stride == Stride.S4) : stride;
        return provider.readArrayElement(array, index).asInt();
    }

    public static boolean canFoldReads(CanonicalizerTool tool, ValueNode array, ValueNode offset, Stride stride, int len, ArrayBaseOffsetProvider arrayBaseOffsetProvider) {
        ResolvedJavaType arrayType;
        if (array.isJavaConstant() && ((ConstantNode)array).getStableDimension() >= 1 && offset.isJavaConstant() && (arrayType = array.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess())).isArray()) {
            Integer arrayLength = tool.getConstantReflection().readArrayLength(array.asJavaConstant());
            Integer index = ConstantReflectionUtil.startIndex(tool, array, offset.asJavaConstant(), stride, arrayBaseOffsetProvider);
            return arrayLength != null && index != null && index >= 0 && index + len <= arrayLength;
        }
        return false;
    }

    public static Integer startIndex(CanonicalizerTool tool, ValueNode array, JavaConstant offset, Stride stride, ArrayBaseOffsetProvider arrayBaseOffsetProvider) {
        JavaKind arrayKind = array.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        long elementOffset = offset.asLong() - (long)arrayBaseOffsetProvider.getArrayBaseOffset(tool.getMetaAccess(), array, arrayKind);
        if (elementOffset % (long)stride.value != 0L) {
            return null;
        }
        return (int)(elementOffset / (long)stride.value);
    }

    public static interface ArrayBaseOffsetProvider {
        public int getArrayBaseOffset(MetaAccessProvider var1, ValueNode var2, JavaKind var3);
    }
}

