/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.spi;

import java.util.BitSet;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.debug.Assertions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageInfo;

public class SnippetParameterInfo {
    private final int count;
    private final int constantParametersBits;
    private final int varargsParametersBits;
    private final int nonNullParametersBits;
    String[] names;

    public SnippetParameterInfo(ResolvedJavaMethod method) {
        int offset;
        assert (method.getAnnotation(Snippet.class) != null) : String.valueOf(method) + " must be annotated with @" + Snippet.class.getSimpleName();
        int parameterCount = method.getSignature().getParameterCount(method.hasReceiver());
        if (parameterCount > 32) {
            throw new UnsupportedOperationException("too many arguments");
        }
        this.count = parameterCount;
        int constant = 0;
        int varargs = 0;
        int nonNull = 0;
        for (int i = offset = method.hasReceiver() ? 1 : 0; i < this.count; ++i) {
            int bit = 1 << i;
            if (method.getParameterAnnotation(Snippet.ConstantParameter.class, i - offset) != null) {
                constant |= bit;
            }
            if (method.getParameterAnnotation(Snippet.VarargsParameter.class, i - offset) != null) {
                varargs |= bit;
            }
            if (method.getParameterAnnotation(Snippet.NonNullParameter.class, i - offset) != null) {
                nonNull |= bit;
            }
            assert ((constant & bit) == 0 || (varargs & bit) == 0) : "Parameter cannot be annotated with both @" + Snippet.ConstantParameter.class.getSimpleName() + " and @" + Snippet.VarargsParameter.class.getSimpleName();
        }
        if (method.hasReceiver()) {
            assert ((constant & 1) == 0) : Assertions.errorMessage(constant);
            constant |= 1;
        }
        this.constantParametersBits = constant;
        this.varargsParametersBits = varargs;
        this.nonNullParametersBits = nonNull;
        if (ImageInfo.inImageBuildtimeCode()) {
            this.initNames(method, this.count);
        } else assert (this.initNames(method, this.count));
    }

    public int getParameterCount() {
        return this.count;
    }

    public boolean isConstantParameter(int paramIdx) {
        return (this.constantParametersBits >>> paramIdx & 1) != 0;
    }

    public boolean isVarargsParameter(int paramIdx) {
        return (this.varargsParametersBits >>> paramIdx & 1) != 0;
    }

    public boolean isNonNullParameter(int paramIdx) {
        return (this.nonNullParametersBits >>> paramIdx & 1) != 0;
    }

    public String getParameterName(int paramIdx) {
        if (this.names != null) {
            return this.names[paramIdx];
        }
        return null;
    }

    private boolean initNames(ResolvedJavaMethod method, int parameterCount) {
        block5: {
            int offset;
            block4: {
                ResolvedJavaMethod.Parameter[] params;
                this.names = new String[parameterCount];
                offset = 0;
                if (method.hasReceiver()) {
                    this.names[0] = "this";
                    offset = 1;
                }
                if ((params = method.getParameters()) == null) break block4;
                for (int i = offset; i < this.names.length; ++i) {
                    if (!params[i - offset].isNamePresent()) continue;
                    this.names[i] = params[i - offset].getName();
                }
                break block5;
            }
            int slotIdx = offset;
            LocalVariableTable localVariableTable = method.getLocalVariableTable();
            if (localVariableTable == null) break block5;
            for (int i = offset; i < this.names.length; ++i) {
                Local local = localVariableTable.getLocal(slotIdx, 0);
                if (local != null) {
                    this.names[i] = local.getName();
                }
                JavaKind kind = method.getSignature().getParameterKind(i - offset);
                slotIdx += kind.getSlotCount();
            }
        }
        return true;
    }

    public void clearNames() {
        this.names = null;
    }

    public static BitSet getNonNullParameters(SnippetParameterInfo info) {
        BitSet nonNullParameters = new BitSet(info.getParameterCount());
        for (int i = 0; i < info.getParameterCount(); ++i) {
            if (!info.isNonNullParameter(i)) continue;
            nonNullParameters.set(i);
        }
        return nonNullParameters;
    }
}

