/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.BarrierSetLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.lir.gen.WriteBarrierSetLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.gc.WriteBarrierNode;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.memory.AbstractWriteNode;
import jdk.graal.compiler.nodes.memory.LIRLowerableAccess;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Write#{p#location/s}")
public class WriteNode
extends AbstractWriteNode
implements LIRLowerableAccess,
Simplifiable,
Node.IndirectInputChangedCanonicalization,
Node.InputsChangedCanonicalization {
    public static final NodeClass<WriteNode> TYPE = NodeClass.create(WriteNode.class);
    private final LocationIdentity killedLocationIdentity;
    private MemoryOrderMode memoryOrder;

    public WriteNode(AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        this(TYPE, address, location, location, value, barrierType, memoryOrder);
    }

    protected WriteNode(NodeClass<? extends WriteNode> c, AddressNode address, LocationIdentity location, LocationIdentity killedLocationIdentity, ValueNode value, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(c, address, location, value, barrierType);
        assert (barrierType == BarrierType.NONE || barrierType == BarrierType.ARRAY || barrierType == BarrierType.FIELD || barrierType == BarrierType.UNKNOWN || barrierType == BarrierType.POST_INIT_WRITE || barrierType == BarrierType.AS_NO_KEEPALIVE_WRITE) : barrierType;
        this.killedLocationIdentity = killedLocationIdentity;
        this.memoryOrder = memoryOrder;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        BarrierSetLIRGeneratorTool barrierSetLIRGeneratorTool;
        WriteBarrierSetLIRGeneratorTool barrierSet = null;
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        if (this.getBarrierType() != BarrierType.NONE && (barrierSetLIRGeneratorTool = tool.getBarrierSet()) instanceof WriteBarrierSetLIRGeneratorTool) {
            WriteBarrierSetLIRGeneratorTool bs;
            barrierSet = bs = (WriteBarrierSetLIRGeneratorTool)barrierSetLIRGeneratorTool;
        }
        LIRKind writeKind = tool.getLIRKind(this.value().stamp(NodeView.DEFAULT));
        Value writeValue = gen.operand(this.value());
        if (barrierSet != null) {
            barrierSet.emitStore(tool, writeKind, this.getBarrierType(), gen.operand(this.getAddress()), writeValue, gen.state(this), this.memoryOrder, this.getLocationIdentity());
        } else {
            tool.getArithmetic().emitStore(writeKind, gen.operand(this.getAddress()), writeValue, gen.state(this), this.memoryOrder);
        }
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.value().stamp(view);
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    @Override
    public boolean hasSideEffect() {
        if (this.ordersMemoryAccesses()) {
            return true;
        }
        if (this.getLocationIdentity().equals(LocationIdentity.INIT_LOCATION)) {
            return false;
        }
        return super.hasSideEffect();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return this.killedLocationIdentity;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (!this.ordersMemoryAccesses()) {
            if (tool.canonicalizeReads() && this.hasExactlyOneUsage() && this.next() instanceof WriteNode) {
                WriteNode write = (WriteNode)this.next();
                if (write.lastLocationAccess == this && write.getAddress() == this.getAddress() && this.getAccessStamp(NodeView.DEFAULT).isCompatible(write.getAccessStamp(NodeView.DEFAULT))) {
                    write.setLastLocationAccess(this.getLastLocationAccess());
                    tool.addToWorkList(this.inputs());
                    tool.addToWorkList(this.next());
                    tool.addToWorkList(this.predecessor());
                    this.graph().removeFixed(this);
                }
            }
            if (this.value() instanceof ReinterpretNode) {
                tool.addToWorkList(this.value());
                tool.addToWorkList(((ReinterpretNode)this.value()).getValue());
                tool.addToWorkList(this);
                this.setValue(((ReinterpretNode)this.value()).getValue());
            }
        } else if (tool.trySinkWriteFences() && this.getMemoryOrder() == MemoryOrderMode.VOLATILE && WriteNode.followedByVolatileWrite(this)) {
            this.memoryOrder = MemoryOrderMode.RELEASE;
        }
    }

    private static boolean followedByVolatileWrite(FixedWithNextNode start) {
        FixedWithNextNode cur = start;
        while (true) {
            CompilationAlarm.checkProgress(start.graph());
            for (Node usage : cur.usages()) {
                if (usage instanceof MemoryAccess && usage instanceof FixedWithNextNode) continue;
                return false;
            }
            FixedNode nextNode = cur.next();
            while (nextNode instanceof WriteBarrierNode) {
                nextNode = ((WriteBarrierNode)nextNode).next();
            }
            if (!(nextNode instanceof OrderedMemoryAccess) || !(nextNode instanceof AbstractWriteNode) && !(nextNode instanceof AbstractCompareAndSwapNode)) break;
            if (((OrderedMemoryAccess)((Object)nextNode)).getMemoryOrder() == MemoryOrderMode.VOLATILE) {
                return true;
            }
            cur = (FixedWithNextNode)nextNode;
        }
        return false;
    }
}

