/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MemoryProxyNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Phi({i#values}) {p#locationIdentity/s}", allowedUsageTypes={InputType.Memory}, size=NodeSize.SIZE_0)
public final class MemoryPhiNode
extends PhiNode
implements SingleMemoryKill {
    public static final NodeClass<MemoryPhiNode> TYPE = NodeClass.create(MemoryPhiNode.class);
    @Node.Input(value=InputType.Memory)
    NodeInputList<ValueNode> values;
    protected final LocationIdentity locationIdentity;

    public MemoryPhiNode(AbstractMergeNode merge, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.locationIdentity = locationIdentity;
        this.values = new NodeInputList(this);
    }

    public MemoryPhiNode(AbstractMergeNode merge, LocationIdentity locationIdentity, ValueNode[] values) {
        super(TYPE, StampFactory.forVoid(), merge);
        this.locationIdentity = locationIdentity;
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    @Override
    public InputType valueInputType() {
        return InputType.Memory;
    }

    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    protected String valueDescription() {
        return this.locationIdentity.toString();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }

    @Override
    public PhiNode duplicateOn(AbstractMergeNode newMerge) {
        return this.graph().addWithoutUnique(new MemoryPhiNode(newMerge, this.getLocationIdentity()));
    }

    @Override
    public MemoryPhiNode duplicateWithValues(AbstractMergeNode newMerge, ValueNode ... newValues) {
        return new MemoryPhiNode(newMerge, this.getLocationIdentity(), newValues);
    }

    @Override
    public ProxyNode createProxyFor(LoopExitNode lex) {
        return this.graph().addWithoutUnique(new MemoryProxyNode(this, lex, this.getKilledLocationIdentity()));
    }
}

