/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ImplicitNullCheckNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.memory.AddressableMemoryAccess;
import jdk.graal.compiler.nodes.memory.GuardedMemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.OnHeapMemoryAccess;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo
public abstract class FixedAccessNode
extends ImplicitNullCheckNode
implements AddressableMemoryAccess,
GuardedMemoryAccess,
OnHeapMemoryAccess,
IterableNodeType {
    public static final NodeClass<FixedAccessNode> TYPE = NodeClass.create(FixedAccessNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    protected GuardingNode guard;
    @Node.Input(value=InputType.Association)
    AddressNode address;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;
    protected final LocationIdentity location;
    protected boolean usedAsNullCheck;
    protected BarrierType barrierType;

    @Override
    public AddressNode getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(AddressNode address) {
        this.updateUsages(this.address, address);
        this.address = address;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.location;
    }

    public boolean getUsedAsNullCheck() {
        return this.usedAsNullCheck;
    }

    public void setUsedAsNullCheck(boolean check) {
        this.usedAsNullCheck = check;
    }

    protected FixedAccessNode(NodeClass<? extends FixedAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp) {
        this(c, address, location, stamp, BarrierType.NONE);
    }

    protected FixedAccessNode(NodeClass<? extends FixedAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, BarrierType barrierType) {
        this(c, address, location, stamp, null, barrierType, false, null);
    }

    protected FixedAccessNode(NodeClass<? extends FixedAccessNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, BarrierType barrierType, boolean usedAsNullCheck, FrameState stateBefore) {
        super((NodeClass<? extends ImplicitNullCheckNode>)c, stamp, stateBefore);
        this.address = address;
        this.location = location;
        this.guard = guard;
        this.barrierType = barrierType;
        this.usedAsNullCheck = usedAsNullCheck;
    }

    @Override
    public boolean canDeoptimize() {
        return this.usedAsNullCheck;
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface(this.lastLocationAccess, lla);
        this.lastLocationAccess = lla;
    }

    @Override
    public BarrierType getBarrierType() {
        return this.barrierType;
    }
}

