/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import java.util.function.BiFunction;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.FixedBinaryNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.UnsignedDivNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;

public class MathUtil {
    private static boolean isConstantOne(ValueNode v1) {
        return v1.isConstant() && v1.stamp(NodeView.DEFAULT) instanceof IntegerStamp && v1.asJavaConstant().asLong() == 1L;
    }

    private static boolean isConstantZero(ValueNode v1) {
        return v1.isConstant() && v1.stamp(NodeView.DEFAULT) instanceof IntegerStamp && v1.asJavaConstant().asLong() == 0L;
    }

    public static ValueNode add(StructuredGraph graph, ValueNode v1, ValueNode v2) {
        return MathUtil.add(graph, v1, v2, true);
    }

    public static ValueNode add(StructuredGraph graph, ValueNode v1, ValueNode v2, boolean gvn) {
        if (MathUtil.isConstantZero(v1)) {
            return v2;
        }
        if (MathUtil.isConstantZero(v2)) {
            return v1;
        }
        if (gvn) {
            return BinaryArithmeticNode.add(graph, v1, v2, NodeView.DEFAULT);
        }
        return graph.addWithoutUniqueWithInputs(new AddNode(v1, v2));
    }

    public static ValueNode mul(StructuredGraph graph, ValueNode v1, ValueNode v2) {
        return MathUtil.mul(graph, v1, v2, true);
    }

    public static ValueNode mul(StructuredGraph graph, ValueNode v1, ValueNode v2, boolean gvn) {
        if (MathUtil.isConstantOne(v1)) {
            return v2;
        }
        if (MathUtil.isConstantOne(v2)) {
            return v1;
        }
        if (gvn) {
            return BinaryArithmeticNode.mul(graph, v1, v2, NodeView.DEFAULT);
        }
        return graph.addWithoutUniqueWithInputs(new MulNode(v1, v2));
    }

    public static ValueNode sub(StructuredGraph graph, ValueNode v1, ValueNode v2) {
        return MathUtil.sub(graph, v1, v2, true);
    }

    public static ValueNode sub(StructuredGraph graph, ValueNode v1, ValueNode v2, boolean gvn) {
        if (MathUtil.isConstantZero(v2)) {
            return v1;
        }
        if (gvn) {
            return BinaryArithmeticNode.sub(graph, v1, v2, NodeView.DEFAULT);
        }
        return graph.addWithoutUniqueWithInputs(new SubNode(v1, v2));
    }

    public static ValueNode unsignedDivBefore(StructuredGraph graph, boolean neverDivByZero, FixedNode before, ValueNode dividend, ValueNode divisor, GuardingNode zeroCheck) {
        return MathUtil.fixedDivBefore(graph, neverDivByZero, before, dividend, divisor, (dend, sor) -> UnsignedDivNode.create(dend, sor, zeroCheck, NodeView.DEFAULT));
    }

    private static ValueNode fixedDivBefore(StructuredGraph graph, boolean neverDivByZero, FixedNode before, ValueNode dividend, ValueNode divisor, BiFunction<ValueNode, ValueNode, ValueNode> createDiv) {
        if (MathUtil.isConstantOne(divisor)) {
            return dividend;
        }
        ValueNode div = createDiv.apply(dividend, divisor);
        if (div instanceof FixedBinaryNode) {
            FixedBinaryNode binaryPredecessor;
            FixedBinaryNode fixedDiv = (FixedBinaryNode)div;
            if (before.predecessor() instanceof FixedBinaryNode && fixedDiv.dataFlowEquals(binaryPredecessor = (FixedBinaryNode)before.predecessor())) {
                if (fixedDiv.isAlive()) {
                    fixedDiv.safeDelete();
                }
                return binaryPredecessor;
            }
            graph.addBeforeFixed(before, graph.addOrUniqueWithInputs(fixedDiv));
            if (neverDivByZero) {
                ((IntegerDivRemNode)div).setCanDeopt(false);
            }
        }
        return div;
    }
}

