/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.core.common.util.ReversedList;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class LoopsData {
    private final EconomicMap<LoopBeginNode, Loop> loopBeginToEx;
    private final ControlFlowGraph cfg;
    private final List<Loop> loops;

    static LoopsData compute(StructuredGraph graph) {
        return new LoopsData(graph, null);
    }

    static LoopsData compute(ControlFlowGraph cfg) {
        return new LoopsData(cfg.graph, cfg);
    }

    protected LoopsData(ControlFlowGraph cfg, List<Loop> loops, EconomicMap<LoopBeginNode, Loop> loopBeginToEx) {
        this.cfg = cfg;
        this.loops = loops;
        this.loopBeginToEx = loopBeginToEx;
    }

    protected LoopsData(StructuredGraph graph, ControlFlowGraph preComputedCFG) {
        block11: {
            this.loopBeginToEx = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            DebugContext debug = graph.getDebug();
            if (preComputedCFG == null) {
                try (DebugContext.Scope s = debug.scope("ControlFlowGraph");){
                    boolean backendBlocks = graph.isAfterStage(GraphState.StageFlag.FINAL_SCHEDULE);
                    this.cfg = ControlFlowGraph.newBuilder(graph).connectBlocks(true).backendBlocks(backendBlocks).computeLoops(true).computeDominators(true).computePostdominators(true).computeFrequency(true).build();
                    break block11;
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
            }
            this.cfg = preComputedCFG;
        }
        assert (LoopsData.checkLoopOrder(this.cfg.getLoops()));
        this.loops = new ArrayList<Loop>(this.cfg.getLoops().size());
        for (CFGLoop<HIRBlock> loop : this.cfg.getLoops()) {
            Loop ex = new Loop(loop, this);
            this.loops.add(ex);
            this.loopBeginToEx.put((Object)ex.loopBegin(), (Object)ex);
        }
    }

    protected static boolean checkLoopOrder(Iterable<CFGLoop<HIRBlock>> loops) {
        EconomicSet seen = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (CFGLoop<HIRBlock> loop : loops) {
            if (loop.getParent() != null && !seen.contains(loop.getParent())) {
                return false;
            }
            seen.add(loop);
        }
        return true;
    }

    public Loop loop(CFGLoop<HIRBlock> loop) {
        return (Loop)this.loopBeginToEx.get((Object)((LoopBeginNode)loop.getHeader().getBeginNode()));
    }

    public Loop loop(LoopBeginNode loopBegin) {
        return (Loop)this.loopBeginToEx.get((Object)loopBegin);
    }

    public List<Loop> loops() {
        return this.loops;
    }

    public List<Loop> outerFirst() {
        return this.loops;
    }

    public List<Loop> innerFirst() {
        return ReversedList.reversed(this.loops);
    }

    public List<Loop> nonCountedLoops() {
        ArrayList<Loop> nonCounted = new ArrayList<Loop>();
        for (Loop loop : this.loops()) {
            if (loop.isCounted()) continue;
            nonCounted.add(loop);
        }
        return nonCounted;
    }

    public List<Loop> countedLoops() {
        ArrayList<Loop> counted = new ArrayList<Loop>();
        for (Loop loop : this.loops()) {
            if (!loop.isCounted()) continue;
            counted.add(loop);
        }
        return counted;
    }

    public void detectCountedLoops() {
        for (Loop loop : this.loops()) {
            loop.detectCounted();
        }
    }

    public ControlFlowGraph getCFG() {
        return this.cfg;
    }

    public InductionVariable getInductionVariable(ValueNode value) {
        InductionVariable match = null;
        for (Loop loop : this.loops()) {
            InductionVariable iv = (InductionVariable)loop.getInductionVariables().get((Object)value);
            if (iv == null) continue;
            if (match != null) {
                return null;
            }
            match = iv;
        }
        return match;
    }

    public void deleteUnusedNodes() {
        for (Loop loop : this.loops()) {
            loop.deleteUnusedNodes();
        }
    }
}

