/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginStateSplitNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.GuardProxyNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.spi.NodeWithState;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;

public abstract class LoopFragment {
    private final Loop loop;
    private final LoopFragment original;
    protected NodeBitMap nodes;
    protected boolean nodesReady;
    private EconomicMap<Node, Node> duplicationMap;
    protected List<PhiNode> introducedPhis;
    protected List<MergeNode> introducedMerges;

    public LoopFragment(Loop loop) {
        this(loop, null);
        this.nodesReady = true;
    }

    public LoopFragment(Loop loop, LoopFragment original) {
        this.loop = loop;
        this.original = original;
        this.nodesReady = false;
    }

    public Loop loop() {
        return this.loop;
    }

    public abstract LoopFragment duplicate();

    public abstract void insertBefore(Loop var1);

    public boolean contains(Node n) {
        return this.nodes().isMarkedAndGrow(n);
    }

    public UnmodifiableEconomicMap<Node, Node> duplicationMap() {
        return this.duplicationMap;
    }

    public List<PhiNode> getIntroducedPhis() {
        return this.introducedPhis;
    }

    public List<MergeNode> getIntroducedMerges() {
        return this.introducedMerges;
    }

    public <New extends Node, Old extends New> New getDuplicatedNode(Old n) {
        assert (this.isDuplicate());
        return (New)((Node)this.duplicationMap.get(n));
    }

    protected <New extends Node, Old extends New> void putDuplicatedNode(Old oldNode, New newNode) {
        this.duplicationMap.put(oldNode, newNode);
    }

    public EconomicMap<Node, Node> reverseDuplicationMap() {
        EconomicMap reverseDuplicationMap = EconomicMap.create();
        MapCursor cursor = this.duplicationMap.getEntries();
        while (cursor.advance()) {
            reverseDuplicationMap.put((Object)((Node)cursor.getValue()), (Object)((Node)cursor.getKey()));
        }
        return reverseDuplicationMap;
    }

    protected abstract ValueNode prim(ValueNode var1);

    public boolean isDuplicate() {
        return this.original != null;
    }

    public LoopFragment original() {
        return this.original;
    }

    public abstract NodeBitMap nodes();

    public StructuredGraph graph() {
        Loop l = this.isDuplicate() ? this.original().loop() : this.loop();
        return l.loopBegin().graph();
    }

    protected abstract Graph.DuplicationReplacement getDuplicationReplacement();

    protected abstract void beforeDuplication();

    protected void finishDuplication() {
        Loop originalLoopEx = this.original().loop();
        ControlFlowGraph cfg = originalLoopEx.loopsData().getCFG();
        for (LoopExitNode exit : originalLoopEx.loopBegin().loopExits().snapshot()) {
            if (originalLoopEx.getCFGLoop().isLoopExit(cfg.blockFor(exit))) continue;
            exit.removeExit();
        }
    }

    protected void patchNodes(final Graph.DuplicationReplacement dataFix) {
        if (this.isDuplicate() && !this.nodesReady) {
            assert (!this.original.isDuplicate());
            final Graph.DuplicationReplacement cfgFix = this.original().getDuplicationReplacement();
            Graph.DuplicationReplacement dr = cfgFix == null && dataFix != null ? dataFix : (cfgFix != null && dataFix == null ? cfgFix : (cfgFix != null && dataFix != null ? new Graph.DuplicationReplacement(){

                @Override
                public Node replacement(Node o) {
                    Node r1 = dataFix.replacement(o);
                    if (r1 != o) {
                        assert (cfgFix.replacement(o) == o) : Assertions.errorMessage(cfgFix, o, r1);
                        return r1;
                    }
                    Node r2 = cfgFix.replacement(o);
                    if (r2 != o) {
                        return r2;
                    }
                    return o;
                }
            } : null));
            this.beforeDuplication();
            NodeBitMap nodesIterable = this.original().nodes();
            this.duplicationMap = this.graph().addDuplicates((Iterable<? extends Node>)nodesIterable, (Graph)this.graph(), nodesIterable.count(), dr);
            this.finishDuplication();
            this.nodes = new NodeBitMap(this.graph());
            this.nodes.markAll(this.duplicationMap.getValues());
            this.nodesReady = true;
        }
    }

    protected static void computeNodes(NodeBitMap nodes, Graph graph, Loop loop, Iterable<AbstractBeginNode> blocks, Iterable<AbstractBeginNode> earlyExits) {
        for (AbstractBeginNode b : blocks) {
            if (b.isDeleted()) continue;
            for (Node node2 : b.getBlockNodes()) {
                if (node2 instanceof Invoke) {
                    nodes.mark(((Invoke)((Object)node2)).callTarget());
                }
                if (node2 instanceof NodeWithState) {
                    NodeWithState withState = (NodeWithState)((Object)node2);
                    withState.states().forEach(state -> state.applyToVirtual(node -> nodes.mark(node)));
                }
                if (node2 instanceof AbstractMergeNode) {
                    for (PhiNode phiNode : ((AbstractMergeNode)node2).phis()) {
                        nodes.mark(phiNode);
                    }
                }
                nodes.mark(node2);
            }
        }
        for (AbstractBeginNode earlyExit : earlyExits) {
            if (earlyExit.isDeleted()) continue;
            nodes.mark(earlyExit);
            if (!(earlyExit instanceof LoopExitNode)) continue;
            LoopExitNode loopExit = (LoopExitNode)earlyExit;
            FrameState frameState = loopExit.stateAfter();
            if (frameState != null) {
                frameState.applyToVirtual(node -> nodes.mark(node));
            }
            for (ProxyNode proxyNode : loopExit.proxies()) {
                nodes.mark(proxyNode);
            }
        }
        NodeBitMap nonLoopNodes = graph.createNodeBitMap();
        WorkQueue worklist = new WorkQueue(graph);
        for (AbstractBeginNode abstractBeginNode : blocks) {
            if (abstractBeginNode.isDeleted()) continue;
            for (Node node3 : abstractBeginNode.getBlockNodes()) {
                if (node3 instanceof CommitAllocationNode) {
                    for (VirtualObjectNode obj : ((CommitAllocationNode)node3).getVirtualObjects()) {
                        LoopFragment.markFloating(worklist, loop, obj, nodes, nonLoopNodes);
                    }
                }
                if (node3 instanceof MonitorEnterNode) {
                    LoopFragment.markFloating(worklist, loop, ((MonitorEnterNode)node3).getMonitorId(), nodes, nonLoopNodes);
                }
                if (node3 instanceof AbstractMergeNode) {
                    for (PhiNode phi : ((AbstractMergeNode)node3).phis()) {
                        for (Node usage : phi.usages()) {
                            LoopFragment.markFloating(worklist, loop, usage, nodes, nonLoopNodes);
                        }
                    }
                }
                for (Node usage : node3.usages()) {
                    LoopFragment.markFloating(worklist, loop, usage, nodes, nonLoopNodes);
                }
            }
        }
    }

    static TriState isLoopNode(Node n, NodeBitMap loopNodes, NodeBitMap nonLoopNodes) {
        if (loopNodes.isMarked(n)) {
            return TriState.TRUE;
        }
        if (nonLoopNodes.isMarked(n)) {
            return TriState.FALSE;
        }
        if (n instanceof FixedNode || n instanceof PhiNode) {
            return TriState.FALSE;
        }
        return TriState.UNKNOWN;
    }

    private static void pushWorkList(WorkQueue workList, Node node, NodeBitMap loopNodes) {
        WorkListEntry entry = new WorkListEntry(node, loopNodes);
        GraalError.guarantee(!workList.contains(entry), "node %s added to worklist twice", (Object)node);
        workList.push(entry);
    }

    private static void markFloating(WorkQueue workList, Loop loop, Node start, NodeBitMap loopNodes, NodeBitMap nonLoopNodes) {
        if (LoopFragment.isLoopNode(start, loopNodes, nonLoopNodes).isKnown()) {
            return;
        }
        LoopBeginNode loopBeginNode = loop.loopBegin();
        ControlFlowGraph cfg = loop.loopsData().getCFG();
        LoopFragment.pushWorkList(workList, start, loopNodes);
        while (!workList.isEmpty()) {
            GuardNode guard;
            WorkListEntry currentEntry = workList.peek();
            if (currentEntry.usages.hasNext()) {
                Node current = currentEntry.usages.next();
                TriState result = LoopFragment.isLoopNode(current, loopNodes, nonLoopNodes);
                if (result.isKnown()) {
                    if (!result.toBoolean()) continue;
                    currentEntry.isLoopNode = true;
                    continue;
                }
                LoopFragment.pushWorkList(workList, current, loopNodes);
                continue;
            }
            workList.pop();
            boolean isLoopNode = currentEntry.isLoopNode;
            Node current = currentEntry.n;
            if (!isLoopNode && current instanceof GuardNode && !current.hasUsages() && LoopFragment.isLoopNode((guard = (GuardNode)current).getCondition(), loopNodes, nonLoopNodes) != TriState.FALSE) {
                ValueNode anchor = guard.getAnchor().asNode();
                TriState isAnchorInLoop = LoopFragment.isLoopNode(anchor, loopNodes, nonLoopNodes);
                if (isAnchorInLoop != TriState.FALSE) {
                    if (!(anchor instanceof LoopExitNode) || ((LoopExitNode)anchor).loopBegin() != loopBeginNode) {
                        isLoopNode = true;
                    }
                } else if (cfg.blockFor(anchor).strictlyDominates(cfg.blockFor(loopBeginNode))) {
                    isLoopNode = true;
                }
            }
            if (isLoopNode) {
                loopNodes.mark(current);
                for (WorkListEntry e : workList) {
                    e.isLoopNode = true;
                }
                continue;
            }
            nonLoopNodes.mark(current);
        }
    }

    public static NodeIterable<AbstractBeginNode> toHirBlocks(final Iterable<HIRBlock> blocks) {
        return new NodeIterable<AbstractBeginNode>(){

            @Override
            public Iterator<AbstractBeginNode> iterator() {
                final Iterator it = blocks.iterator();
                return new Iterator<AbstractBeginNode>(this){

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public AbstractBeginNode next() {
                        return ((HIRBlock)it.next()).getBeginNode();
                    }

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }
                };
            }
        };
    }

    protected void mergeEarlyExits() {
        assert (this.isDuplicate());
        StructuredGraph graph = this.graph();
        this.introducedPhis = new ArrayList<PhiNode>();
        this.introducedMerges = new ArrayList<MergeNode>();
        for (AbstractBeginNode earlyExit : LoopFragment.toHirBlocks(this.original().loop().getCFGLoop().getLoopExits())) {
            Object earlyLoopExit;
            EndNode newEnd;
            EndNode originalEnd;
            MergeNode merge;
            AbstractBeginNode newEarlyExit;
            FixedNode next = earlyExit.next();
            if (earlyExit.isDeleted() || !this.original().contains(earlyExit) || (newEarlyExit = (AbstractBeginNode)this.getDuplicatedNode(earlyExit)) == null) continue;
            try (DebugCloseable position = earlyExit.withNodeSourcePosition();){
                merge = graph.add(new MergeNode());
                originalEnd = graph.add(new EndNode());
                newEnd = graph.add(new EndNode());
            }
            merge.addForwardEnd(originalEnd);
            merge.addForwardEnd(newEnd);
            earlyExit.setNext(originalEnd);
            newEarlyExit.setNext(newEnd);
            merge.setNext(next);
            this.introducedMerges.add(merge);
            FrameState exitState = null;
            if (earlyExit instanceof LoopExitNode && (exitState = ((BeginStateSplitNode)(earlyLoopExit = (LoopExitNode)earlyExit)).stateAfter()) != null) {
                graph.getDebug().dump(5, (Object)graph, "Before creating states for %s", earlyLoopExit);
                FrameState originalExitState = exitState;
                exitState = exitState.duplicateWithVirtualState();
                ((BeginStateSplitNode)earlyLoopExit).setStateAfter(exitState);
                graph.getDebug().dump(5, graph, "Before creating states for %s for %s and merge gets %s", exitState, earlyLoopExit, originalExitState);
                exitState.applyToVirtual(node -> this.original.nodes.markAndGrow(node));
                merge.setStateAfter(originalExitState.duplicateWithVirtualState());
                if (originalExitState.hasNoUsages()) {
                    GraphUtil.killWithUnusedFloatingInputs(originalExitState, false, unusedInput -> this.original.nodes.clearAndGrow((Node)unusedInput));
                }
            }
            earlyLoopExit = earlyExit.anchored().snapshot().iterator();
            while (earlyLoopExit.hasNext()) {
                Node anchored = (Node)earlyLoopExit.next();
                anchored.replaceFirstInput(earlyExit, merge);
            }
            if (!(earlyExit instanceof LoopExitNode)) continue;
            earlyLoopExit = (LoopExitNode)earlyExit;
            FrameState finalExitState = exitState;
            boolean newEarlyExitIsLoopExit = newEarlyExit instanceof LoopExitNode;
            for (ProxyNode vpn : ((LoopExitNode)earlyLoopExit).proxies().snapshot()) {
                ValueNode replaceWith;
                if (vpn.hasNoUsages()) continue;
                if (vpn.value() == null) {
                    assert (vpn instanceof GuardProxyNode) : Assertions.errorMessage(vpn);
                    vpn.replaceAtUsages(null);
                    continue;
                }
                ValueNode newVpn = this.prim(newEarlyExitIsLoopExit ? vpn : vpn.value());
                if (newVpn != null) {
                    PhiNode phi = vpn.createPhi(merge);
                    phi.setNodeSourcePosition(merge.getNodeSourcePosition());
                    phi.addInput(vpn);
                    phi.addInput(newVpn);
                    phi.inferStamp();
                    this.introducedPhis.add(phi);
                    replaceWith = phi;
                } else {
                    replaceWith = vpn.value();
                }
                vpn.replaceAtMatchingUsages(replaceWith, usage -> {
                    if (merge.isPhiAtMerge(usage)) {
                        return false;
                    }
                    if (usage instanceof VirtualState) {
                        VirtualState stateUsage = (VirtualState)usage;
                        if (finalExitState != null && finalExitState.isPartOfThisState(stateUsage)) {
                            return false;
                        }
                    }
                    return true;
                });
            }
        }
    }

    static class WorkQueue
    implements Iterable<WorkListEntry> {
        Deque<WorkListEntry> worklist = new ArrayDeque<WorkListEntry>();
        NodeBitMap contents;

        WorkQueue(Graph graph) {
            this.contents = new NodeBitMap(graph);
        }

        public void addFirst(WorkListEntry e) {
            this.worklist.addFirst(e);
            GraalError.guarantee(!this.contents.isMarked(e.n), "Trying to addFirst an entry that is already in the work queue!");
            this.contents.mark(e.n);
        }

        public void push(WorkListEntry e) {
            this.worklist.push(e);
            GraalError.guarantee(!this.contents.isMarked(e.n), "Trying to push an entry that is already in the work queue!");
            this.contents.mark(e.n);
        }

        public WorkListEntry peek() {
            return this.worklist.peek();
        }

        public WorkListEntry pop() {
            WorkListEntry e = this.worklist.pop();
            this.contents.clear(e.n);
            return e;
        }

        public boolean isEmpty() {
            return this.worklist.isEmpty();
        }

        public boolean contains(WorkListEntry e) {
            return this.contents.contains(e.n);
        }

        public void clear() {
            this.worklist.clear();
            this.contents.clearAll();
        }

        @Override
        public Iterator<WorkListEntry> iterator() {
            return this.worklist.iterator();
        }
    }

    static class WorkListEntry {
        final Iterator<Node> usages;
        final Node n;
        boolean isLoopNode;

        WorkListEntry(Node n, NodeBitMap loopNodes) {
            this.n = n;
            this.usages = n.usages().iterator();
            this.isLoopNode = loopNodes.isMarked(n);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WorkListEntry)) {
                return false;
            }
            WorkListEntry other = (WorkListEntry)obj;
            return this.n == other.n;
        }

        public int hashCode() {
            return this.n.hashCode();
        }
    }
}

