/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.loop.BasicInductionVariable;
import jdk.graal.compiler.nodes.loop.DerivedInductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;

public abstract class InductionVariable {
    protected final Loop loop;

    public abstract StructuredGraph graph();

    public InductionVariable(Loop loop) {
        this.loop = loop;
    }

    public Loop getLoop() {
        return this.loop;
    }

    public abstract Direction direction();

    public abstract ValueNode valueNode();

    public abstract ValueNode initNode();

    public abstract ValueNode strideNode();

    public abstract boolean isConstantInit();

    public abstract boolean isConstantStride();

    public abstract long constantInit();

    public abstract long constantStride();

    public ValueNode extremumNode() {
        return this.extremumNode(false, this.valueNode().stamp(NodeView.DEFAULT));
    }

    public abstract ValueNode extremumNode(boolean var1, Stamp var2);

    public abstract ValueNode extremumNode(boolean var1, Stamp var2, ValueNode var3);

    public abstract boolean isConstantExtremum();

    public abstract long constantExtremum();

    public abstract ValueNode exitValueNode();

    public abstract void deleteUnusedNodes();

    public boolean isConstantScale(InductionVariable ref) {
        return this == ref;
    }

    public long constantScale(InductionVariable ref) {
        assert (this == ref) : String.valueOf(this) + "!=" + String.valueOf(ref);
        return 1L;
    }

    public boolean offsetIsZero(InductionVariable ref) {
        return this == ref;
    }

    public ValueNode offsetNode(InductionVariable ref) {
        assert (!this.offsetIsZero(ref));
        return null;
    }

    public abstract InductionVariable duplicate();

    public abstract InductionVariable duplicateWithNewInit(ValueNode var1);

    public abstract ValueNode entryTripValue();

    public BasicInductionVariable getRootIV() {
        if (this instanceof BasicInductionVariable) {
            return (BasicInductionVariable)this;
        }
        assert (this instanceof DerivedInductionVariable) : this;
        return ((DerivedInductionVariable)this).getBase().getRootIV();
    }

    public abstract String toString(IVToStringVerbosity var1);

    public String toString() {
        return this.toString(IVToStringVerbosity.NUMERIC);
    }

    public static enum IVToStringVerbosity {
        FULL,
        NUMERIC;

    }

    public static enum Direction {
        Up,
        Down;


        public Direction opposite() {
            switch (this.ordinal()) {
                case 0: {
                    return Down;
                }
                case 1: {
                    return Up;
                }
            }
            throw GraalError.shouldNotReachHereUnexpectedValue((Object)this);
        }
    }
}

