/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;

public abstract class DerivedInductionVariable
extends InductionVariable {
    protected final InductionVariable base;

    public DerivedInductionVariable(Loop loop, InductionVariable base) {
        super(loop);
        this.base = base;
    }

    @Override
    public StructuredGraph graph() {
        return this.base.graph();
    }

    public InductionVariable getBase() {
        CompilationAlarm.checkProgress(this.base.graph());
        return this.base;
    }

    @Override
    public InductionVariable duplicate() {
        InductionVariable newBase = this.base.duplicate();
        return this.copy(newBase, this.copyValue(newBase, false));
    }

    @Override
    public InductionVariable duplicateWithNewInit(ValueNode newInit) {
        InductionVariable newBase = this.base.duplicateWithNewInit(newInit);
        return this.copy(newBase, this.copyValue(newBase, false));
    }

    public abstract ValueNode copyValue(InductionVariable var1);

    public abstract ValueNode copyValue(InductionVariable var1, boolean var2);

    public abstract InductionVariable copy(InductionVariable var1, ValueNode var2);
}

