/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.loop.DerivedInductionVariable;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;

public class DerivedConvertedInductionVariable
extends DerivedInductionVariable {
    protected final Stamp stamp;
    protected final ValueNode value;

    public DerivedConvertedInductionVariable(Loop loop, InductionVariable base, Stamp stamp, ValueNode value) {
        super(loop, base);
        this.stamp = stamp;
        this.value = value;
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public InductionVariable.Direction direction() {
        return this.base.direction();
    }

    @Override
    public ValueNode initNode() {
        return this.op(this.base.initNode(), true);
    }

    @Override
    public ValueNode strideNode() {
        return this.op(this.base.strideNode(), false);
    }

    @Override
    public boolean isConstantInit() {
        return this.base.isConstantInit();
    }

    @Override
    public boolean isConstantStride() {
        return this.base.isConstantStride();
    }

    @Override
    public long constantInit() {
        return this.base.constantInit();
    }

    @Override
    public long constantStride() {
        return this.base.constantStride();
    }

    @Override
    public boolean isConstantExtremum() {
        return this.base.isConstantExtremum();
    }

    @Override
    public long constantExtremum() {
        return this.base.constantExtremum();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp s) {
        return this.base.extremumNode(assumeLoopEntered, s);
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp s, ValueNode maxTripCount) {
        return this.base.extremumNode(assumeLoopEntered, s, maxTripCount);
    }

    @Override
    public ValueNode exitValueNode() {
        return this.op(this.base.exitValueNode(), true);
    }

    @Override
    public void deleteUnusedNodes() {
    }

    public ValueNode op(ValueNode v, boolean allowZeroExtend) {
        return this.op(v, allowZeroExtend, true);
    }

    private ValueNode op(ValueNode v, boolean allowZeroExtend, boolean gvn) {
        boolean zeroExtend = allowZeroExtend && this.value instanceof ZeroExtendNode;
        return IntegerConvertNode.convert(v, this.stamp, zeroExtend, this.graph(), NodeView.DEFAULT, gvn);
    }

    @Override
    public String toString(InductionVariable.IVToStringVerbosity verbosity) {
        if (verbosity == InductionVariable.IVToStringVerbosity.FULL) {
            return String.format("DerivedConvertedInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.stamp);
        }
        return String.format("(%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.stamp);
    }

    @Override
    public InductionVariable copy(InductionVariable newBase, ValueNode newValue) {
        return new DerivedConvertedInductionVariable(this.loop, newBase, this.stamp, newValue);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase) {
        return this.op(newBase.valueNode(), true);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase, boolean gvn) {
        return this.op(newBase.valueNode(), true, gvn);
    }

    @Override
    public ValueNode entryTripValue() {
        return this.op(this.getBase().entryTripValue(), true);
    }
}

