/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.util.UnsignedLong;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.InductionVariableHelper;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.MathUtil;
import jdk.graal.compiler.nodes.util.IntegerHelper;
import jdk.graal.compiler.nodes.util.SignedIntegerHelper;
import jdk.graal.compiler.nodes.util.UnsignedIntegerHelper;
import jdk.graal.compiler.phases.common.util.LoopUtility;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.SpeculationLog;

public class CountedLoopInfo {
    protected final Loop loop;
    protected InductionVariable limitCheckedIV;
    protected ValueNode limit;
    protected boolean isLimitIncluded;
    protected AbstractBeginNode body;
    protected IfNode ifNode;
    protected final boolean unsigned;

    protected CountedLoopInfo(Loop loop, InductionVariable limitCheckedIV, IfNode ifNode, ValueNode limit, boolean isLimitIncluded, AbstractBeginNode body, boolean unsigned) {
        assert (limitCheckedIV.direction() != null);
        this.loop = loop;
        this.limitCheckedIV = limitCheckedIV;
        this.limit = limit;
        this.isLimitIncluded = isLimitIncluded;
        this.body = body;
        this.ifNode = ifNode;
        this.unsigned = unsigned;
    }

    public InductionVariable getLimitCheckedIV() {
        return this.limitCheckedIV;
    }

    protected InductionVariable getBodyIV() {
        assert (!this.isInverted() && this.getLimitCheckedIV() == this.limitCheckedIV) : "Only inverted loops must have different body ivs.";
        return this.limitCheckedIV;
    }

    public ValueNode getBodyIVExtremum() {
        return this.getBodyIV().extremumNode(true, StampFactory.forKind(JavaKind.Long));
    }

    public ValueNode getBodyIVExitValue() {
        return this.getBodyIV().exitValueNode();
    }

    public boolean getBodyIVEqualsLimitCheckedIV() {
        return this.getBodyIV() == this.getLimitCheckedIV();
    }

    public ValueNode limitCheckedPreviousOrRootEntryValue() {
        if (this.getBodyIVEqualsLimitCheckedIV()) {
            InductionVariable limitCheckedIVDuplicated = InductionVariableHelper.previousIteration(this.getLimitCheckedIV()).duplicate();
            return limitCheckedIVDuplicated.entryTripValue();
        }
        InductionVariable limitCheckedIVDuplicated = this.loop.counted().getBodyIV().duplicate();
        return limitCheckedIVDuplicated.entryTripValue();
    }

    public ValueNode getLimit() {
        return this.limit;
    }

    public ValueNode getTripCountLimit() {
        assert (!this.isInverted() && this.getLimit() == this.limit) : "Only inverted loops must have a different trip count limit";
        return this.limit;
    }

    private void assertNoOverflow() {
        GraalError.guarantee(this.loopCanNeverOverflow(), "Counter must never overflow when reasoning about trip counts of a loop");
    }

    public ValueNode maxTripCountNode() {
        this.assertNoOverflow();
        return this.maxTripCountNode(false);
    }

    public boolean isUnsignedCheck() {
        return this.unsigned;
    }

    public ValueNode maxTripCountNode(boolean assumeLoopEntered) {
        this.assertNoOverflow();
        return this.maxTripCountNode(assumeLoopEntered, this.getCounterIntegerHelper());
    }

    protected ValueNode maxTripCountNode(boolean assumeLoopEntered, IntegerHelper integerHelper) {
        this.assertNoOverflow();
        return this.maxTripCountNode(assumeLoopEntered, integerHelper, this.getBodyIVStart(), this.getTripCountLimit());
    }

    public ValueNode maxTripCountNode(boolean assumeLoopEntered, IntegerHelper integerHelper, ValueNode initNode, ValueNode tripCountLimit) {
        ValueNode min;
        ValueNode max;
        ValueNode absStride;
        this.assertNoOverflow();
        StructuredGraph graph = this.getLimitCheckedIV().valueNode().graph();
        Stamp stamp = this.getLimitCheckedIV().valueNode().stamp(NodeView.DEFAULT);
        InductionVariable.Direction direction = this.getLimitCheckedIV().direction();
        if (direction == InductionVariable.Direction.Up) {
            absStride = this.getLimitCheckedIV().strideNode();
            max = tripCountLimit;
            min = initNode;
        } else {
            assert (direction == InductionVariable.Direction.Down) : "direction must be down if its not up - else loop should not be counted " + String.valueOf((Object)direction);
            absStride = NegateNode.create(this.getLimitCheckedIV().strideNode(), NodeView.DEFAULT);
            max = initNode;
            min = tripCountLimit;
        }
        ValueNode range = BinaryArithmeticNode.sub(max, min);
        ConstantNode one = ConstantNode.forIntegerStamp(stamp, 1L, graph);
        if (this.isLimitIncluded) {
            range = BinaryArithmeticNode.add(range, one);
        }
        ValueNode denominator = BinaryArithmeticNode.add(graph, range, BinaryArithmeticNode.sub(absStride, one), NodeView.DEFAULT);
        boolean divisorNonZero = true;
        ValueNode div = MathUtil.unsignedDivBefore(graph, true, this.loop.entryPoint(), denominator, absStride, null);
        if (assumeLoopEntered) {
            return graph.addOrUniqueWithInputs(div);
        }
        ConstantNode zero = ConstantNode.forIntegerStamp(stamp, 0L, graph);
        LogicNode noEntryCheck = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(max, min, NodeView.DEFAULT));
        ValueNode pi = this.findOrCreatePositivePi(noEntryCheck, div, graph, this.loop.loopsData().getCFG());
        if (pi != null) {
            return pi;
        }
        return graph.addOrUniqueWithInputs(ConditionalNode.create(noEntryCheck, zero, div, NodeView.DEFAULT));
    }

    private ValueNode findOrCreatePositivePi(LogicNode noEntryCheck, ValueNode div, StructuredGraph graph, ControlFlowGraph cfg) {
        Stamp positiveIntStamp = StampFactory.positiveInt();
        if (!positiveIntStamp.isCompatible(div.stamp(NodeView.DEFAULT))) {
            return null;
        }
        if (cfg.getNodeToBlock().isNew(this.loop.loopBegin())) {
            return null;
        }
        HIRBlock loopBlock = cfg.blockFor(this.loop.loopBegin());
        for (Node checkUsage : noEntryCheck.usages()) {
            FixedWithNextNode candidateCheck = null;
            if (checkUsage instanceof IfNode) {
                IfNode ifCheck = (IfNode)checkUsage;
                candidateCheck = ifCheck.falseSuccessor();
            } else {
                FixedGuardNode guard;
                if (!(checkUsage instanceof FixedGuardNode) || !(guard = (FixedGuardNode)checkUsage).isNegated()) continue;
                candidateCheck = guard;
            }
            if (cfg.getNodeToBlock().isNew(candidateCheck) || !cfg.blockFor(candidateCheck).dominates(loopBlock)) continue;
            return graph.addOrUniqueWithInputs(PiNode.create(div, positiveIntStamp.improveWith(div.stamp(NodeView.DEFAULT)), candidateCheck));
        }
        return null;
    }

    public boolean loopMightBeEntered() {
        LogicNode entryCheck;
        ValueNode min;
        ValueNode max;
        Stamp stamp = this.getLimitCheckedIV().valueNode().stamp(NodeView.DEFAULT);
        if (this.getLimitCheckedIV().direction() == InductionVariable.Direction.Up) {
            max = this.getTripCountLimit();
            min = this.getBodyIVStart();
        } else {
            assert (this.getLimitCheckedIV().direction() == InductionVariable.Direction.Down) : Assertions.errorMessage(this.getLimitCheckedIV());
            max = this.getBodyIVStart();
            min = this.getTripCountLimit();
        }
        if (this.isLimitIncluded) {
            StructuredGraph graph = this.getLimitCheckedIV().valueNode().graph();
            max = BinaryArithmeticNode.add(max, ConstantNode.forIntegerStamp(stamp, 1L, graph), NodeView.DEFAULT);
        }
        return !(entryCheck = this.getCounterIntegerHelper().createCompareNode(min, max, NodeView.DEFAULT)).isContradiction();
    }

    public boolean isConstantMaxTripCount() {
        return this.getTripCountLimit() instanceof ConstantNode && this.getLimitCheckedIV().isConstantInit() && this.getLimitCheckedIV().isConstantStride();
    }

    public UnsignedLong constantMaxTripCount() {
        assert (this.isConstantMaxTripCount());
        return new UnsignedLong(this.rawConstantMaxTripCount());
    }

    private long rawConstantMaxTripCount() {
        long absStride;
        long range;
        assert (this.getLimitCheckedIV().direction() != null);
        long endValue = this.getTripCountLimit().asJavaConstant().asLong();
        long initValue = this.getBodyIVStart().asJavaConstant().asLong();
        IntegerHelper helper = this.getCounterIntegerHelper(64);
        if (this.getLimitCheckedIV().direction() == InductionVariable.Direction.Up) {
            if (helper.compare(endValue, initValue) < 0) {
                return 0L;
            }
            range = endValue - this.getLimitCheckedIV().constantInit();
            absStride = this.getLimitCheckedIV().constantStride();
        } else {
            assert (this.getLimitCheckedIV().direction() == InductionVariable.Direction.Down) : Assertions.errorMessage(this.getLimitCheckedIV());
            if (helper.compare(initValue, endValue) < 0) {
                return 0L;
            }
            range = this.getLimitCheckedIV().constantInit() - endValue;
            absStride = -this.getLimitCheckedIV().constantStride();
        }
        if (this.isLimitIncluded) {
            ++range;
        }
        long denominator = range + absStride - 1L;
        return Long.divideUnsigned(denominator, absStride);
    }

    public IntegerHelper getCounterIntegerHelper() {
        IntegerStamp stamp = (IntegerStamp)this.getLimitCheckedIV().valueNode().stamp(NodeView.DEFAULT);
        return this.getCounterIntegerHelper(stamp.getBits());
    }

    public IntegerHelper getCounterIntegerHelper(int bits) {
        IntegerHelper helper = this.isUnsignedCheck() ? new UnsignedIntegerHelper(bits) : new SignedIntegerHelper(bits);
        return helper;
    }

    public boolean isExactTripCount() {
        return this.loop.getCFGLoop().getNaturalExits().size() == 1;
    }

    public ValueNode exactTripCountNode() {
        this.assertNoOverflow();
        assert (this.isExactTripCount());
        return this.maxTripCountNode();
    }

    public boolean isConstantExactTripCount() {
        assert (this.isExactTripCount());
        return this.isConstantMaxTripCount();
    }

    public UnsignedLong constantExactTripCount() {
        this.assertNoOverflow();
        assert (this.isExactTripCount());
        return this.constantMaxTripCount();
    }

    public String toString() {
        return (this.isInverted() ? "Inverted " : "") + "iv=" + String.valueOf(this.getLimitCheckedIV()) + " until " + String.valueOf(this.getTripCountLimit()) + (this.isLimitIncluded ? (this.getLimitCheckedIV().direction() == InductionVariable.Direction.Up ? "+1" : "-1") : "") + " bodyIV=" + String.valueOf(this.getLimitCheckedIV());
    }

    public IfNode getLimitTest() {
        return this.ifNode;
    }

    public ValueNode getBodyIVStart() {
        return this.getBodyIV().initNode();
    }

    public boolean isLimitIncluded() {
        return this.isLimitIncluded;
    }

    public AbstractBeginNode getBody() {
        return this.body;
    }

    public AbstractBeginNode getCountedExit() {
        if (this.getLimitTest().trueSuccessor() == this.getBody()) {
            return this.getLimitTest().falseSuccessor();
        }
        assert (this.getLimitTest().falseSuccessor() == this.getBody()) : Assertions.errorMessage(this, this.getLimitTest(), this.getLimitTest().falseSuccessor(), this.getBody());
        return this.getLimitTest().trueSuccessor();
    }

    public InductionVariable.Direction getDirection() {
        return this.getLimitCheckedIV().direction();
    }

    public GuardingNode getOverFlowGuard() {
        return this.loop.loopBegin().getOverflowGuard();
    }

    public boolean loopCanNeverOverflow() {
        return this.counterNeverOverflows() || this.getOverFlowGuard() != null;
    }

    public boolean counterNeverOverflows() {
        if (this.loop.loopBegin().canNeverOverflow()) {
            return true;
        }
        return this.ivCanNeverOverflow(this.getLimitCheckedIV());
    }

    public boolean ivCanNeverOverflow(InductionVariable iv) {
        if (iv != this.getLimitCheckedIV()) {
            if (iv.isConstantInit() && this.isConstantMaxTripCount() && iv.isConstantStride()) {
                try {
                    int bits = IntegerStamp.getBits(iv.valueNode().stamp(NodeView.DEFAULT));
                    long tripCountMinus1 = LoopUtility.subtractExact(bits, LoopUtility.tripCountSignedExact(this), 1L);
                    long stripTimesTripCount = LoopUtility.multiplyExact(bits, iv.constantStride(), tripCountMinus1);
                    long extremum = LoopUtility.addExact(bits, stripTimesTripCount, iv.initNode().asJavaConstant().asLong());
                    return true;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
            return false;
        }
        if (!this.isLimitIncluded && iv.isConstantStride() && Loop.absStrideIsOne(iv)) {
            return true;
        }
        if (this.loop.loopBegin().isProtectedNonOverflowingUnsigned()) {
            return true;
        }
        IntegerStamp endStamp = (IntegerStamp)this.getTripCountLimit().stamp(NodeView.DEFAULT);
        ValueNode strideNode = this.getLimitCheckedIV().strideNode();
        IntegerStamp strideStamp = (IntegerStamp)strideNode.stamp(NodeView.DEFAULT);
        IntegerHelper integerHelper = this.getCounterIntegerHelper();
        if (this.getDirection() == InductionVariable.Direction.Up) {
            long max = integerHelper.maxValue();
            return integerHelper.compare(endStamp.upperBound(), max - (strideStamp.upperBound() - 1L) - (long)(this.isLimitIncluded ? 1 : 0)) <= 0;
        }
        if (this.getDirection() == InductionVariable.Direction.Down) {
            long min = integerHelper.minValue();
            return integerHelper.compare(min + (1L - strideStamp.lowerBound()) + (long)(this.isLimitIncluded ? 1 : 0), endStamp.lowerBound()) <= 0;
        }
        return false;
    }

    public GuardingNode createOverFlowGuard() {
        GuardingNode overflowGuard = this.getOverFlowGuard();
        if (overflowGuard != null || this.counterNeverOverflows()) {
            return overflowGuard;
        }
        try (DebugCloseable position = this.loop.loopBegin().withNodeSourcePosition();){
            StructuredGraph graph = this.getLimitCheckedIV().valueNode().graph();
            LogicNode cond = this.createOverflowGuardCondition();
            SpeculationLog speculationLog = graph.getSpeculationLog();
            SpeculationLog.Speculation speculation = SpeculationLog.NO_SPECULATION;
            if (speculationLog != null) {
                SpeculationLog.SpeculationReason speculationReason = LoopBeginNode.LOOP_OVERFLOW_DEOPT.createSpeculationReason(graph.method(), this.getLimitCheckedIV().loop.loopBegin().stateAfter().bci);
                if (speculationLog.maySpeculate(speculationReason)) {
                    speculation = speculationLog.speculate(speculationReason);
                    LoopBeginNode.overflowSpeculationTaken.increment(graph.getDebug());
                } else {
                    GraalError.shouldNotReachHere("Must not create overflow guard for loop " + String.valueOf(this.loop.loopBegin()) + " where the speculation guard already failed, this can create deopt loops");
                }
            }
            assert (graph.getGuardsStage().allowsFloatingGuards());
            overflowGuard = graph.unique(new GuardNode(cond, AbstractBeginNode.prevBegin(this.loop.entryPoint()), DeoptimizationReason.LoopLimitCheck, DeoptimizationAction.InvalidateRecompile, true, speculation, null));
            this.loop.loopBegin().setOverflowGuard(overflowGuard);
            GuardingNode guardingNode = overflowGuard;
            return guardingNode;
        }
    }

    public LogicNode createOverflowGuardCondition() {
        LogicNode cond;
        StructuredGraph graph = this.getLimitCheckedIV().valueNode().graph();
        if (this.counterNeverOverflows()) {
            return LogicConstantNode.contradiction(graph);
        }
        IntegerStamp stamp = (IntegerStamp)this.getLimitCheckedIV().valueNode().stamp(NodeView.DEFAULT);
        IntegerHelper integerHelper = this.getCounterIntegerHelper();
        ConstantNode one = ConstantNode.forIntegerStamp(stamp, 1L, graph);
        if (this.getLimitCheckedIV().direction() == InductionVariable.Direction.Up) {
            ValueNode v1 = BinaryArithmeticNode.sub(ConstantNode.forIntegerStamp(stamp, integerHelper.maxValue()), BinaryArithmeticNode.sub(this.getLimitCheckedIV().strideNode(), one));
            if (this.isLimitIncluded) {
                v1 = BinaryArithmeticNode.sub(v1, one);
            }
            cond = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(v1, this.getTripCountLimit(), NodeView.DEFAULT));
        } else {
            assert (this.getLimitCheckedIV().direction() == InductionVariable.Direction.Down) : Assertions.errorMessage(this.getLimitCheckedIV());
            ValueNode v1 = BinaryArithmeticNode.add(ConstantNode.forIntegerStamp(stamp, integerHelper.minValue()), BinaryArithmeticNode.sub(one, this.getLimitCheckedIV().strideNode()));
            if (this.isLimitIncluded) {
                v1 = BinaryArithmeticNode.add(v1, one);
            }
            cond = graph.addOrUniqueWithInputs(integerHelper.createCompareNode(this.getTripCountLimit(), v1, NodeView.DEFAULT));
        }
        return cond;
    }

    public IntegerStamp getStamp() {
        return (IntegerStamp)this.getLimitCheckedIV().valueNode().stamp(NodeView.DEFAULT);
    }

    public boolean isInverted() {
        return false;
    }
}

