/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AccessFieldNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="StoreField#{p#field/s}")
public final class StoreFieldNode
extends AccessFieldNode
implements StateSplit,
Virtualizable,
Canonicalizable,
SingleMemoryKill {
    public static final NodeClass<StoreFieldNode> TYPE = NodeClass.create(StoreFieldNode.class);
    @Node.Input
    ValueNode value;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    public ValueNode value() {
        return this.value;
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value) {
        this(object, field, value, MemoryOrderMode.getMemoryOrder(field));
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, MemoryOrderMode memoryOrder) {
        super(TYPE, StampFactory.forVoid(), object, field, memoryOrder, false);
        this.value = value;
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, FrameState stateAfter) {
        super(TYPE, StampFactory.forVoid(), object, field, MemoryOrderMode.getMemoryOrder(field), false);
        this.value = value;
        this.stateAfter = stateAfter;
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, FrameState stateAfter, MemoryOrderMode memoryOrder) {
        this(object, field, value, stateAfter, memoryOrder, false);
    }

    public StoreFieldNode(ValueNode object, ResolvedJavaField field, ValueNode value, FrameState stateAfter, MemoryOrderMode memoryOrder, boolean immutable) {
        super(TYPE, StampFactory.forVoid(), object, field, memoryOrder, immutable);
        this.value = value;
        this.stateAfter = stateAfter;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.ordersMemoryAccesses() ? LocationIdentity.ANY_LOCATION : this.getLocationIdentity();
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualInstanceNode virtual;
        int fieldIndex;
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode && (fieldIndex = (virtual = (VirtualInstanceNode)alias).fieldIndex(this.field())) != -1) {
            tool.setVirtualEntry(virtual, fieldIndex, this.value());
            tool.delete();
        }
    }

    public FrameState getState() {
        return this.stateAfter;
    }

    @Override
    public NodeCycles estimatedNodeCycles() {
        if (this.ordersMemoryAccesses()) {
            return NodeCycles.CYCLES_8;
        }
        return super.estimatedNodeCycles();
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (!this.field.isStatic() && this.object.isNullConstant()) {
            return new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.NullCheckException);
        }
        return this;
    }
}

